// DialogCommon_OpenSave.h cJ/ۑ_CAO
#ifndef __WGC_DIALOGCOMMON_OPENSAVE__
#define __WGC_DIALOGCOMMON_OPENSAVE__

#include "./DialogCommon.h"
#include <vector>

#define STR_FILTER_ALL  _T("*.*")


_WGC_BEGIN                              // namespace wgc {


class DialogCommon_OpenSave : public DialogCommon
{
public:
	DialogCommon_OpenSave(HINSTANCE hResource, HWND hWndParent = NULL, LPCTSTR lpTemplate = NULL, const BOOL bOpen = TRUE, const DWORD dwFlags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY, const DWORD dwBufferSize = 65535);
	~DialogCommon_OpenSave(void);

	BOOL  IsReadOnly(void) const;
	DWORD GetFilterIndex(void) const;
	BOOL  GetNextPathName(LPTSTR lpszBuffer, const SIZE_T nSizeBuffer);

protected:
	const BOOL   m_bOpen;
	OPENFILENAME m_ofn;

	wgc::tstring_t m_strDirName;
	int            m_nFileOffset;

	std::vector<TCHAR> m_buffer;

	// Iy[V
	BOOL CreateCommonDialog_Modal   (const LPARAM dwInitParam, INT_PTR &iResult);
	BOOL CreateCommonDialog_Modeless(const LPARAM dwInitParam, INT_PTR &iResult);

private:
	// Rs[RXgN^AZq͎gps
	DISABLE_COPY(DialogCommon_OpenSave)
};

_WGC_END                                // }

#endif // __WGC_DIALOGCOMMON_OPENSAVE__
