// DialogCommon_PropertySheet.cpp cCve[Vt@C
#include "DialogCommon_PropertySheet.h"
#include "TabCtrl.h"
#include "wgfunc.h"


_WGC_BEGIN                              // namespace wgc {


////////////////////////////////////////////////////////////////////////////////
// \z

// RXgN^
DialogCommon_PropertySheet::DialogCommon_PropertySheet(const UINT uCaptionID, HINSTANCE hResource, HWND hWndParent /* = NULL */, const UINT nStartPage /* = 0 */, const DWORD dwPshFlags /* = PSH_DEFAULT */)
	: DialogCommon(hResource, hWndParent, NULL), m_uCaptionID(uCaptionID), m_dwPshFlags(dwPshFlags), m_nStartPage(nStartPage)
{
	wgc::wgfLoadString(m_hResource, m_uCaptionID, m_caption);
}

// fXgN^
DialogCommon_PropertySheet::~DialogCommon_PropertySheet(void)
{
}


void DialogCommon_PropertySheet::SetSheets(LPPROPPAGE_OBJ pPageArray[], const int nSheetCount)
{
	m_vPropSheetPage.resize(nSheetCount);
	for(int i = 0; i < nSheetCount; i++)
	{
		pPageArray[i]->GetPropPage(m_vPropSheetPage[i]);
	}
}

void DialogCommon_PropertySheet::SetPSH(PROPSHEETHEADER &psh) const
{
	psh.dwSize     = sizeof(psh);
	psh.dwFlags    = PSH_PROPSHEETPAGE | (m_dwPshFlags & (PSH_HASHELP | PSH_NOAPPLYNOW | PSH_NOCONTEXTHELP));
	psh.hwndParent = m_hWndParent;
	psh.nStartPage = m_nStartPage;
	psh.nPages     = static_cast<int>(m_vPropSheetPage.size());
	psh.ppsp       =                 &m_vPropSheetPage[0];
	psh.hInstance  = m_hResource;
	psh.pszCaption = m_caption.c_str();
}


// [_\
BOOL DialogCommon_PropertySheet::CreateCommonDialog_Modal(const LPARAM /* dwInitParam */, INT_PTR &iResult)
{
	PROPSHEETHEADER psh;
	SetPSH(psh);

	iResult = ::PropertySheet(&psh);
	if(iResult < 0)
	{
		return FALSE;
	}
	return TRUE;
}

// [hX\
BOOL DialogCommon_PropertySheet::CreateCommonDialog_Modeless(const LPARAM /* dwInitParam */, INT_PTR & /* iResult */)
{
	// 
	return TRUE;
}


// Iy[V
HWND DialogCommon_PropertySheet::GetTabControl(void) const
{
	return PropSheet_GetTabControl(m_hWnd);
}

int DialogCommon_PropertySheet::GetCurSel(void) const
{
	TabCtrl ctrl(GetTabControl());
	return ctrl.GetCurSel();
}

_WGC_END                                // }
