// StatusBarCtrl.cpp cCve[Vt@C
#include "StatusBarCtrl.h"
#include "DeviceContext.h"              // wgc::DeviceContext
#include "wgfunc.h"                     // wgc::wgfLoadString()
#include <assert.h>                     // assert()


_WGC_BEGIN                              // namespace wgc {

// RXgN^
StatusBarCtrl::StatusBarCtrl(HWND hWnd /* = NULL */) : Control(hWnd)
{
}

// fXgN^
StatusBarCtrl::~StatusBarCtrl(void)
{
}


// Xe[^Xo[̍쐬
BOOL StatusBarCtrl::Create(
	Window *pParent,
	LPCTSTR lpszWindowName,
	const DWORD dwStyle          /* = WS_CHILD | WS_VISIBLE */,
	const DWORD dwCtlStyle       /* = CCS_BOTTOM */,
	const DWORD dwStatusBarStyle /* = SBARS_SIZEGRIP */,
	const DWORD dwExStyle        /* = 0 */,
	const UINT  nID              /* = IDW_STD_STATUSBAR */)
{
	assert(pParent != NULL);

	return Control::Create(
		STATUSCLASSNAME, lpszWindowName,
		dwStyle, dwCtlStyle | dwStatusBarStyle,
		dwExStyle,
		pParent,
		nID);
}


// CWP[^ݒ
void StatusBarCtrl::SetIndicators(HINSTANCE hResource, const UINT nIDArray[], const int nCount)
{
	m_pane_width.resize(nCount);

	// e̕擾
	for(int i = 0; i < nCount; i++)
	{
		tstring_t text;
		wgfLoadString(hResource, nIDArray[i], text);

		SIZE size;
		DeviceContext_Client dc(m_hWnd);
		dc.GetTextExtent(text, size);

		m_pane_width[i] = size.cx;
	}

	UpdatePanePosition();
}


////////////////////////////////////////////////////////////////////////////////
// 

// Vv[h
void StatusBarCtrl::SetSimple(const BOOL bSimple /* = TRUE */)
{
	SendMessage(
		SB_SIMPLE,
		bSimple);
}

// E擾iSvf𓯎Ɂj
void StatusBarCtrl::GetBorders(int *pBorders) const
{
	assert(pBorders != NULL);
	const LRESULT lResult = SendMessage(
		SB_GETBORDERS,
		0,
		reinterpret_cast<LPARAM>(pBorders));
	if(!lResult)
	{
		wgfThrowLastError();
	}
}

// E擾ivfj
void StatusBarCtrl::GetBorders(int *pHorz, int *pVert, int *nSpacing) const
{
	int arBorders[3];
	GetBorders(arBorders);

	if(pHorz    != NULL) { *pHorz    = arBorders[0]; }
	if(pVert    != NULL) { *pVert    = arBorders[1]; }
	if(nSpacing != NULL) { *nSpacing = arBorders[2]; }
}

// yC쐬
void StatusBarCtrl::SetParts(const int nParts, int *pWidths)
{
	assert(pWidths != NULL);
	const LRESULT lResult = SendMessage(
		SB_SETPARTS,
		nParts,
		reinterpret_cast<LPARAM>(pWidths));
	if(!lResult)
	{
		wgfThrowLastError();
	}
}

// yC擾
int StatusBarCtrl::GetParts(const int nParts, int *pWidths) const
{
	assert(pWidths != NULL);
	const LRESULT lResult = SendMessage(
		SB_GETPARTS,
		nParts,
		reinterpret_cast<LPARAM>(pWidths));
	return static_cast<int>(lResult);
}

// eLXgo
void StatusBarCtrl::SetText(const int iPart, const int uType, const tstring_t &text, const BOOL bFlexible /* = FALSE */)
{
	const LRESULT lResult = SendMessage(
		SB_SETTEXT,
		iPart | uType,
		reinterpret_cast<LPARAM>(text.c_str()));
	if(!lResult)
	{
		wgfThrowLastError();
	}

	// V̕vZ
	if(bFlexible)
	{
		SIZE size;
		DeviceContext_Client dc(m_hWnd);
		dc.GetTextExtent(text, size);

		m_pane_width[iPart - 1] = size.cx;

		UpdatePanePosition();
	}
}

// `bveLXgݒ
void StatusBarCtrl::SetTipText(const int iPart, const tstring_t &text)
{
	SendMessage(
		SB_SETTIPTEXT,
		iPart,
		reinterpret_cast<LPARAM>(text.c_str()));
}


// qbgeXgiXN[Wj
int StatusBarCtrl::HitTest(const POINT &pt) const
{
	POINT pt2 = pt;
	ScreenToClient(pt2);

	RECT rc;
	GetClientRect(rc);
	if(!::PtInRect(&rc, pt2))
	{
		return -1;
	}

	intarray_t border(m_pane_width.size() + 1);
	GetParts(static_cast<int>(border.size()), &border[0]);
	for(size_t i = 0; i < border.size(); i++)
	{
		if(pt2.x < border[i])
		{
			return static_cast<int>(i);
		}
	}
	return -1;
}


////////////////////////////////////////////////////////////
// bZ[Wnh
void StatusBarCtrl::OnSize(const UINT nType, const int cx, const int cy)
{
	Control::OnSize(nType, cx, cy);
	UpdatePanePosition();
}


////////////////////////////////////////////////////////////
// private

// ̗̈vZ
void StatusBarCtrl::CalcInsideRect(RECT &rect) const
{
	GetClientRect(rect);

	// ő\łȂ΃TCYύẌl
	if(!::IsZoomed(GetParent()))
	{
		// TCYύẌ́AقڃNCAg̈̍Ɠ
		rect.right -= (rect.bottom - rect.top);
	}
}

// eyC̈ʒuXV
void StatusBarCtrl::UpdatePanePosition(void)
{
	// ACh\̈{CWP[^
	const size_t count = m_pane_width.size();
	intarray_t right_pos(count + 1);

	// {block}
	// ԉẼyC̍W
	{
		RECT rect;
		CalcInsideRect(rect);
		right_pos[count] = rect.right;
	}

	// ̑̃yC̍W
	for(size_t j = count; j > 0; j--)
	{
		right_pos[j - 1] = right_pos[j] - m_pane_width[j - 1];
	}

	SetParts(
		static_cast<int>(right_pos.size()),
		&right_pos[0]);
}

_WGC_END                                // }
