// EditDoc.h cGfBbgR|[lgihLgj
#ifndef __EDIT_DOC__
#define __EDIT_DOC__

#include "Edit.h"
#include "component/sgc/edit_manager.h" // sgc::edit_manager

#include <list>                         // std::list<>


// sgc::edit_managerōsobt@ɉA
// r[⃁Ct[Ƃ̘AgȂǁAWindowsˑs
class EditDoc
{
public:
	////////////////////////////////////////////////////////////
	// ^̒`
	typedef sgc::edit_manager::const_iterator_t const_iterator_t;
	typedef sgc::edit_manager::linenumber_t     linenumber_t;
	typedef sgc::position_t                     position_t;
	typedef sgc::edit_manager::select_cursor_t  select_cursor_t;

	typedef std::list<EditView *>      viewlist_t;
	typedef viewlist_t::iterator       viewlist_iterator_t;
	typedef viewlist_t::const_iterator viewlist_const_iterator_t;


	////////////////////////////////////////////////////////////
	// RXgNV
	EditDoc (wgc::Window *pMainFrame, const EDITVIEW_PROPERTY &rProperty, HCURSOR hCursorMargin = NULL);
	~EditDoc(void);

	BOOL CreateView(
		const BOOL bSetFocus,
		const DWORD dwStyle, const DWORD dwExStyle,
		const UINT nID,
		wgc::Window *pParent = NULL,
		HINSTANCE hInstance  = NULL,
		const int x = CW_USEDEFAULT,
		const int y = CW_USEDEFAULT,
		const int nWidth  = CW_USEDEFAULT,
		const int nHeight = CW_USEDEFAULT);
	void DestroyView(const UINT nIndex);

	void ResizeWindow(const int nID, const RECT &rRect);
	void SetFocusTo(const int nID = -1);

	void SetViewProperty(const EDITVIEW_PROPERTY &rProperty, const KEYWORD_INFO &rKeyword);
	void InvalidateAllViews(void);

	////////////////////////////////////////////////////////////
	// 
	INT_PTR GetNowLine(void) const;
	void    JumpToLine(const INT_PTR nLineNumber);

	void DragBegin(void);
	void DragEnd  (void);
	BOOL IsDropSource(void) const;

	////////////////////////////////////////////////////////////
	// 
	SIZE_T GetLineCount(void) const;
	SIZE_T FindWordBreak(const BOOL bForward = TRUE) const;
	BOOL IsBegin(void) const;
	BOOL IsEnd  (void) const;
	BOOL IsHead (void) const;
	BOOL IsTail (void) const;

	////////////////////////////////////////////////////////////
	// Ce[^
	const_iterator_t GetIterator     (const linenumber_t linenumber) const;
	const_iterator_t GetIteratorBegin(void) const;
	const_iterator_t GetIteratorEnd  (void) const;
	const_iterator_t GetIteratorNow  (void) const;

	////////////////////////////////////////////////////////////
	// ̐ݒ/擾
	BOOL SetReadOnly   (const BOOL bReadOnly = TRUE);
	BOOL ToggleReadOnly(void);
	BOOL IsReadOnly    (void) const;
	BOOL SetOverwrite   (const BOOL bOverwrite = TRUE);
	BOOL ToggleOverwrite(void);
	BOOL IsOverwrite    (void) const;
	BOOL SetModify (const BOOL bModify = TRUE);
	BOOL IsModified(void) const;

	////////////////////////////////////////////////////////////
	// Nbv{[h֘A
	void Cut(void);
	void Copy(const wchar_t cQuoteMark = sgc::charcode::wNUL);
	void Delete(const BOOL bDeleteCharIfEmpty = TRUE);
	void Paste(const wchar_t cQuoteMark = sgc::charcode::wNUL);
	BOOL CanPaste(const UINT uFormat = 0) const;

	////////////////////////////////////////////////////////////
	// ҏW
	BOOL    Undo(void);
	BOOL    Redo(void);
	BOOL    CanUndo(void) const;
	BOOL    CanRedo(void) const;
	INT_PTR SetUndoLimit(const INT_PTR nLimit = -1);
	void    EmptyUndoBuffer(void);

	BOOL SetText       (const wgc::wstring_t &wtext);
	BOOL SetText       (LPCWSTR lpText, const SIZE_T lSize);
	BOOL InsertText    (const wgc::wstring_t &wtext       , const wchar_t cQuoteMark = sgc::charcode::wNUL, const sgc::edit_manager::move_select_t select_status = sgc::edit_manager::MS_CLEAR);
	BOOL InsertText    (LPCWSTR lpText, const SIZE_T lSize, const wchar_t cQuoteMark = sgc::charcode::wNUL, const sgc::edit_manager::move_select_t select_status = sgc::edit_manager::MS_CLEAR);
	BOOL InsertLinefeed(void);
	BOOL InputString   (const wgc::wstring_t &wstr);
	BOOL DeleteChar    (const BOOL bForward = TRUE);
	BOOL DeleteLine    (void);

	////////////////////////////////////////////////////////////
	// I
	BOOL IsSelected(void) const;
	void SelectWord(const select_cursor_t cursor_pos = sgc::edit_manager::SC_NOMOVE, const BOOL bUpdateSelection = FALSE);
	void SelectLine(const select_cursor_t cursor_pos = sgc::edit_manager::SC_NOMOVE, const BOOL bUpdateSelection = FALSE);
	void SelectAll(void);
	void ClearSelection(const select_cursor_t cursor_pos = sgc::edit_manager::SC_NOMOVE);
	BOOL DeleteSelection(const BOOL bMoveCursor = FALSE);
	void GetSelectedRange(position_t &sel_begin, position_t &sel_end) const;
	void GetSelectedText (wgc::tstring_t &ttext, const wchar_t cQuoteMark = sgc::charcode::wNUL) const;
	void GetSelectedTextA(wgc:: string_t & text, const wchar_t cQuoteMark = sgc::charcode::wNUL) const;
	void GetSelectedTextW(wgc::wstring_t &wtext, const wchar_t cQuoteMark = sgc::charcode::wNUL) const;

	////////////////////////////////////////////////////////////
	// ̑
	void Reconvert(void);

private:
	wgc::Window       *m_pMainFrame;           // Ct[
	EDITVIEW_PROPERTY  m_property;             // r[vpeB
	KEYWORD_INFO       m_keyword;

	sgc::edit_manager m_manager;               // GfBbg}l[W
	BOOL              m_bOverwrite;            // ㏑tO

	// \[Xnh
	HFONT   m_hFont;
	HCURSOR m_hCursorMargin;

	// r[
	viewlist_t m_listView;
	EditView  *m_pActiveView;

	// OLEhbOhbv
	BOOL m_bDropSource;

	// JbgW
	position_t GetXY(void) const;
	void       SetXY(const position_t &position, const sgc::edit_manager::move_select_t select_status = sgc::edit_manager::MS_CLEAR, const BOOL bUpdateInternalX = TRUE);
	INT_PTR    GetX (void) const;
	INT_PTR    GetY (void) const;
	INT_PTR    SetX (const INT_PTR x, const sgc::edit_manager::move_select_t select_status = sgc::edit_manager::MS_CLEAR, const BOOL bSyncCaret = TRUE, const BOOL bUpdateInternalX = TRUE);
	INT_PTR    SetY (const INT_PTR y, const sgc::edit_manager::move_select_t select_status = sgc::edit_manager::MS_CLEAR, const BOOL bSyncCaret = TRUE);
	INT_PTR    SetXRelative(const INT_PTR dx, const sgc::edit_manager::move_select_t select_status = sgc::edit_manager::MS_CLEAR, const BOOL bSyncCaret = TRUE, const BOOL bUpdateInternalX = TRUE);
	INT_PTR    SetYRelative(const INT_PTR dy, const sgc::edit_manager::move_select_t select_status = sgc::edit_manager::MS_CLEAR, const BOOL bSyncCaret = TRUE);

	EditView *GetViewFromID(const int nID) const;

	void PostModify(const sgc::edit_manager::modify_info &mi);
	void PostModify(const linenumber_t lineModify, const BOOL bUpdateLineNumber = FALSE);
	void PostUpdateCursorPos(const BOOL bUpdateSelection = FALSE);
	void PostUpdateSelection(void);

	LRESULT SendNotifyCommandToMainFrame(const WORD wNotify);

	static HFONT CreateInfoFont(const FONT_INFO &info);
	static BOOL  SetClipboard(wgc::Clipboard &cb, const CLIPFORMAT cfFormat, LPCVOID lpData, const SIZE_T dwSize);

private:
	// Rs[RXgN^AZq͎gps
	DISABLE_COPY(EditDoc)

	friend class EditView;
};

#endif // __EDIT_DOC__
