// MainFrame.h
#ifndef __MAINFRAME__
#define __MAINFRAME__

#include "Common.h"
#include "EditDoc.h"
#include "CommandInterface.h"
#include <list>                         // std::list<>
#include <memory>                       // std::auto_ptr<>


// r[h
#define EXCLUSION_NONE              0
#define EXCLUSION_DISABLEWRITE      1
#define EXCLUSION_DISABLEREADWRITE  2

// EChEbZ[W
#define MAXY_GETPATHNAME            (WM_USER + 100)
#define MAXY_REFRECT_FRAME          (WM_USER + 101)
#define MAXY_REFRECT_VIEW           (WM_USER + 102)
#define MAXY_BACKUP_UNSAVED_FILE    (WM_USER + 103)


// Ct[iʒuj
typedef struct tagMAINFRAME_PROPERTY
{
	// t@C
	typedef struct tagFILE
	{
		DWORD dwExclusionMode;                  // r[h
		union
		{
			DWORD dwAll;
			struct
			{
				unsigned bCheckTimeStampOnActive : 1;   // ANeBuɃ^CX^v`FbN
				unsigned bOpenByThisFrame        : 1;   // ɂ̃EChEŊJ
			} elements;
		} flags;
	} FILE;

	typedef struct tagDISPLAY
	{
		union
		{
			DWORD dwAll;
			struct
			{
				unsigned bRestorePlacement          : 1;// NɃEChEʒuƃTCY𕜌
				unsigned bDisplayFullpathOnActive   : 1;// ANeBuA^Cgo[ɃtpX\
				unsigned bDisplayFullpathOnInactive : 1;// ANeBuA^Cgo[ɃtpX\
			} elements;
		} flags;
	} DISPLAY;

	typedef struct tagOTHER
	{
		wgc::tstring_t strBackupPrefix;         // obNAbvvtBbNX
		union
		{
			DWORD dwAll;
			struct
			{
				unsigned bBackupWhenCrushed : 1;        // NbVɃobNAbvۑ
			} elements;
		} flags;
	} OTHER;

	UINT    nStartPage;                     // _CAO쐬̃ftHgy[W
	FILE    stFile;
	DISPLAY stDisplay;
	OTHER   stOther;
} MAINFRAME_PROPERTY;

typedef struct tagCREATEFRAME_PARAMETER
{
	int     nCmdShow;

	TCHAR   szPathName[MAX_PATH];
	BOOL    bReadOnly;
	INT_PTR nLineNumber;
	int     nCodePage;
} CREATEFRAME_PARAMETER, *LPCREATEFRAME_PARAMETER;


// Ct[NX
class MainFrame : public wgc::Window
{
private:
	MainFrame(void);
	~MainFrame(void);

public:
	static void Register(void);
	static BOOL IsMainFrame(HWND hWnd);

	static MainFrame *CreateFrame(const CREATEFRAME_PARAMETER *lpParameter, const LPWINDOWPLACEMENT lpWndPl);
	static void       DeleteFrame(MainFrame *pMainFrame);

	static HWND GetEditingFrame(LPCTSTR lpszPathName);

	static void BroadcastMessage(const BOOL bSend, UINT uMsg, WPARAM wParam = 0, LPARAM lParam = 0);

	void PreHandleMessage(void);

	int ErrorMessageBox(HRESULT hResult) const;

protected:

	////////////////////////////////////////////////////////////
	// EChEvV[W
	LRESULT WindowProc(UINT uMsg, WPARAM wParam, LPARAM lParam);


	////////////////////////////////////////////////////////////
	// z֐
	void PostNcDestroy(void);

	////////////////////////////////////////////////////////////
	// bZ[Wnh
	int  OnCreate(LPCREATESTRUCT lpCreateStruct);
	void OnClose(void);
	void OnDestroy(void);

	void OnEndSession(const BOOL bEnding, const BOOL bLogOff);

	void OnSize(const UINT nType, const int cx, const int cy);

	void OnActivate(const UINT nState, const BOOL bMinimized, HWND hWndPrevious);
	void OnSetFocus(HWND hWndLoseFocus);

	void OnInitMenu(HMENU hMenu);
	void OnMenuSelect(const UINT nItemID, const UINT nFlags, HMENU hSysMenu);
	void OnEnterMenuLoop(const BOOL bIsTrackPopupMenu);
	void OnExitMenuLoop (const BOOL bIsTrackPopupMenu);

	void OnDropFiles(HDROP hDrop);

	BOOL OnNotify(const int nIdCtrl, LPNMHDR lpNmHeader);
	BOOL OnCommand(const WORD wNotifyCode, const WORD wID, HWND hWndCtrl);

	void OnSysColorChange(void);

	// ƎbZ[W
	void OnMaxyGetPathName(LPTSTR lpszPathName, const SIZE_T cchPathName) const;
	void OnMaxyRefrectFrame(void);
	void OnMaxyRefrectView (const UINT_PTR uIndex);
	void OnMaxyBackupUnsavedFile(void);


	////////////////////////////////////////////////////////////
	// R}hnh

	// t@C
	void OnCommandFileNew            (void);
	void OnCommandFileOpen           (void);
	void OnCommandFileSave           (void);
	void OnCommandFileSaveAs         (void);
	void OnCommandFileSaveAll        (void);
	void OnCommandFileClose          (void);
	void OnCommandFileCloseAll       (void);
	void OnCommandFilePrint          (void);
	void OnCommandFilePrintPreview   (void);
	void OnCommandFileOpenWithCPRange(const int nID);
	void OnCommandFileSaveWithCPRange(const int nID);
	void OnUpdateFileOpenWithCPRange (const command_interface &ci) const;
	void OnUpdateFileSave            (const command_interface &ci) const;
	BOOL IsEnabledFileOpenWithCPRange(void) const;

	// ҏW
	void OnCommandEditUndo          (void);
	void OnCommandEditRedo          (void);
	void OnCommandEditCut           (void);
	void OnCommandEditCopy          (void);
	void OnCommandEditCopyWithQuote (void);
	void OnCommandEditDelete        (void);
	void OnCommandEditPaste         (void);
	void OnCommandEditPasteWithQuote(void);
	void OnCommandEditSelectAll     (void);
	void OnCommandEditSelectCancel  (void);
	void OnCommandEditReconvert     (void);
	void OnCommandEditJump          (void);
	void OnCommandEditReadonly      (void);
	void OnUpdateEditUndo        (const command_interface &ci) const;
	void OnUpdateEditRedo        (const command_interface &ci) const;
	void OnUpdateEditPaste       (const command_interface &ci) const;
	void OnUpdateEditSelectCancel(const command_interface &ci) const;
	void OnUpdateEditReconvert   (const command_interface &ci) const;
	void OnUpdateEditReadonly    (const command_interface &ci) const;
	BOOL IsEnabledEditReadonly(void) const;

	// \
	void OnCommandViewBarToolbar  (void);
	void OnCommandViewBarStatusbar(void);
	void OnCommandViewTopmost     (void);
	void OnUpdateViewBar    (const command_interface &ci) const;
	void OnUpdateViewTopmost(const command_interface &ci) const;

	// ݒ
	void OnCommandSettingChange      (const int nID);
	void OnCommandSettingChangeCreate(void);
	void OnCommandSettingProperty    (void);
	void OnCommandSettingCustomize   (void);
	void OnUpdateSettingChange  (const command_interface &ci) const;
	void OnUpdateSettingProperty(const command_interface &ci) const;

	// wv
	void OnCommandHelpIndex  (void);
	void OnCommandHelpKeyword(void);
	void OnCommandHelpFinder (void);
	void OnCommandHelpWebpage(void);
	void OnCommandHelpAbout  (void);


	// ʒmbZ[W
	void OnNotifyXENReadonlyChanged (void);
	void OnNotifyXENOverwriteChanged(void);
	void OnNotifyXENModifyChanged   (void);

	BOOL HandleNotifyMessage_Edit     (LPNMHDR lpNmHeader);
	BOOL HandleNotifyMessage_StatusBar(LPNMHDR lpNmHeader);

private:
	// qEChE
	wgc::ToolBarCtrl    m_cToolBar;             // c[o[
	wgc::StatusBarCtrl  m_cStatusBar;           // Xe[^Xo[

	// GfBbgR|[lg
	typedef std::auto_ptr<EditDoc> EditDocPtr;
	EditDocPtr m_pEditDoc;

	// IMultiLanguage2IuWFNgiCOMj
	wxc::COM_XMultiLanguage2 *m_pMultiLanguage2;

	// fBNgEt@C
	wgc::tstring_t m_strDirName;            // ҏW̃t@C̃fBNg
	wgc::tstring_t m_strFileName;           // ҏW̃t@C
	HANDLE m_hFile;                         // t@CnhirAXV`FbNŎgpj

	// r[vpeB̃^Cv
	UINT_PTR m_uViewPropertyType;

	// R[hy[W
	wxc::COM_XMultiLanguage2::MIMECPINFO_vector_t m_cp_import, m_cp_export;
	UINT m_uCodePage;                       // ݕҏW̃t@C̃R[hy[W
	UINT m_uCodePageIndex;
	BOOL m_bBom;                            // BOMĂ邩HiUnicodê݁j

	// XV
	FILETIME m_ftUpdate;

	// tO
	BOOL m_bActive;                         // EChEANeBuH
	BOOL m_bCloseAll;                       // uׂĕvIꂽH

	// qEChE쐬[`
	UINT GetNewViewID(void) const;

	BOOL CreateControlBar(void);
	BOOL CreateToolBarStandard(void);
	BOOL CreateStatusBar(void);
	BOOL CreateEditComponent(void);

	BOOL AppendCodePageMenu(const wxc::COM_XMultiLanguage2::MIMECPINFO_vector_t &v_mcpi, const UINT uiCommandFirst);

	BOOL AppendSettingMenu(void);
	BOOL DeleteSettingMenu(void);

	void SetToolTip(const int nIdCtrl, LPTOOLTIPTEXT lpToolTipText);

	// c[o[̑
	void ToolSaveRestore(const BOOL bSave = TRUE);

	// Xe[^Xo[̑
	void SetStatusIndicator(void);
	void SetStatusMessageIdle(void);
	void SetStatusMessageCommand(const UINT nID, const UINT nFlags);
	void SetStatusMessageReadonly(void);
	void SetStatusMessageOverwrite(void);
	void SetStatusMessageCodePage(void);

	// t@C
	static UINT_PTR FindFilterIndex(LPCTSTR lpszFileName);
	static HANDLE OpenForExclusion(LPCTSTR lpszPathName, const DWORD dwExclusion);

	void SetCodePage(const UINT uCodePage = 0);

	BOOL Open(LPCTSTR lpszPathName = NULL, const int nCodePage = CODEPAGE_SPECIFY, const BOOL bReadOnly = FALSE, const INT_PTR nFilterIndex = -1);
	void OpenDocumentFile(LPCTSTR lpszPathName, const INT_PTR nIndex = -1, const BOOL bReadOnly = TRUE, const UINT uCodePage = CODEPAGE_ERROR);
	void ReadTextData(wgc::File &rFile, const UINT uCodePage, const BOOL bReload = FALSE);
	void SetText(LPCSTR lpszData, const DWORD dwFileSize, const UINT uCodePage);
	UINT DetectCodePage(LPCSTR lpszData, const DWORD dwFileSize, const UINT uCodePage, UINT &rOffset);

	BOOL Save(const BOOL bSaveAs = FALSE);
	void SaveDocumentFile(LPCTSTR lpszPathName);
	void WriteTextData(wgc::File &rFile);
	void SetBuffer(wgc::File &rFile, const BOOL bAlwaysUseDefaultLFCode, const sgc::charcode::linefeed_t lfDefault) const;
	BOOL CanConvertCodePage(void) const;

	BOOL BackupUnsavedFile(void);

	// bZ[W{bNX֘A
	int MessageBox_AskToSave  (void) const;
	int MessageBox_AskToReload(void) const;
	int MessageBox_NoInterface(const BOOL bOpen) const;

	wgc::tstring_t GetPathName(void) const;
	void           GetTimeStamp(FILETIME &rStamp) const;
	BOOL           IsUpdated(const BOOL bUpdateTimeStamp = TRUE);

	// GfBbgR|[lg̑
	void GetEditRect(RECT &rect);
	void RecalcEditLayout(void);

	void SetPathName(LPCTSTR lpszPathName);

	void UpdateFrameTitle(void);
	void UpdateCommand(const command_interface &ci);

	// ݒ𔽉f
	void ReloadSetting(void);
	void RefrectSetting_Frame(void);
	void RefrectSetting_View(void);

	static void SendHelpMessage(const UINT uCommand);

	// ::EnumWindows() ֓nvV[W
	typedef struct tagFINDWINDOW
	{
		HWND    hWnd;
		LPCTSTR lpszPathName;
	} FINDWINDOW, *LPFINDWINDOW;
	static BOOL CALLBACK FindWindowProc(HWND hWnd, LPARAM lParam);

	typedef struct tagBROADCASTPARAM
	{
		BOOL   bSend;
		UINT   uMsg;
		WPARAM wParam;
		LPARAM lParam;
	} BROADCASTPARAM, *LPBROADCASTPARAM;
	static BOOL CALLBACK BroadcastProc(HWND hWnd, LPARAM lParam);
};

#endif // __MAINFRAME__
