// DialogCommon.cpp cCve[Vt@C
#include "wgfunc.h"
#include "DialogCommon.h"


_WGC_BEGIN                              // namespace wgc {


////////////////////////////////////////////////////////////////////////////////
// \z

// RXgN^
DialogCommon::DialogCommon(HINSTANCE hResource, HWND hWndParent /* = NULL */, LPCTSTR lpTemplate /* = NULL */)
	: Dialog(hResource, lpTemplate, hWndParent)
{
}

// fXgN^
DialogCommon::~DialogCommon(void)
{
}


// [__CAO\
INT_PTR DialogCommon::DoModal(const LPARAM dwInitParam /* = 0 */)
{
	_SetHookTarget(this);
	INT_PTR iResult = 0;
	const BOOL bResult = CreateCommonDialog_Modal(dwInitParam, iResult);
	if(!bResult)
	{
		_SetHookTarget(NULL);
		wgfThrowLastError();
	}

	return iResult;
}

// [hX_CAO\
BOOL DialogCommon::DoModeless(const LPARAM dwInitParam /* = 0 */)
{
	_SetHookTarget(this);
	INT_PTR iResult = 0;
	const BOOL bResult = CreateCommonDialog_Modeless(dwInitParam, iResult);
	if(!bResult)
	{
		_SetHookTarget(NULL);
		wgfThrowLastError();
	}

	return static_cast<BOOL>(iResult);
}


////////////////////////////////////////////////////////////////////////////////
// TuNX
void DialogCommon::Subclass(HWND hWnd)
{
	Window::Subclass(hWnd);
}

void DialogCommon::Unsubclass(void)
{
	Window::Unsubclass();
}


////////////////////////////////////////////////////////////////////////////////
// bZ[Wnh

BOOL DialogCommon::OnCommand(const WORD wNotifyCode, const WORD wID, HWND hWndCtrl)
{
	switch(wID)
	{
	case IDAPPLY:
		OnApply();
		return FALSE;

	case IDHELP:
		OnHelp();
		return FALSE;
	}
	return Dialog::OnCommand(wNotifyCode, wID, hWndCtrl);
}

LRESULT DialogCommon::_Default(void)
{
	return Window::_Default();
}


////////////////////////////////////////////////////////////////////////////////
// W{^̏
// EndDialog() ĂяoĂ̓_

// OK{^
void DialogCommon::OnOK(void)
{
	_Default();
}

// LZ{^
void DialogCommon::OnCancel(void)
{
	_Default();
}

// Kp{^
void DialogCommon::OnApply(void)
{
	_Default();
}

// wv{^
void DialogCommon::OnHelp(void)
{
	_Default();
}

_WGC_END                                // }
