// HTMLHelp.cpp
#include "HTMLHelp.h"
#include <shlwapi.h>                    // ::PathRenameExtension()
#include <tchar.h>


// ǉ̃NCu
#pragma comment(lib, "HtmlHelp.lib")
#pragma comment(lib, "shlwapi.lib")


_WGC_BEGIN                              // namespace wgc {

/*
#define HH_SET_WIN_TYPE         0x0004
#define HH_GET_WIN_TYPE         0x0005
#define HH_GET_WIN_HANDLE       0x0006
#define HH_ENUM_INFO_TYPE       0x0007  // Get Info type name, call repeatedly to enumerate, -1 at end
#define HH_SET_INFO_TYPE        0x0008  // Add Info type to filter.
#define HH_SYNC                 0x0009
#define HH_RESERVED1            0x000A
#define HH_RESERVED2            0x000B
#define HH_RESERVED3            0x000C
#define HH_KEYWORD_LOOKUP       0x000D
#define HH_DISPLAY_TEXT_POPUP   0x000E  // display string resource id or text in a popup window
#define HH_HELP_CONTEXT         0x000F  // display mapped numeric value in dwData
#define HH_TP_HELP_CONTEXTMENU  0x0010  // text popup help, same as WinHelp HELP_CONTEXTMENU
#define HH_TP_HELP_WM_HELP      0x0011  // text popup help, same as WinHelp HELP_WM_HELP
#define HH_CLOSE_ALL            0x0012  // close all windows opened directly or indirectly by the caller
#define HH_ALINK_LOOKUP         0x0013  // ALink version of HH_KEYWORD_LOOKUP
#define HH_GET_LAST_ERROR       0x0014  // not currently implemented // See HHERROR.h
#define HH_ENUM_CATEGORY        0x0015	// Get category name, call repeatedly to enumerate, -1 at end
#define HH_ENUM_CATEGORY_IT     0x0016  // Get category info type members, call repeatedly to enumerate, -1 at end
#define HH_RESET_IT_FILTER      0x0017  // Clear the info type filter of all info types.
#define HH_SET_INCLUSIVE_FILTER 0x0018  // set inclusive filtering method for untyped topics to be included in display
#define HH_SET_EXCLUSIVE_FILTER 0x0019  // set exclusive filtering method for untyped topics to be excluded from display
#define HH_SET_QUERYSERVICE     0x001E  // Set the Host IQueryService interface
#define HH_SET_GLOBAL_PROPERTY  0x00fc  // Set a global property. (NULL, NULL, HH_GPROP)
*/
namespace HTMLHelp
{
	// anonymous namespace
	namespace
	{
		const TCHAR CHM_EXT[] =  _T(".chm");

		DWORD g_dwCookie = 0;                   // NbL[
		TCHAR g_szHelpName[MAX_PATH];           // wvt@C
	}


	// 
	void Initialize(LPCTSTR lpszHelpName /* = NULL */)
	{
		::HtmlHelp(
			NULL,
			NULL,
			HH_INITIALIZE,
			reinterpret_cast<DWORD_PTR>(&g_dwCookie));

		// wvt@C擾
		if(lpszHelpName != NULL)
		{
			::lstrcpyn(g_szHelpName, lpszHelpName, MAX_PATH);
		}
		else
		{
			::GetModuleFileName(NULL, g_szHelpName, MAX_PATH);
			::PathRenameExtension(g_szHelpName, CHM_EXT);
		}
	}

	// I
	void Uninitialize(void)
	{
		::HtmlHelp(
			NULL,
			NULL,
			HH_UNINITIALIZE,
			g_dwCookie);
	}

	// bZ[W
	BOOL PreTranslateMessage(MSG &rMsg)
	{
		HWND hWnd = ::HtmlHelp(
			NULL,
			NULL,
			HH_PRETRANSLATEMESSAGE,
			reinterpret_cast<DWORD_PTR>(&rMsg));

		return hWnd != NULL;
	}

	HWND Display(HWND hWnd, const UINT uCommand, HH_FTS_QUERY &query)
	{
		return Execute(hWnd, uCommand, reinterpret_cast<DWORD_PTR>(&query));
	}

	HWND DisolayTopic (HWND hWnd, HH_FTS_QUERY &query)
	{
		return Display(hWnd, HH_DISPLAY_TOPIC, query);
	}

	HWND DisplayToc(HWND hWnd, HH_FTS_QUERY &query)
	{
		return Display(hWnd, HH_DISPLAY_TOC, query);
	}

	HWND DisplayIndex(HWND hWnd, HH_FTS_QUERY &query)
	{
		return Display(hWnd, HH_DISPLAY_INDEX, query);
	}

	HWND DisplaySearch(HWND hWnd, HH_FTS_QUERY &query)
	{
		return Display(hWnd, HH_DISPLAY_SEARCH, query);
	}

	// s
	HWND Execute(HWND hWnd, const UINT uCommand, const DWORD_PTR dwData /* = 0 */)
	{
		return ::HtmlHelp(
			hWnd,
			g_szHelpName,
			uCommand,
			dwData);
	}
}

_WGC_END                                // }
