// EditView.cpp cCve[Vt@C
// @Windows 9x łgp\UnicodeΉAPI ::TextOutW(), ::ExtTextOutW(), ::GetCharWidthW() gp
#include "EditView.h"
#include "EditDoc.h"
#include <windowsx.h>
#include <assert.h>                     // assert()
#include <wchar.h>                      // iswprint()
#include <algorithm>                    // std::max_element(), std::fill_n()

#include "./component/wgc/Imm.h"        // wgc::Imm
#include "./component/wgc/wgfunc.h"     // wgc::wgfMultiByteToWideChar()
#include "./component/wgc/wxc/COM_OleDropSource.h"
#include "./component/sgc/array.h"      // sgc::array<>
#include "./component/sgc/charcode.h"   // sgc::charcode::categorize()
#include "./component/sgc/utility.h"    // sgc::utility::saturate()


#define CLASSNAME_EDITVIEW  _T("MaxyEditView")

#define TID_AUTOSCROLL  (0x293f)

// ftHgl
#define DEFAULT_FONT    GetStockFont(OEM_FIXED_FONT)    // Œsb`tHg

#define DEFAULT_LINENUMBER_COLS     5   // sԍ̌


////////////////////////////////////////////////////////////
// RXgNV

// RXgN^
EditView::EditView(
	EditDoc                 &rDocument,
	const EDITVIEW_PROPERTY &rProperty,
	HCURSOR hCursorMargin   /* = NULL */,
	HFONT   hFont           /* = NULL */)
	: m_rDocument(rDocument), m_property(rProperty),
	  m_hCursorMargin(hCursorMargin), m_hFont(hFont)
{
	////////////////////////////////////////////////////////////
	// ̏

	// ]̃J[\
	if(m_hCursorMargin == NULL)
	{
		m_hCursorMargin = ::LoadCursor(NULL, IDC_ARROW);
	}

	// tHg֘A
	if(m_hFont == NULL)
	{
		m_hFont = DEFAULT_FONT;
	}
	m_sizeFont.cx  = 1;
	m_sizeFont.cy  = 1;
	m_nNumWidthMax = INT_MIN;
	std::fill_n(m_lpCharWidthArray, countof(m_lpCharWidthArray), reinterpret_cast<LPINT>(NULL));

	m_sizeTextArea.cx = 1;
	m_sizeTextArea.cy = 1;

	// E_W
	m_ptCaret.x = m_ptCaretPrev.x = 0;
	m_ptCaret.y = m_ptCaretPrev.y = 0;
	m_nInternalX = 0;
	m_nLongestLine = 0;

	m_ptLogicalPrev.x = 0;
	m_ptLogicalPrev.y = 0;

	// OLEhbOhbv֘A
	m_cfAccept = 0;

	m_bSelectLine = FALSE;

	m_dwDblClkTickCount = 0;

	m_nColumnLeft = 0;

	m_nLineNumberTop  = 1;
	m_nLineNumberCols = DEFAULT_LINENUMBER_COLS;
	m_nLineCountPrev  = m_rDocument.GetLineCount();

	m_nTextMarginLeft  = m_property.infoText.nLeftMargin;
	m_nTextMarginRight = m_property.infoText.nRightMargin;

	m_cht = CHT_TEXT;
}

// fXgN^
EditView::~EditView(void)
{
	// Lp̊J
	FreeCharWidthArray();

	// \[X̊J
	// E::LoadCursor() Ń[hJ[\͔jႢȂ炵
	// EtHg̔j`͌Ăяoɂ
	// iftHgł̓XgbNtHggp̂ŔjKv͂Ȃj
	// A݂͓ɂ邱ƂȂ
}


// EChENX̓o^(static)
void EditView::Register(void)
{
	HINSTANCE hInstance = ::GetModuleHandle(NULL);
	HCURSOR   hCursor   = ::LoadCursor(NULL, IDC_IBEAM);

	// EChENX̓o^
	WNDCLASS wc;
	wc.style         = CS_DBLCLKS | CS_BYTEALIGNCLIENT | CS_BYTEALIGNWINDOW;
	wc.lpfnWndProc   = _WindowProcBase;
	wc.cbClsExtra    = 0;
	wc.cbWndExtra    = 0;
	wc.hInstance     = hInstance;
	wc.hIcon         = NULL;
	wc.hCursor       = hCursor;
	wc.hbrBackground = NULL;
	wc.lpszMenuName  = NULL;
	wc.lpszClassName = CLASSNAME_EDITVIEW;
	if(::RegisterClass(&wc) == 0)
	{
		wgc::wgfThrowLastError();
	}
}


BOOL EditView::Create(
	const DWORD dwStyle, const DWORD dwExStyle,
	wgc::Window *pParent,
	const UINT nID,
	HINSTANCE hInstance /* = NULL */,
	const int x /* = CW_USEDEFAULT */,
	const int y /* = CW_USEDEFAULT */,
	const int nWidth  /* = CW_USEDEFAULT */,
	const int nHeight /* = CW_USEDEFAULT */)
{
	const UINT_PTR nIDPtr = nID;
	return Window::Create(
		CLASSNAME_EDITVIEW, _T(""),
		dwStyle, dwExStyle,
		pParent,
		reinterpret_cast<HMENU>(nIDPtr),
		hInstance,
		x, y, nWidth, nHeight);
}

// vpeBݒ
void EditView::SetProperty(const EDITVIEW_PROPERTY &rProperty, const KEYWORD_INFO &rKeyword, HFONT hFont)
{
	m_property = rProperty;
	m_keyword  = rKeyword;

	// IMȄ
	if(m_property.infoText.flags.elements.bOpenIME)
	{
		wgc::Imm immcontext(m_hWnd);
		immcontext.SetOpenStatus();
	}

	SetFont(hFont);

	Invalidate();
	if(IsFocused())
	{
		// Jbg̈ʒuĐݒ
		m_ptCaret = LogicalToPhysical(m_rDocument.GetXY(), &m_nInternalX);
		MoveCaret_Physical(m_ptCaret);
	}
}

// Jbg̈ʒuĐݒ
void EditView::ResetCaretPos(void)
{
	MoveCaret_Physical(m_ptCaret);
}


////////////////////////////////////////////////////////////
// X^C

// sԍ\邩H
BOOL EditView::IsLineNumberVisible(void) const
{
	return m_property.flags.elements.bDisplayLineNumber;
}

// [[\邩H
BOOL EditView::IsRulerVisible(void) const
{
	return m_property.flags.elements.bDisplayRuler;
}

// J[\ʒuɉH
BOOL EditView::IsCursorUnderline(void) const
{
	return m_property.flags.elements.bDisplayUnderline;
}


////////////////////////////////////////////////////////////////
// EM_xxx

// _[eBtO擾
BOOL EditView::GetModify(void) const
{
	const LRESULT lResult = SendMessage(EM_GETMODIFY);
	return static_cast<BOOL>(lResult);
}

// _[eBtOݒ
void EditView::SetModify(const BOOL bModified /* = TRUE */)
{
	SendMessage(EM_SETMODIFY, bModified);
}

// ǂݎp̕t/
BOOL EditView::SetReadOnly(const BOOL bReadOnly /* = TRUE */)
{
	// F̃o֐g킸 ::SetWindowLong() Œ ES_READONLY X^CǉꍇA
	// ǂݎpƂ͂ȂȂB
	// K EM_SETREADONLY oRŃX^Cǉ邱ƁB
	const LRESULT lResult = SendMessage(EM_SETREADONLY, bReadOnly);
	return static_cast<BOOL>(lResult);
}

void EditView::SetMargins(const UINT nLeft, const UINT nRight)
{
	SendMessage(
		EM_SETMARGINS,
		EC_LEFTMARGIN | EC_RIGHTMARGIN,
		MAKELONG(nLeft, nRight));
}

DWORD EditView::GetMargins(void) const
{
	const LRESULT lResult = SendMessage(EM_GETMARGINS);
	return static_cast<DWORD>(lResult);
}

// obt@̍s擾
SIZE_T EditView::GetLineCount(void) const
{
	return SendMessage(EM_GETLINECOUNT);
}

// AhD
BOOL EditView::Undo(void)
{
	const LRESULT lResult = SendMessage(EM_UNDO);
	return static_cast<BOOL>(lResult);
}

// AhDł邩H
BOOL EditView::CanUndo(void) const
{
	const LRESULT lResult = SendMessage(EM_CANUNDO);
	return static_cast<BOOL>(lResult);
}

// hD
BOOL EditView::Redo(void)
{
	const LRESULT lResult = SendMessage(EM_REDO);
	return static_cast<BOOL>(lResult);
}

// hDł邩H
BOOL EditView::CanRedo(void) const
{
	const LRESULT lResult = SendMessage(EM_CANREDO);
	return static_cast<BOOL>(lResult);
}

// őAhD񐔂ݒ
INT_PTR EditView::SetUndoLimit(const INT_PTR nLimit /* = -1 */)
{
	return SendMessage(EM_SETUNDOLIMIT, nLimit);
}

// AhDobt@NA
void EditView::EmptyUndoBuffer(void)
{
	SendMessage(EM_EMPTYUNDOBUFFER);
}


// I͈͂؂ANbv{[hɃRs[
void EditView::Cut(void)
{
	SendMessage(WM_CUT);
}

// I͈͂Nbv{[hɃRs[
void EditView::Copy(void)
{
	SendMessage(WM_COPY);
}

// I͈͂폜
void EditView::Clear(void)
{
	SendMessage(WM_CLEAR);
}

// Nbv{[h̃f[^\t
void EditView::Paste(void)
{
	SendMessage(WM_PASTE);
}

// \tł邩H
BOOL EditView::CanPaste(const UINT uFormat /* = 0 */) const
{
	const LRESULT lResult = SendMessage(EM_CANPASTE, uFormat);
	return static_cast<BOOL>(lResult);
}

// ĕϊ
void EditView::Reconversion(void)
{
	SendMessage(EM_RECONVERSION);
}


////////////////////////////////////////////////////////////////
// OLE Drag & Drop
DWORD EditView::OnDragEnter(
	IDataObject  *pDataObject,
	const DWORD   dwKeyState,
	const POINTL & /* ptl */)
{
	const CLIPFORMAT cfAcceptArray[] = {CF_UNICODETEXT, CF_TEXT};
	for(SIZE_T i = 0; i < countof(cfAcceptArray); i++)
	{
		// wtH[}bg΃hbv̏
		FORMATETC etc = {cfAcceptArray[i], NULL, DVASPECT_CONTENT, -1, TYMED_HGLOBAL};
		if(pDataObject->QueryGetData(&etc) == S_OK)
		{
			m_cfAccept = etc.cfFormat;
			goto found;
		}
	}

	// wtH[}bgȂΏI
	m_cfAccept = 0;
	return DROPEFFECT_NONE;

found:                                  // wtH[}bg
	// hbOhbvp̃Jbg쐬
	CreateDnDCaret();
	ShowCaret();

	return GetDropEffect(dwKeyState);
}

DWORD EditView::OnDragOver(
	const DWORD   dwKeyState,
	const POINTL &ptl)
{
	// hbOhbv󂯓tH[}bg邩H
	if(m_cfAccept == 0)
	{
		return DROPEFFECT_NONE;
	}

	// {block}
	// J[\ړ
	{
		// }EXWJbg̕WvZ
		POINT pt = {ptl.x, ptl.y};
		ScreenToClient(pt);

		// Jbgړi_W͈ړȂj
		POINT      ptCaret;
		position_t ptLogical;
		UINT_PTR   nInternalX;
		CalcCaretPos(pt, ptCaret, ptLogical, nInternalX);
		MoveCaret_Physical(ptCaret);
	}

	return GetDropEffect(dwKeyState);
}

void EditView::OnDragLeave(void)
{
	m_cfAccept = 0;

	// Jbgj
	::DestroyCaret();
}

DWORD EditView::OnDrop(
	IDataObject  * pDataObject,
	const DWORD    dwKeyState,
	const POINTL & ptl)
{
	// eLXg擾
	wgc::wstring_t wtext;
	if(!GetUnicodeText(pDataObject, wtext))
	{
		return DROPEFFECT_NONE;
	}

	const DWORD dwDragResult = GetDropEffect(dwKeyState);

	// {block}
	// wWֈړ
	{
		// }EXWNCAgWvZ
		POINT pt = {ptl.x, ptl.y};
		ScreenToClient(pt);

		// NCAgW畨E_WvZ
		POINT      ptCaret;
		position_t ptLogical;
		UINT_PTR   nInternalX;
		CalcCaretPos(pt, ptCaret, ptLogical, nInternalX);

		// Jbgړ
		m_rDocument.SetXY(ptLogical, sgc::edit_manager::MS_NOCHANGE);
	}

	// ݂̃hLghbv\[X̏ꍇ
	if(m_rDocument.IsDropSource())
	{
		position_t sel_begin, sel_end, now = m_rDocument.GetXY();
		m_rDocument.GetSelectedRange(sel_begin, sel_end);

		// I͈͓Ƀhbv牽Ȃ
		if(sel_begin <= now && now < sel_end)
		{
			m_rDocument.ClearSelection();
			return DROPEFFECT_NONE;
		}
	}

	BOOL bStop = TRUE;
	if(dwDragResult == DROPEFFECT_MOVE && m_rDocument.IsDropSource())
	{
		// hLgֈړȂARs[OɑI͈͂폜
		m_rDocument.DeleteSelection();
		bStop = FALSE;
	}
	else
	{
		// łȂΑI͈͂NA
		m_rDocument.ClearSelection();
	}

	// }
	m_rDocument.InsertText(wtext, sgc::charcode::wNUL, sgc::edit_manager::MS_NOCHANGE, bStop);

	::DestroyCaret();
	Invalidate(FALSE);
	return dwDragResult;
}

// L[{[h̉Ԃ瑀
DWORD EditView::GetDropEffect(const DWORD dwKeyState) const
{
	if(dwKeyState & MK_CONTROL)
	{
		// CtrlĂ΃Rs[
		return DROPEFFECT_COPY;
	}

	if(dwKeyState & MK_SHIFT)
	{
		// ShiftĂΈړ
		return DROPEFFECT_MOVE;
	}

	// hbv\[XȂΈړ / łȂ΃Rs[
	return m_rDocument.IsDropSource() ? DROPEFFECT_MOVE : DROPEFFECT_COPY;
}

// UnicodeeLXg擾
BOOL EditView::GetUnicodeText(IDataObject *pDataObject, wgc::wstring_t &wtext) const
{
	FORMATETC etc = {m_cfAccept, NULL, DVASPECT_CONTENT, -1, TYMED_HGLOBAL};
	STGMEDIUM medium;
	if(pDataObject->GetData(&etc, &medium) != S_OK)
	{
		return FALSE;
	}

	LPCVOID lpData = ::GlobalLock(medium.hGlobal);
	switch(m_cfAccept)
	{
	case CF_UNICODETEXT:
		// UnicodeeLXĝ܂܎擾
		wtext = reinterpret_cast<LPCWSTR>(lpData);
		break;

	case CF_TEXT:
		// ANSIeLXgUnicodeeLXgɕϊ
		wgc::wgfMultiByteToWideChar(
			reinterpret_cast<LPCSTR>(lpData),
			wtext);
		break;
	}

	// n
	::GlobalUnlock(medium.hGlobal);
	::ReleaseStgMedium(&medium);

	return TRUE;
}


////////////////////////////////////////////////////////////////////////////////
// protected ֐


////////////////////////////////////////////////////////////
// _/[`

// Jbgʒu_Jbgʒu
EditView::position_t EditView::PhysicalToLogical(const POINT &pt, wgc::PUINDEX_T pInternalX /* = NULL */) const
{
	// ݍs擾
	EditDoc::const_iterator_t p = m_rDocument.GetIterator(pt.y + 1);

	// _WXV
	const SIZE_T nScrollX = m_nColumnLeft * GetFontWidth();
	const SIZE_T nScrollY = m_nLineNumberTop - 1;

	position_t position;
	position.x = CalcLogicalLength(p->c_str(), p->length(), m_ptCaret.x + nScrollX);
	position.y = m_ptCaret.y + nScrollY;

	if(pInternalX != NULL)
	{
		*pInternalX = CalcPhysicalLength(p->c_str(), position.x);
	}

	return position;
}

// _JbgʒuJbgʒu
POINT EditView::LogicalToPhysical(const position_t &position, LPUINT pInternalX /* = NULL */) const
{
	// ݍs擾
	EditDoc::const_iterator_t p = m_rDocument.GetIterator(position.y + 1);

	// J[\ʒuvZ
	const UINT x = CalcPhysicalLength(p->c_str(), position.x);
	POINT pt;
	pt.x = static_cast<long>(x);
	pt.y = static_cast<long>(position.y);

	// {block}
	// XN[ʂl
	{
		const SIZE_T nScrollX = m_nColumnLeft * GetFontWidth();
		const SIZE_T nScrollY = m_nLineNumberTop - 1;
		pt.x -= static_cast<LONG>(nScrollX);
		pt.y -= static_cast<LONG>(nScrollY);
	}

	if(pInternalX != NULL)
	{
		*pInternalX = x;
	}

	return pt;
}


// tHgTCY擾
UINT EditView::GetFontWidth(const BOOL bAddCharSpace /* = TRUE */) const
{
	UINT nWidth = m_sizeFont.cx;
	if(bAddCharSpace)
	{
		nWidth += m_property.infoText.nCharSpace;
	}
	return nWidth;
}

UINT EditView::GetFontHeight(const BOOL bAddLineSpace /* = TRUE */) const
{
	UINT nHeight = m_sizeFont.cy;
	if(bAddLineSpace)
	{
		// ̂߂+1
		nHeight += m_property.infoText.nLineSpace + 1;
	}
	return nHeight;
}

// IMẼtHgݒ
void EditView::SetImeFont(void)
{
	wgc::Imm immcontext(m_hWnd);
	immcontext.SetCompositionFont(GetFont());
}


// GfBbg̃Jbg쐬
void EditView::CreateEditCaret(void)
{
	const UINT nCaretHeight = GetFontHeight(FALSE);
	CreateSolidCaret(1, nCaretHeight);
}

// hbOhbṽJbg쐬
void EditView::CreateDnDCaret(void)
{
	const UINT nCaretHeight = GetFontHeight();
	CreateGrayCaret(2, nCaretHeight);
}


void EditView::FreeCharWidthArray(void)
{
	for(size_t i = 0; i < countof(m_lpCharWidthArray); i++)
	{
		delete []m_lpCharWidthArray[i];
		m_lpCharWidthArray[i] = NULL;
	}
}

// R[h code ̕LN^PʂŌvZ
INT EditView::CalcCodeWidth(const wchar_t code, const BOOL bAddCharSpace /* = TRUE */) const
{
	// ܂擾ĂȂΒx擾
	const int index = code >> 8;
	if(m_lpCharWidthArray[index] == NULL)
	{
		// m_lpCharWidthArray ́Amutable錾Ă̂consto֐łύXł
		LPINT lpCharWidth = new INT[256];
		m_lpCharWidthArray[index] = lpCharWidth;

		wgc::DeviceContext_Client dc(m_hWnd);
		wgc::GdiFont font(GetFont());
		{
			wgc::AutoSelectGDI selectFont(dc, font);

			// code ̑O256ɑ΂ĕ擾
			const UINT uFirst = code & 0xff00;
			const UINT uLast  = code | 0x00ff;
			dc.GetCharWidthWide(uFirst, uLast, lpCharWidth);
		}
	}

	INT nWidth = m_lpCharWidthArray[index][code & 0xff];
	if(bAddCharSpace)
	{
		// Ԋu
		nWidth += m_property.infoText.nCharSpace;
	}

	return nWidth;
}

// nCols ڂ̈ʒuɂ^uvZ
UINT EditView::CalcTabWidth(const wgc::UINDEX_T nCols) const
{
	const UINT nWidth = m_property.infoText.nTabSize * GetFontWidth();
	return nWidth - (nCols % nWidth);
}


//  wstr ̕߂
UINT EditView::CalcPhysicalLength(const wgc::wstring_t &wstr) const
{
	return CalcPhysicalLength(wstr.c_str(), wstr.length());
}

// _ nCount ̕ lpString ̕߂
UINT EditView::CalcPhysicalLength(LPCWSTR lpString, const SIZE_T nCount) const
{
	UINT nLength = 0;
	for(SIZE_T i = 0; i < nCount; i++)
	{
		const wchar_t code = lpString[i];
		if(code == sgc::charcode::wTAB)
		{
			nLength += CalcTabWidth(nLength);
		}
		else
		{
			nLength += CalcCodeWidth(code);
		}
	}
	return nLength;
}

// ʒu iPosition 𒴂Ȃ lpString ̍őʒu߂
SIZE_T EditView::CalcLogicalLength(LPCWSTR lpString, const SIZE_T nCount, const wgc::UINDEX_T iPosition) const
{
	wgc::UINDEX_T iPosition2 = 0;
	SIZE_T i = 0;
	for(i = 0; i < nCount; i++)
	{
		const wchar_t code = lpString[i];
		if(code == sgc::charcode::wTAB)
		{
			iPosition2 += CalcTabWidth(iPosition2);
		}
		else
		{
			iPosition2 += CalcCodeWidth(code);
		}

		// iPosition 𒴂A̎_̈ʒuԂ
		if(iPosition2 > iPosition)
		{
			break;
		}
	}
	return i;
}

//  wstr ŁApos ɍł߂Ƙ_߂
void EditView::CalcNearestPos(LPCWSTR lpString, const SIZE_T nCount, const wgc::UINDEX_T iPosition, wgc::UINDEX_T *pPosPhysical, wgc::UINDEX_T *pPosLogical) const
{
	wgc::UINDEX_T iNearest = 0;
	SIZE_T i = 0;
	for(i = 0; i < nCount; i++)
	{
		const wchar_t code = lpString[i];
		const SIZE_T nLength = (code == sgc::charcode::wTAB) ? CalcTabWidth(iNearest) : CalcCodeWidth(code);

		if(iPosition <= iNearest + (nLength + 1) / 2)
		{
			break;
		}
		iNearest += nLength;
	}
	if(pPosPhysical != NULL) { *pPosPhysical = iNearest; }
	if(pPosLogical  != NULL) { *pPosLogical  = i; }
}


////////////////////////////////////////////////////////////
// XN[

// XN[
void EditView::ScrollPhysical(const INT_PTR nHorz, const INT_PTR nVert, UPDATE_CLIENT_INFO &rUpdateInfo)
{
	const  SIZE_T uLineCount = m_rDocument.GetLineCount();
	const INT_PTR sLineCount = uLineCount;
	INT_PTR nCorrectedHorz = nHorz;
	INT_PTR nCorrectedVert = nVert;

	// 
	if(nHorz != 0)
	{
		const INT_PTR nNewColumnLeft = m_nColumnLeft + nHorz;
		SetColumnLeft(nNewColumnLeft);
	}

	// 
	if(nVert != 0)
	{
		INT_PTR nNewLineNumberTop = m_nLineNumberTop + nVert;
		sgc::utility::saturate(nNewLineNumberTop, 1, sLineCount);

		nCorrectedVert = nNewLineNumberTop - m_nLineNumberTop;
		SetLineNumberTop(nNewLineNumberTop);
	}

	// UPDATE_CLIENT_INFOXV
	{
		const LONG cx = static_cast<LONG>(nCorrectedHorz * GetFontWidth ());
		const LONG cy = static_cast<LONG>(nCorrectedVert * GetFontHeight());

		m_ptCaretPrev.x += cx;
		m_ptCaretPrev.y += static_cast<LONG>(nCorrectedVert);

		rUpdateInfo.szScroll.cx += cx;
		rUpdateInfo.szScroll.cy += cy;
		::OffsetRect(&rUpdateInfo.rcValid, -cx, -cy);
	}
}

// _XN[ij
void EditView::ScrollLogicalHorz(const INT_PTR nScrollAmount)
{
	const BOOL bShiftPressed = wgc::wgfIsKeyDown(VK_SHIFT);
	EditDoc &rDocument = m_rDocument;

	rDocument.SetXRelative(nScrollAmount, bShiftPressed ? sgc::edit_manager::MS_UPDATE : sgc::edit_manager::MS_CLEAR);
}

// _XN[ij
void EditView::ScrollLogicalVert(const INT_PTR nScrollAmount)
{
	const BOOL bShiftPressed = wgc::wgfIsKeyDown(VK_SHIFT);
	EditDoc &rDocument = m_rDocument;

	// IĂāAVtgL[ĂȂΑI͈͂̍ŏŌֈړ
	// iXN[ȂŏAȂŌj
	if(rDocument.IsSelected() && !bShiftPressed)
	{
		sgc::edit_manager::select_cursor_t cursor_pos = sgc::edit_manager::SC_END;
		if(nScrollAmount < 0)
		{
			cursor_pos = sgc::edit_manager::SC_BEGIN;
		}
		rDocument.ClearSelection(cursor_pos);
		m_ptCaret = LogicalToPhysical(m_rDocument.GetXY(), &m_nInternalX);
	}

	// ܂yɃXN[
	rDocument.SetYRelative(nScrollAmount, bShiftPressed ? sgc::edit_manager::MS_UPDATE : sgc::edit_manager::MS_CLEAR, FALSE);
	EditDoc::const_iterator_t p = rDocument.GetIteratorNow();

	// ɌxWɋ߂ꏊvZ
	wgc::UINDEX_T x;
	CalcNearestPos(p->c_str(), p->length(), m_nInternalX, NULL, &x);

	// xWݒ
	rDocument.SetX(x, bShiftPressed ? sgc::edit_manager::MS_UPDATE : sgc::edit_manager::MS_CLEAR, TRUE, FALSE);
}

// XN[
void EditView::ScrollAuto(void)
{
	// }EXJ[\̈ʒuiNCAgWj擾
	POINT point;
	::GetCursorPos(&point);
	ScreenToClient(point);

	INT_PTR nScrollHorz = 0, nScrollVert = 0;

	// {block}
	// XN[ʂ̌vZ
	{
		RECT rcText;
		CalcRectText(rcText, FALSE);
		if(point.x < rcText.left   && !m_rDocument.IsHead ()) { nScrollHorz -= GetFontWidth(); }
		if(point.x > rcText.right  && !m_rDocument.IsTail ()) { nScrollHorz += GetFontWidth(); }
		if(point.y < rcText.top    && !m_rDocument.IsBegin()) { nScrollVert--; }
		if(point.y > rcText.bottom && !m_rDocument.IsEnd  ()) { nScrollVert++; }
	}

	// XN[s
	if(nScrollHorz != 0 || nScrollVert != 0)
	{
		// }EẌʒuփJbgړ
		MoveCaretToPoint(point, TRUE);

		// NCAgWXV
		UPDATE_CLIENT_INFO update_info;
		InitUpdateClientInfo(update_info);
		ScrollPhysical(nScrollHorz, nScrollVert, update_info);
		UpdateClient(update_info);
	}
}


////////////////////////////////////////////////////////////
// _[`

// sԍ̌g
void EditView::ExpandLineNumberCols(void)
{
	// ݂̌𐔂
	UINT nCols = 0;
	SIZE_T nLineCount = m_rDocument.GetLineCount();
	while(nLineCount > 0)
	{
		nLineCount /= 10;
		nCols++;
	}

	// ݒ肵Ă錅傫Ίg
	if(m_nLineNumberCols < nCols)
	{
		m_nLineNumberCols = nCols;
		Invalidate();
	}
}


////////////////////////////////////////////////////////////
// [`

// qbgeXg
EditView::client_hittest_t EditView::ClientHitTest(const POINT &ptDisplay) const
{
	// {block}
	// ]̈
	{
		const UINT x = ptDisplay.x;
		if(x < CalcMarginLeft())
		{
			return CHT_MARGIN;
		}
	}

	// Ï
	if(m_rDocument.IsSelected())
	{
		// }EXWJbg̕WvZ
		POINT      ptCaret;
		position_t ptLogical;
		UINT_PTR   nInternalX;
		CalcCaretPos(ptDisplay, ptCaret, ptLogical, nInternalX);

		// {block}
		position_t sel_begin, sel_end;
		m_rDocument.GetSelectedRange(sel_begin, sel_end);
		if(sel_begin <= ptLogical && ptLogical < sel_end)
		{
			return CHT_SELECTED;
		}
	}
	return CHT_TEXT;
}

// eLXg̈̃TCYiJbgPʁj̍XV
void EditView::UpdateTextAreaSize(void)
{
	RECT rect;
	CalcRectText(rect, FALSE);

	const int cx = rect.right - rect.left;
	const int cy = (rect.bottom - rect.top) / GetFontHeight();
	SetTextAreaSize(
		(cx > 0) ? cx : 1,
		(cy > 0) ? cy : 1);
}


// XN[o[𓯊
void EditView::SyncHScroll(void)
{
	SCROLLINFO si = {sizeof(si)};
	si.fMask = SIF_RANGE | SIF_PAGE | SIF_POS;
	si.nMin  = 0;
	si.nMax  = static_cast<int>(m_nLongestLine);
	si.nPage = m_sizeTextArea.cx;
	si.nPos  = static_cast<int>(m_nColumnLeft * GetFontWidth());

//	if(m_property.flags.elements.bAlwaysShowHorzScroll)
//	{
//		si.fMask |= SIF_DISABLENOSCROLL;
//	}
	SetHScrollInfo(si);
}

// XN[o[𓯊
void EditView::SyncVScroll(void)
{
	const UINT cy = m_sizeTextArea.cy;
	assert(cy > 0);

	const SIZE_T nLineCount = m_rDocument.GetLineCount();
	assert(nLineCount > 0);

	// {block}
	// XN[o[̃y[WTCYƈʒuXV
	{
		SCROLLINFO si = {sizeof(si)};
		si.fMask = SIF_RANGE | SIF_PAGE | SIF_POS;
		si.nMin  = 1;
		si.nMax  = static_cast<int>(nLineCount + cy - 1);
		si.nPage = cy;
		si.nPos  = static_cast<int>(m_nLineNumberTop);

//		if(m_property.flags.elements.bAlwaysShowVertScroll)
		{
			si.fMask |= SIF_DISABLENOSCROLL;
		}
		SetVScrollInfo(si);
	}
}


////////////////////////////////////////////////////////////
// ̈vZ[`

// eLXg̍]vZ
UINT EditView::CalcMarginLeft(const BOOL bAddTextMargin /* = TRUE */) const
{
	UINT nMargin = 0;
	if(bAddTextMargin && !IsLineNumberVisible())
	{
		nMargin += m_nTextMarginLeft;
	}
	if(IsLineNumberVisible())
	{
		nMargin += m_nLineNumberCols * m_nNumWidthMax + m_property.infoLineNumber.nMargin;
	}

	return nMargin;
}

// eLXg̏㑤]vZ
UINT EditView::CalcMarginTop(void) const
{
	UINT nMargin = 0;
	if(IsRulerVisible())
	{
		nMargin += m_property.infoRuler.nHeight;
	}

	return nMargin;
}

// sԍ̈
void EditView::CalcRectLineNumber(RECT &rRect) const
{
	GetClientRect(rRect);
	rRect.top   = static_cast<LONG>(CalcMarginTop());
	rRect.right = static_cast<LONG>(m_nLineNumberCols * m_nNumWidthMax + m_property.infoLineNumber.nMargin);
}

// [[̈
void EditView::CalcRectRuler(RECT &rRect) const
{
	GetClientRect(rRect);
	rRect.bottom = CalcMarginTop();
}

// eLXg̈
void EditView::CalcRectText(RECT &rRect, const BOOL bIncludeMargin /* = TRUE */) const
{
	// ]̈܂ރeLXg̈擾
	GetClientRect(rRect);
	rRect.left = CalcMarginLeft(FALSE);
	rRect.top  = CalcMarginTop();

	// ]̈
	if(!bIncludeMargin)
	{
		if(!IsLineNumberVisible()) { rRect.left += m_nTextMarginLeft; }
		rRect.right -= m_nTextMarginRight;
	}
}


////////////////////////////////////////////////////////////
// Jbg[`

// JbgʒuNCAgWvZ
void EditView::CalcDisplayPos(const POINT &ptCaret, POINT &ptDisplay) const
{
	// {W
	ptDisplay.x = ptCaret.x;
	ptDisplay.y = ptCaret.y * GetFontHeight();

	// ]l
	ptDisplay.x += CalcMarginLeft();
	ptDisplay.y += CalcMarginTop();
}

// NCAgWJbgʒuvZ
void EditView::CalcCaretPos(const POINT &ptDisplay, POINT &ptPhysical, position_t &ptLogical, wgc::UINDEX_T &nInternalX) const
{
	ptPhysical.x = ptDisplay.x - CalcMarginLeft();
	if(ptPhysical.x < 0) { ptPhysical.x = 0; } else { ptPhysical.x += static_cast<LONG>(m_nColumnLeft * GetFontWidth()); }

	ptPhysical.y = ptDisplay.y - CalcMarginTop();
	if(ptPhysical.y < 0) { ptPhysical.y = 0; }

	// yWLN^Pʂɕ␳
	ptPhysical.y /= GetFontHeight();

	// {block}
	// JbgWvZ
	{
		EditDoc::linenumber_t nLineNumberNow = m_nLineNumberTop + ptPhysical.y;
		if(nLineNumberNow > m_rDocument.GetLineCount())
		{
			// ŉs߂␳
			nLineNumberNow = m_rDocument.GetLineCount();
			ptPhysical.y = static_cast<LONG>(nLineNumberNow - m_nLineNumberTop);
		}

		EditDoc::const_iterator_t p = m_rDocument.GetIterator(nLineNumberNow);

		wgc::UINDEX_T xPhysical, xLogical;
		CalcNearestPos(p->c_str(), p->length(), ptPhysical.x, &xPhysical, &xLogical);
		ptPhysical.x = static_cast<LONG>(xPhysical - m_nColumnLeft * GetFontWidth());

		ptLogical.x = static_cast<LONG>(xLogical);
		ptLogical.y = static_cast<LONG>(nLineNumberNow - 1);

		nInternalX = xPhysical;
	}
}

// _Ww肵NCAgWԋ߂ꏊɐݒ
void EditView::SetLogicalPos(const POINT &client, const BOOL bUpdateSelection /* = FALSE */)
{
	// }EXWJbg̕WvZ
	position_t ptLogical;
	CalcCaretPos(client, m_ptCaret, ptLogical, m_nInternalX);

	m_rDocument.SetXY(ptLogical, bUpdateSelection ? sgc::edit_manager::MS_UPDATE : sgc::edit_manager::MS_CLEAR);
}

// Jbgړ
void EditView::MoveCaret_Physical(const POINT &point)
{
	// Jbg\NCAgW
	POINT ptDisplay;

	// [[̈orsԍ̈ɓꍇAʊO܂ňړ
	if(point.x < 0 || point.y < 0)
	{
		const UINT nHeight = GetFontHeight(FALSE);
		ptDisplay.x = 0;
		ptDisplay.y = -static_cast<int>(nHeight);
	}
	else
	{
		CalcDisplayPos(point, ptDisplay);
	}

	MoveCaret_Client(ptDisplay);

	// `
	if(IsCursorUnderline() && IsFocused() && !m_rDocument.IsSelected() && m_ptCaretPrev.y != point.y)
	{
		wgc::DeviceContext_Client dc(m_hWnd);
		PaintUnderline(dc, m_ptCaretPrev, FALSE);
		PaintUnderline(dc, point        , TRUE);
	}

	// Jbg̈ʒuXV
	m_ptCaretPrev = m_ptCaret;
	m_ptCaret     = point;
}

// JbgiIMEJbg܂ށjw肳ꂽNCAgWֈړ
void EditView::MoveCaret_Client(const POINT &point)
{
	// Jbgړ
	::SetCaretPos(point.x, point.y);

	// {block}
	// IMẼJbgWݒ
	{
		wgc::Imm immcontext(m_hWnd);
		immcontext.SetPos(point);
	}
}

// w肳ꂽꏊɍł߂ʒuփJbgړ
void EditView::MoveCaretToPoint(const POINT &point, const BOOL bUpdateSelection /* = FALSE */)
{
	// Jbgړ
	SetLogicalPos(point, bUpdateSelection);

	// {block}
	// J[\悤ɃXN[
	{
		UPDATE_CLIENT_INFO update_info;
		InitUpdateClientInfo(update_info);
		EnsureVisible       (update_info, bUpdateSelection);
		UpdateClient        (update_info);
	}
}


// Jbgʓɕ\
BOOL EditView::EnsureVisible(UPDATE_CLIENT_INFO &rUpdateInfo, const BOOL bByScroll /* = TRUE */, const BOOL bUpdateLineNumber /* = FALSE */)
{
	const int nFontWidth = GetFontWidth();
	BOOL bMoved = FALSE;

	int nScrollX = 0;
	int nScrollY = 0;

	// ʂXN[
	if(bByScroll)
	{
		// ܂XN[͂Aړʂ̂݌vZ
		if(m_ptCaret.y < 0)
		{
			nScrollY = m_ptCaret.y;
			bMoved = TRUE;
		}
		if(m_ptCaret.y > m_sizeTextArea.cy - 1)
		{
			nScrollY = m_ptCaret.y - (m_sizeTextArea.cy - 1);
			bMoved = TRUE;
		}
	}
	// J[\ړ
	else
	{
		if(sgc::utility::saturate(m_ptCaret.y, 0L, m_sizeTextArea.cy - 1))
		{
			m_rDocument.SetY(m_nLineNumberTop + m_ptCaret.y - 1, bUpdateLineNumber ? sgc::edit_manager::MS_UPDATE : sgc::edit_manager::MS_CLEAR, FALSE);

			EditDoc::const_iterator_t p = m_rDocument.GetIteratorNow();

			// {block}
			// JbgXWvZ
			{
				wgc::UINDEX_T iPosPhysical, iPosLogical;
				CalcNearestPos(p->c_str(), p->length(), m_nInternalX, &iPosPhysical, &iPosLogical);
				m_rDocument.SetX(iPosLogical, bUpdateLineNumber ? sgc::edit_manager::MS_UPDATE : sgc::edit_manager::MS_CLEAR, TRUE, FALSE);
			}

			bMoved = TRUE;
		}
	}

	// X́AʂXN[ăJ[\킷
	if(m_ptCaret.x < 0)
	{
		const int dx = m_ptCaret.x;
		nScrollX = (dx - (nFontWidth - 1)) / nFontWidth;
		bMoved = TRUE;
	}
	const LONG lRightLimit = m_sizeTextArea.cx - 1;
	if(m_ptCaret.x >= lRightLimit)
	{
		const int dx = m_ptCaret.x - lRightLimit;
		nScrollX = (dx + (nFontWidth - 1)) / nFontWidth;
		bMoved = TRUE;
	}

	// {block}
	{
		m_ptCaretPrev.x -= nScrollX;
		m_ptCaretPrev.y -= nScrollY;
	}

	ScrollPhysical(nScrollX, nScrollY, rUpdateInfo);

	return bMoved;
}


////////////////////////////////////////////////////////////
// L[{[h[`

// [Page Up]
void EditView::KeyPageUp(UPDATE_CLIENT_INFO &rUpdateInfo)
{
	const int nVert = -m_sizeTextArea.cy;
	ScrollLogicalVert(nVert);
	ScrollPhysical(0, nVert, rUpdateInfo);

	EnsureVisible(rUpdateInfo);
}

// [Page Down]
void EditView::KeyPageDown(UPDATE_CLIENT_INFO &rUpdateInfo)
{
	const int nVert = m_sizeTextArea.cy;
	ScrollLogicalVert(nVert);
	ScrollPhysical(0, nVert, rUpdateInfo);

	EnsureVisible(rUpdateInfo);
}

// [Home]
void EditView::KeyHome(UPDATE_CLIENT_INFO &rUpdateInfo)
{
	const BOOL bShiftPressed = wgc::wgfIsKeyDown(VK_SHIFT);
	position_t pt = m_rDocument.GetXY();

	// [ֈړ
	pt.x = 0;

	// Rg[L[Ăꍇ
	if(wgc::wgfIsKeyDown(VK_CONTROL))
	{
		// J[\obt@̐擪Ɉړ
		pt.y = 0;
	}

	// J[\ʍ[Ɉړ
	m_rDocument.SetXY(pt, bShiftPressed ? sgc::edit_manager::MS_UPDATE : sgc::edit_manager::MS_CLEAR);
	EnsureVisible(rUpdateInfo);
}

// [End]
void EditView::KeyEnd(UPDATE_CLIENT_INFO &rUpdateInfo)
{
	const BOOL bShiftPressed = wgc::wgfIsKeyDown(VK_SHIFT);
	position_t pt = m_rDocument.GetXY();

	// E[Ɉړ
	pt.x = -1;

	// Rg[L[Ăꍇ
	if(wgc::wgfIsKeyDown(VK_CONTROL))
	{
		pt.y = -1;
	}

	// J[\ʉE[Ɉړ
	m_rDocument.SetXY(pt, bShiftPressed ? sgc::edit_manager::MS_UPDATE : sgc::edit_manager::MS_CLEAR);
	EnsureVisible(rUpdateInfo);
}

// []
void EditView::KeyLeft(UPDATE_CLIENT_INFO &rUpdateInfo)
{
	const BOOL bShiftPressed = wgc::wgfIsKeyDown(VK_SHIFT);
	EditDoc::const_iterator_t p = m_rDocument.GetIteratorNow();

	position_t pt = m_rDocument.GetXY();

	// IĂāAVtgL[ĂȂΑI͈͂̍ŏֈړ
	// m_ptCaretm_nInternalX͂̌SetXY()Œ
	if(m_rDocument.IsSelected() && !bShiftPressed)
	{
		m_rDocument.ClearSelection(sgc::edit_manager::SC_BEGIN);
		pt = m_rDocument.GetXY();
	}
	else
	{
		// słȂꍇ
		if(pt.x > 0)
		{
			// [Ctrl]Ăꍇ
			if(wgc::wgfIsKeyDown(VK_CONTROL))
			{
				// P̋؂܂ňړ
				pt.x = m_rDocument.FindWordBreak(FALSE);
			}
			// ĂȂꍇ
			else
			{
				// 1ֈړ
				pt.x--;
			}
		}
		// s̏ꍇ
		else
		{
			// sŁA̍sꍇ
			if(!m_rDocument.IsBegin())
			{
				// ݈ʒuXV
				p--;
				pt.x = p->length();
				pt.y--;
			}
		}
	}

	m_rDocument.SetXY(pt, bShiftPressed ? sgc::edit_manager::MS_UPDATE : sgc::edit_manager::MS_CLEAR);
	EnsureVisible(rUpdateInfo);
}

// []
void EditView::KeyRight(UPDATE_CLIENT_INFO &rUpdateInfo)
{
	const BOOL bShiftPressed = wgc::wgfIsKeyDown(VK_SHIFT);
	EditDoc::const_iterator_t p = m_rDocument.GetIteratorNow();
	const INT_PTR length = p->length();

	position_t pt = m_rDocument.GetXY();

	// IĂāAVtgL[ĂȂΑI͈͂̍Ōֈړ
	// m_ptCaretm_nInternalX͂̌SetXY()Œ
	if(m_rDocument.IsSelected() && !bShiftPressed)
	{
		m_rDocument.ClearSelection(sgc::edit_manager::SC_END);
		pt = m_rDocument.GetXY();
	}
	else
	{
		// słȂꍇ
		if(pt.x < length)
		{
			// [Ctrl]Ăꍇ
			if(wgc::wgfIsKeyDown(VK_CONTROL))
			{
				// P̋؂܂ňړ
				pt.x = m_rDocument.FindWordBreak();
			}
			// ĂȂꍇ
			else
			{
				// 1Eֈړ
				pt.x++;
			}
		}
		// s̏ꍇ
		else
		{
			// sŁA̍sꍇ
			if(!m_rDocument.IsEnd())
			{
				// ݈ʒuXV
				p++;
				pt.x = 0;
				pt.y++;
			}
		}
	}

	m_rDocument.SetXY(pt, bShiftPressed ? sgc::edit_manager::MS_UPDATE : sgc::edit_manager::MS_CLEAR);
	EnsureVisible(rUpdateInfo);
}

// []
void EditView::KeyUp(UPDATE_CLIENT_INFO &rUpdateInfo)
{
	const int nScrollLines = -1;
	BOOL bByScroll = TRUE;

	// [Ctrl]ĂȂꍇ
	if(!wgc::wgfIsKeyDown(VK_CONTROL))
	{
		// _XN[
		ScrollLogicalVert(nScrollLines);
		bByScroll = TRUE;
	}
	// [Ctrl]Ăꍇ
	else
	{
		// XN[
		ScrollPhysical(0, nScrollLines, rUpdateInfo);
		bByScroll = FALSE;
	}

	EnsureVisible(rUpdateInfo, bByScroll);
}

// []
void EditView::KeyDown(UPDATE_CLIENT_INFO &rUpdateInfo)
{
	const int nScrollLines = 1;
	BOOL bByScroll = TRUE;

	// [Ctrl]ĂȂꍇ
	if(!wgc::wgfIsKeyDown(VK_CONTROL))
	{
		// _XN[
		ScrollLogicalVert(nScrollLines);
		bByScroll = TRUE;
	}
	// [Ctrl]Ăꍇ
	else
	{
		// XN[
		ScrollPhysical(0, nScrollLines, rUpdateInfo);
		bByScroll = FALSE;
	}

	EnsureVisible(rUpdateInfo, bByScroll);
}

// [Enter]
void EditView::KeyReturn(void)
{
	m_rDocument.InsertLinefeed();
}

// [Backspace]
void EditView::KeyBack(void)
{
	m_rDocument.DeleteChar(FALSE);
}

// [Delete]
void EditView::KeyDelete(void)
{
	m_rDocument.DeleteChar(TRUE);
}

// ̓
void EditView::KeyString(const wgc::wstring_t &wstr)
{
	m_rDocument.InputString(wstr);
}

// [Insert]
void EditView::KeyInsert(void)
{
	m_rDocument.ToggleOverwrite();
}

// [ESC]
void EditView::KeyEscape(void)
{
	m_rDocument.ClearSelection(sgc::edit_manager::SC_NOMOVE);
}


// ́iOnChar() / OnUniChar() Ă΂j
void EditView::CharInput(const WCHAR wch, const UINT nRepeatCount)
{
	if(iswprint(wch))
	{
		const wgc::wstring_t str(nRepeatCount, wch);
		KeyString(str);
	}
}

// OLEhbOhbvs
void EditView::OleDragDrop(void)
{
	m_rDocument.DragBegin();
	{
		wxc::COM_OleDropSource ods;

		// {block}
		// eLXgLbV
		{
			sgc::wstring_t sel_data;
			m_rDocument.GetSelectedTextW(sel_data);
			HGLOBAL hGlobal = wxc::COM_OleDropSource::CreateGlobalData(
				sel_data.c_str(),
				sizeof(sel_data[0]) * (sel_data.length() + 1));

			ods.CacheGlobalData(CF_UNICODETEXT, hGlobal);
		}

		// OLE hbOhbv
		const DWORD dwEffect = ods.DoDragDrop();
		if(dwEffect == DROPEFFECT_MOVE)
		{
			// 삪uړvȂI͈͂폜
			m_rDocument.DeleteSelection(TRUE);
		}
		if(IsFocused())
		{
			// tH[JXĂ΃J[\쐬
			CreateEditCaret();
			ShowCaret();
		}
		OnSyncCaret();
	}
	m_rDocument.DragEnd();
}


////////////////////////////////////////////////////////////
// }EX[`

// gvNbNiOnLButtonDown()Ă΂j
BOOL EditView::IsTripleClick(void)
{
	// ȉׂ̂Ă𖞂ꍇɌAgvNbNƂ
	//  * _uNbÑNbNł
	//  * _uNbNA莞ԓi_uNbN^CȓjɃNbN
	//  * _uNbNȍ~A}EX𓮂ĂȂ

	// ÃR[hł͈ȉ̏łgvNbNƂĔ肵Ă܂
	//  * _uNbNɈx}EX𓮂A49.7noߒi_uNbN^CȓjɃNbN
	//  * VXeN49.7noߒi_uNbN^CȓjɃNbN
	// ȀꍇɂĂRȂ邱Ƃ͂܂肦Ȃ
	// _Ăł悤Ȃ̂ł͂Ȃ̂ŁA̗OɂĂ͍lȂƂɂB
	const DWORD dwDiff = ::GetTickCount() - m_dwDblClkTickCount;
	if(dwDiff <= ::GetDoubleClickTime())
	{
		m_dwDblClkTickCount = 0;
		return TRUE;
	}
	return FALSE;
}


////////////////////////////////////////////////////////////
// `惋[`

// UPDATE_CLIENT_INFO\̂
void EditView::InitUpdateClientInfo(UPDATE_CLIENT_INFO &rUpdateInfo) const
{
	rUpdateInfo.bUpdateLineNumber  = FALSE;
	rUpdateInfo.bUpdateLongestLine = FALSE;

	rUpdateInfo.szScroll.cx = 0;
	rUpdateInfo.szScroll.cy = 0;

	CalcRectText( rUpdateInfo.rcValid, FALSE);
	::OffsetRect(&rUpdateInfo.rcValid, -rUpdateInfo.rcValid.left, -rUpdateInfo.rcValid.top);
}

// NCAg̈XV
void EditView::UpdateClient(const UPDATE_CLIENT_INFO &rUpdateInfo)
{
	RECT rcUpdate;
	GetUpdateRect(rcUpdate, FALSE);

	RECT rcText;
	CalcRectText(rcText, FALSE);

	// eLXg̈𖳌
	InvalidateRect(rcText, FALSE);

	// {block}
	// L̈ݒ
	{
		RECT rcValid = rUpdateInfo.rcValid;
		::OffsetRect(&rcValid,
			rcText.left + rUpdateInfo.szScroll.cx,
			rcText.top  + rUpdateInfo.szScroll.cy);

		ValidateRect(rcValid);
	}

	// NCAg̖̈ݒ
	InvalidateRect(rcUpdate, FALSE);

	// XN[
	if(rUpdateInfo.szScroll.cx != 0 || rUpdateInfo.szScroll.cy != 0)
	{
		ScrollWindowEx(
			-rUpdateInfo.szScroll.cx, -rUpdateInfo.szScroll.cy,
			&rcText, &rcText,
			NULL, NULL,
			SW_INVALIDATE);
	}

	// [[̈𖳌
	if(rUpdateInfo.szScroll.cx != 0 || rUpdateInfo.bUpdateLongestLine)
	{
		if(IsRulerVisible())
		{
			RECT rcRuler;
			CalcRectRuler(rcRuler);
			InvalidateRect(rcRuler, FALSE);
		}
		SyncHScroll();
	}

	// sԍ̈𖳌
	if(rUpdateInfo.szScroll.cy != 0 || rUpdateInfo.bUpdateLineNumber)
	{
		if(IsLineNumberVisible())
		{
			if(rUpdateInfo.bUpdateLineNumber)
			{
				ExpandLineNumberCols();
			}

			RECT rcLineNumber;
			CalcRectLineNumber(rcLineNumber);
			InvalidateRect(rcLineNumber, FALSE);
		}
		SyncVScroll();
	}

	// Jbgړ
	if(IsFocused())
	{
		MoveCaret_Physical(m_ptCaret);
	}
}

// NCAg̈`
void EditView::PaintClient(
	wgc::DeviceContext &dc,
	const INT_PTR nLineNumberRedraw /* = 0 */,
	const INT_PTR nLineCountRedraw  /* = -1 */,
	const BOOL    bLineNumber       /* = TRUE */,
	const BOOL    bRuler            /* = TRUE */) const
{
	// eLXg`
	if(nLineNumberRedraw >= 0)
	{
		PaintText(dc, nLineNumberRedraw, nLineCountRedraw);
	}

	// sԍ`
	if(bLineNumber)
	{
		PaintLineNumber(dc);
	}

	// [[`
	if(bRuler)
	{
		PaintRuler(dc);
	}
}


// eLXg̈`
void EditView::PaintText(wgc::DeviceContext &dc, const INT_PTR nLineNumberRedraw, const INT_PTR nLineCountRedraw) const
{
	EditDoc::const_iterator_t p = m_rDocument.GetIterator(m_nLineNumberTop);
	assert(p != m_rDocument.GetIteratorEnd());
	assert(nLineNumberRedraw >= 0);

	// {block}
	// NbsÖݒ
	{
		RECT rect;
		CalcRectText(rect, FALSE);
		dc.SetClipRect(rect);
	}

	// \ʒu
	POINT pt = {-static_cast<LONG>(m_nColumnLeft * GetFontWidth()), 0};

	// ύX̕svȘ_svZ
	for(INT_PTR i = 0; i < nLineNumberRedraw; i++)
	{
		pt.y++;
		p++;
		if(p == m_rDocument.GetIteratorEnd())
		{
			break;
		}
	}

	EditDoc::position_t sel_begin, sel_end;
	m_rDocument.GetSelectedRange(sel_begin, sel_end);

	dc.SetBkColor(m_property.fcDefault.colorBack);
	wgc::GdiFont font(GetFont());
	{
		wgc::AutoSelectGDI selectFont(dc, font);

		// _sPʂ̃[v
		SIZE_T  y = 1;
		INT_PTR y_logical = m_nLineNumberTop + nLineNumberRedraw - 1;
		while(p != m_rDocument.GetIteratorEnd())
		{
			// Iʒui]ʒujvZ
			SIZE_T nSelBegin = 0, nSelEnd = 0;
			if(m_rDocument.IsSelected())
			{
				if(sel_begin.y <= y_logical && y_logical <= sel_end.y)
				{
					if(sel_begin.y == y_logical) { nSelBegin = sel_begin.x; }
					if(sel_end  .y == y_logical) { nSelEnd   = sel_end  .x; }
					if(sel_end  .y >  y_logical) { nSelEnd   = static_cast<SIZE_T>(-1); }
				}
			}

			// _s`
			EditDoc::const_iterator_t tmp = p++;
			const SIZE_T nDrawLines = DrawLogicalLine(
				dc, pt,
				tmp->c_str(), tmp->length(),
				p == m_rDocument.GetIteratorEnd(),
				nSelBegin, nSelEnd);

			if(pt.y > m_sizeTextArea.cy || y >= static_cast<SIZE_T>(nLineCountRedraw))
			{
				// ŉs܂ŕ`抮
				return;
			}
			pt.y     += static_cast<LONG>(nDrawLines);
			y        += nDrawLines;
			y_logical++;
		}
	}

	// {block}
	// ȍ~̃eLXg̈wiFœhԂ
	{
		RECT rect;
		CalcRectText(rect, FALSE);
		rect.top += pt.y * GetFontHeight();

		dc.FillSolidRect(rect, m_property.fcDefault.colorBack);
	}
}

// eLXg̈̔wi`
void EditView::PaintTextBack(wgc::DeviceContext &dc) const
{
	RECT rect;
	CalcRectText(rect);

	dc.FillSolidRect(rect, m_property.fcDefault.colorBack);
}


// sԍ`
void EditView::PaintLineNumber(wgc::DeviceContext &dc) const
{
	if(!IsLineNumberVisible()) { return; }

	dc.ClearClip();

	dc.SetTextColor(m_property.fcLineNumber.colorText);
	dc.SetBkColor  (m_property.fcLineNumber.colorBack);
	wgc::GdiFont font(GetFont());
	{
		wgc::AutoSelectGDI selectFont(dc, font);

		const UINT   nLineStride = GetFontHeight();
		const SIZE_T nLineCount  = m_rDocument.GetLineCount();

		// sԍ̈vZi1sj
		RECT rect;
		CalcRectLineNumber(rect);
		rect.bottom = rect.top + nLineStride;
		rect.right -= m_property.infoLineNumber.nMargin;

		// sԍ͖̈S`悵Ă債SȂ낤cƌߕtB
		LINENUMBER_T nLineNumber = m_nLineNumberTop;
		for(int i = 0; i <= m_sizeTextArea.cy; i++)
		{
			// {block}
			// sԍ`
			{
				// sԍ̕쐬
				// DrawText() ɂ ExtTextOut()  ETO_OPAQUE ̃IvVȂ̂
				// ̑OXy[XŖ߂
				TCHAR szLineNumber[16];
				wsprintf(szLineNumber, _T("%10d"), nLineNumber++);

				// El߂ŕ`
				dc.DrawText(szLineNumber, rect, DT_RIGHT | DT_NOPREFIX);
			}

			// `XV
			::OffsetRect(&rect, 0, nLineStride);

			// EOFɒBꍇ
			if(nLineNumber > nLineCount)
			{
				// ȍ~̍sԍ̈wiFœhԂ
				rect.bottom += (m_sizeTextArea.cy - i - 1) * nLineStride;
				dc.FillSolidRect(rect, m_property.fcLineNumber.colorBack);
				break;
			}
		}
	}
}

// sԍ̔wi`
void EditView::PaintLineNumberBack(wgc::DeviceContext &dc) const
{
	if(!IsLineNumberVisible()) { return; }

	RECT rect;
	CalcRectLineNumber(rect);

	// wiFœhԂ
	dc.FillSolidRect(rect, m_property.fcLineNumber.colorBack);

	// c
	wgc::GdiPen pen(PS_SOLID, 0, m_property.fcLineNumber.colorText);
	{
		wgc::AutoSelectGDI selectPen(dc, pen);

		const UINT x = rect.right - (m_property.infoLineNumber.nMargin / 2);
		dc.MoveTo(x, rect.top);
		dc.LineTo(x, rect.bottom);
	}
}


// [[`
void EditView::PaintRuler(wgc::DeviceContext &dc) const
{
	if(!IsRulerVisible()) { return; }

	dc.ClearClip();

	PaintRulerBack(dc);

	wgc::GdiPen pen(PS_SOLID, 0, m_property.fcRuler.colorText);
	{
		wgc::AutoSelectGDI selectPen(dc, pen);

		RECT rect;
		CalcRectRuler(rect);

		// {block}
		// 
		{
			const UINT x1 = rect.left + CalcMarginLeft();
			const UINT x2 = rect.right;
			const UINT y  = m_property.infoRuler.nHeight - 1;

			dc.MoveTo(x1, y);
			dc.LineTo(x2, y);
		}

		const UINT nFontWidth = GetFontWidth();

		POINT pt = {0, 0};
		CalcDisplayPos(pt, pt);
		LINENUMBER_T nColumn = m_nColumnLeft;
		for(int x = pt.x; x < rect.right; x += nFontWidth, nColumn++)
		{
			// ̍
			UINT nHeight = m_property.infoRuler.nHeight / 2;
			if((nColumn % (m_property.infoRuler.nStride / 2)) == 0) { nHeight = m_property.infoRuler.nHeight * 3 / 4; }
			if((nColumn %  m_property.infoRuler.nStride     ) == 0) { nHeight = m_property.infoRuler.nHeight; }

			// 
			dc.MoveTo(x, m_property.infoRuler.nHeight - 1);
			dc.LineTo(x, m_property.infoRuler.nHeight - nHeight);
		}
	}
}

// [[̔wi`
void EditView::PaintRulerBack(wgc::DeviceContext &dc) const
{
	if(!IsRulerVisible()) { return; }

	RECT rect;
	CalcRectRuler(rect);

	dc.FillSolidRect(rect, m_property.fcRuler.colorBack);
}


// wʒuɃA_[C`
void EditView::PaintUnderline(wgc::DeviceContext &dc, const POINT &pt, const BOOL bDraw /* = TRUE */) const
{
	// eLXg̈OȂ牽Ȃ
	if(pt.y < 0 || pt.y >= m_sizeTextArea.cy)
	{
		return;
	}

	// r\ʒuvZ
	POINT ptDisplay;
	CalcDisplayPos(pt, ptDisplay);
	ptDisplay.y += GetFontHeight(FALSE);

	// r\`vZ
	RECT rect;
	CalcRectText(rect);

	const COLORREF color = bDraw ? m_property.colorUnderLine : m_property.fcDefault.colorBack;

	wgc::GdiPen pen(PS_SOLID, 0, color);
	{
		wgc::AutoSelectGDI selectPen(dc, pen);

		// r`
		dc.ClearClip();
		dc.MoveTo(rect.left , ptDisplay.y);
		dc.LineTo(rect.right, ptDisplay.y);
	}
}


// _s1s`
SIZE_T EditView::DrawLogicalLine(wgc::DeviceContext &dc, const POINT &ptBase, LPCWSTR lpString, const SIZE_T nCount, const BOOL bLastLine /* = FALSE */, const SIZE_T nSelBegin /* = 0 */, const SIZE_T nSelEnd /* = 0 */) const
{
	UINT x = 0;

	// {͂ɐ܂Ԃ̂߂ɕsPʂ̃[v
	wgc::UINDEX_T index = 0;
	while(index < nCount)
	{
		// \P擾
		sgc::keyword_manager::keyword_info_t info;
		const bool head = (index == 0);
		const SIZE_T nKeyLength = m_keyword.cKeyMan.find_keyword(&lpString[index], nCount - index, info, head);

		// AEgC擾
		FONT_COLOR color = m_property.fcDefault;
		switch(info.type)
		{
		case sgc::KT_NORMAL: color = m_keyword.foComment     [info.index]; break;
		case sgc::KT_LINE  : color = m_keyword.foLineComment [info.index]; break;
		case sgc::KT_QUOTE : color = m_keyword.foQuoteComment[info.index]; break;
		}

		// `
		x     += DrawString(dc, ptBase, x, &lpString[index], nKeyLength, color);
		index += nKeyLength;
	}

	// ŏIsȂsEOF}[Nǉ
	if(bLastLine)
	{
		DrawMarkEOF(dc, ptBase, x);
	}
	// łȂ΍sɉs}[Nǉ
	else
	{
		DrawMarkLineFeed(dc, ptBase, x);
	}

	// I͈͂𔽓]
	DrawSelectedRange(dc, ptBase, lpString, nCount, nSelBegin, nSelEnd);

	// `悵sԂ
	return 1;
}

// I͈͂`i]j
void EditView::DrawSelectedRange(wgc::DeviceContext &dc, const POINT &ptBase, LPCWSTR lpString, const SIZE_T nCount, const SIZE_T nSelBegin, const SIZE_T nSelEnd) const
{
	// n_ƏI_Ȃ牽Ȃ
	if(nSelBegin == nSelEnd)
	{
		return;
	}

	// IʒuvZ
	SIZE_T nSelEnd2   = nSelEnd;
	LONG   nExtraArea = 0;
	if(nSelEnd == static_cast<SIZE_T>(-1))
	{
		nSelEnd2   = nCount;
		nExtraArea = GetFontWidth();
	}

	// JnEIxWvZ
	const LONG xBegin = CalcPhysicalLength(lpString, nSelBegin);
	const LONG xEnd   = CalcPhysicalLength(lpString, nSelEnd2 ) + nExtraArea;
	RECT rcInvert = {xBegin, 0, xEnd, GetFontHeight()};

	// x[X|CgNCAgWɕϊ
	POINT ptDisplay;
	CalcDisplayPos(ptBase, ptDisplay);
	::OffsetRect(&rcInvert, ptDisplay.x, ptDisplay.y);

	dc.Invert(rcInvert);
}

UINT EditView::DrawString(wgc::DeviceContext &dc, const POINT &pt, const UINT x, LPCWSTR lpString, const SIZE_T nCount, const FONT_COLOR &color) const
{
	// ȕ`悪Kvȕ
	const wchar_t special[] =
	{
		sgc::charcode::wTAB,
		sgc::charcode::wSPACE,
		sgc::charcode::wWIDESPACE,
		sgc::charcode::wNUL,
	};

	UINT x2 = 0;
	SIZE_T nOffset = 0;
	for(;;)
	{
		dc.SetTextColor(color.colorText);
		dc.SetBkColor  (color.colorBack);

		// {block}
		// ꕶ̑O܂ŕ`
		{
			// ꕶ
			const SIZE_T nIndexFound = String_strspn(
				&lpString[nOffset], nCount - nOffset,
				special, countof(special));

			const POINT ptDraw = {pt.x + x + x2, pt.y};

			x2      += PutString(dc, ptDraw, &lpString[nOffset], nIndexFound);
			nOffset += nIndexFound;

			// ̒ȏɂȂ烋[v𔲂
			if(nOffset >= nCount)
			{
				break;
			}
		}

		// ꕶ`
		switch(lpString[nOffset++])
		{
		case sgc::charcode::wTAB:
			x2 += DrawMarkTab(dc, pt, x + x2);
			break;

		case sgc::charcode::wSPACE:
			x2 += DrawMarkSpace(dc, pt, x + x2);
			break;

		case sgc::charcode::wWIDESPACE:
			x2 += DrawMarkWideSpace(dc, pt, x + x2);
			break;

		case sgc::charcode::wNUL:
			x2 += DrawMarkNul(dc, pt, x + x2);
			break;
		}
	}
	// `悵sNZijԂ
	return x2;
}

// s}[N`
void EditView::DrawMarkLineFeed(wgc::DeviceContext &dc, const POINT &ptBase, const UINT x) const
{
	const UINT nWidth  = GetFontWidth (FALSE);
	const UINT nHeight = GetFontHeight(FALSE);
	const UINT nFillWidth  = GetFontWidth ();
	const UINT nFillHeight = GetFontHeight();

	// `
	POINT pt = {ptBase.x + x, ptBase.y};
	if(m_property.infoText.flags.elements.bDrawMarkLF)
	{
		DrawArrowDown(
			dc,
			pt,
			nWidth, nHeight,
			nFillWidth, nFillHeight,
			m_property.fcMark.colorText, m_property.fcMark.colorBack);

		pt.x += nWidth;
	}

	// {block}
	// ȍ~hԂ
	{
		RECT rect;
		GetClientRect(rect);

		POINT ptBase;
		CalcDisplayPos(pt, ptBase);

		// hԂ̈
		const RECT rcFill = {ptBase.x, ptBase.y, rect.right, ptBase.y + nHeight + 1};
		dc.FillSolidRect(rcFill, m_property.fcDefault.colorBack);
	}

}

// EOF}[N`
void EditView::DrawMarkEOF(wgc::DeviceContext &dc, const POINT &ptBase, const UINT x) const
{
	const UINT nWidth  = GetFontWidth (FALSE);
	const UINT nHeight = GetFontHeight(FALSE);
	const UINT nFillWidth  = GetFontWidth ();
	const UINT nFillHeight = GetFontHeight();

	POINT pt = {ptBase.x + x, ptBase.y};

	// `
	if(m_property.infoText.flags.elements.bDrawMarkEOF)
	{
		DrawArrowLeft(
			dc,
			pt,
			nWidth, nHeight,
			nFillWidth, nFillHeight,
			m_property.fcMark.colorText, m_property.fcMark.colorBack);
		pt.x += nWidth;
	}

	// {block}
	// ȍ~hԂ
	{
		RECT rect;
		GetClientRect(rect);

		POINT ptClient;
		CalcDisplayPos(pt, ptClient);

		// hԂ̈
		const RECT rcFill = {ptClient.x, ptClient.y, rect.right, ptClient.y + nHeight + 1};
		dc.FillSolidRect(rcFill, m_property.fcDefault.colorBack);
	}
}

// ^u}[N`
int EditView::DrawMarkTab(wgc::DeviceContext &dc, const POINT &ptBase, const UINT x) const
{
	const UINT nWidth  = GetFontWidth (FALSE);
	const UINT nHeight = GetFontHeight(FALSE);
	const UINT nTabLength  = CalcTabWidth(x);
	const UINT nFillHeight = GetFontHeight();

	// E`
	const POINT pt = {ptBase.x + x, ptBase.y};
	if(m_property.infoText.flags.elements.bDrawMarkTab)
	{
		DrawArrowRight(
			dc,
			pt,
			nWidth, nHeight,
			nTabLength, nFillHeight,
			m_property.fcMark.colorText, m_property.fcMark.colorBack);
	}
	else
	{
		POINT ptClient;
		CalcDisplayPos(pt, ptClient);

		const RECT rcFill = {ptClient.x, ptClient.y, ptClient.x + nTabLength, ptClient.y + nHeight + 1};
		dc.FillSolidRect(rcFill, m_property.fcMark.colorBack);
	}
	return nTabLength;
}

// p󔒂`
int EditView::DrawMarkSpace(wgc::DeviceContext &dc, const POINT &ptBase, const UINT x) const
{
	const wchar_t wch = sgc::charcode::wSPACE;
	const UINT nWidth  = CalcCodeWidth(wch);
	const UINT nHeight = GetFontHeight();

	const POINT pt = {ptBase.x + x, ptBase.y};
	if(m_property.infoText.flags.elements.bDrawMarkSpace)
	{
		DrawStaple(
			dc,
			pt,
			nWidth, nHeight,
			m_property.fcMark.colorText, m_property.fcMark.colorBack);
	}
	else
	{
		PutString(
			dc,
			pt,
			&wch, 1,
			nWidth);
	}
	return nWidth;
}

// Sp󔒂`
int EditView::DrawMarkWideSpace(wgc::DeviceContext &dc, const POINT &ptBase, const UINT x) const
{
	const wchar_t wch = sgc::charcode::wWIDESPACE;
	const UINT nWidth  = CalcCodeWidth(wch);
	const UINT nHeight = GetFontHeight();

	const POINT pt = {ptBase.x + x, ptBase.y};
	if(m_property.infoText.flags.elements.bDrawMarkWideSpace)
	{
		DrawRect(
			dc,
			pt,
			nWidth, nHeight,
			m_property.fcMark.colorText, m_property.fcMark.colorBack);
	}
	else
	{
		PutString(
			dc,
			pt,
			&wch, 1,
			nWidth);
	}
	return nWidth;
}

int EditView::DrawMarkNul(wgc::DeviceContext &dc, const POINT &ptBase, const UINT x) const
{
	const wchar_t wch = sgc::charcode::wNUL;
	const UINT nWidth  = CalcCodeWidth(wch);

	const POINT pt = {ptBase.x + x, ptBase.y};
	PutString(
		dc,
		pt,
		&wch, 1,
		nWidth);

	return nWidth;
}


// ̘A`
void EditView::DrawPolyPolyLine(
	wgc::DeviceContext &dc,
	const RECT &rcFill,
	const POINT ptVertexes[], const DWORD dwPolyPoints[], const DWORD dwCount,
	const COLORREF colorPen, const COLORREF colorBack) const
{
	// ŏɔwiFœhԂ
	dc.FillSolidRect(rcFill, colorBack);

	// 
	wgc::GdiPen pen(PS_SOLID, 0, colorPen);
	{
		wgc::AutoSelectGDI selectPen(dc, pen);
		dc.PolyPolyline(ptVertexes, dwPolyPoints, dwCount);
	}
}

// zb`LX̐j`
void EditView::DrawStaple(
	wgc::DeviceContext &dc,
	const POINT &pt,
	const UINT nWidth, const UINT nHeight,
	const COLORREF colorPen, const COLORREF colorBack) const
{
	// 
	POINT ptBase;
	CalcDisplayPos(pt, ptBase);

	// hԂ̈
	const RECT rcFill = {ptBase.x, ptBase.y, ptBase.x + nWidth, ptBase.y + nHeight};

	// e_vZ
	const POINT ptVertexes[] =
	{
		{ptBase.x          + 1, ptBase.y + nHeight - 3},
		{ptBase.x          + 1, ptBase.y + nHeight - 2},
		{ptBase.x + nWidth - 2, ptBase.y + nHeight - 2},
		{ptBase.x + nWidth - 2, ptBase.y + nHeight - 4},
	};
	const DWORD dwPolyPoints = countof(ptVertexes);

	DrawPolyPolyLine(
		dc,
		rcFill,
		ptVertexes, &dwPolyPoints, 1,
		colorPen, colorBack);
}

// ``
void EditView::DrawRect(
	wgc::DeviceContext &dc,
	const POINT &pt,
	const UINT nWidth, const UINT nHeight,
	const COLORREF colorPen, const COLORREF colorBack) const
{
	// 
	POINT ptBase;
	CalcDisplayPos(pt, ptBase);

	// hԂ̈
	const RECT rcFill = {ptBase.x, ptBase.y, ptBase.x + nWidth, ptBase.y + nHeight};

	// e_vZ
	const POINT ptVertexes[] =
	{
		{ptBase.x          + 1, ptBase.y           + 1},
		{ptBase.x          + 1, ptBase.y + nHeight - 2},
		{ptBase.x + nWidth - 2, ptBase.y + nHeight - 2},
		{ptBase.x + nWidth - 2, ptBase.y           + 1},
		{ptBase.x          + 1, ptBase.y           + 1},
	};
	const DWORD dwPolyPoints = countof(ptVertexes);

	DrawPolyPolyLine(
		dc,
		rcFill,
		ptVertexes, &dwPolyPoints, 1,
		colorPen, colorBack);
}

// `
void EditView::DrawArrow(
	wgc::DeviceContext &dc,
	const RECT &rcFill,
	const POINT   &ptTail   , const POINT   &ptHead,
	const POINT   &ptBranch1, const POINT   &ptBranch2,
	const COLORREF colorPen , const COLORREF colorBack) const
{
	const POINT ptVertexes[] =
	{
		ptTail, ptHead, ptBranch1,
		ptHead, ptBranch2,
	};
	const DWORD dwPolyPoints[] =
	{
		3,
		2,
	};

	DrawPolyPolyLine(
		dc,
		rcFill,
		ptVertexes, dwPolyPoints, countof(dwPolyPoints),
		colorPen, colorBack);
}

// `
void EditView::DrawArrowLeft(
	wgc::DeviceContext &dc,
	const POINT &pt,
	const UINT     nWidth    , const UINT     nHeight,
	const UINT     nFillWidth, const UINT     nFillHeight,
	const COLORREF colorPen  , const COLORREF colorBack) const
{
	POINT ptBase;
	CalcDisplayPos(pt, ptBase);

	// 
	// hԂ̈
	const RECT rcFill = {ptBase.x, ptBase.y, ptBase.x + nFillWidth, ptBase.y + nFillHeight};

	// e_vZ
	const POINT ptTail = {ptBase.x + nWidth - 1, ptBase.y + nHeight / 2};
	const POINT ptHead = {ptBase.x             , ptBase.y + nHeight / 2};
	const POINT ptBranch1 = {ptHead.x + nHeight / 4, ptHead.y - nHeight / 4};
	const POINT ptBranch2 = {ptHead.x + nHeight / 4, ptHead.y + nHeight / 4};

	DrawArrow(dc, rcFill, ptTail, ptHead, ptBranch1, ptBranch2, colorPen, colorBack);
}

// E`
void EditView::DrawArrowRight(
	wgc::DeviceContext &dc,
	const POINT &pt,
	const UINT     nWidth    , const UINT     nHeight,
	const UINT     nFillWidth, const UINT     nFillHeight,
	const COLORREF colorPen  , const COLORREF colorBack) const
{
	// 
	POINT ptBase;
	CalcDisplayPos(pt, ptBase);

	// hԂ̈
	const RECT rcFill = {ptBase.x, ptBase.y, ptBase.x + nFillWidth, ptBase.y + nFillHeight};

	// e_vZ
	const POINT ptTail = {ptBase.x             , ptBase.y + nHeight / 2};
	const POINT ptHead = {ptBase.x + nWidth - 1, ptBase.y + nHeight / 2};
	const POINT ptBranch1 = {ptHead.x - nHeight / 4, ptHead.y - nHeight / 4};
	const POINT ptBranch2 = {ptHead.x - nHeight / 4, ptHead.y + nHeight / 4};

	DrawArrow(dc, rcFill, ptTail, ptHead, ptBranch1, ptBranch2, colorPen, colorBack);
}

// `
void EditView::DrawArrowUp(
	wgc::DeviceContext &dc,
	const POINT &pt,
	const UINT     nWidth    , const UINT     nHeight,
	const UINT     nFillWidth, const UINT     nFillHeight,
	const COLORREF colorPen  , const COLORREF colorBack) const
{
	// 
	POINT ptBase;
	CalcDisplayPos(pt, ptBase);

	// hԂ̈
	const RECT rcFill = {ptBase.x, ptBase.y, ptBase.x + nFillWidth, ptBase.y + nFillHeight};

	// e_vZ
	const POINT ptTail = {ptBase.x + nWidth / 2, ptBase.y + (nHeight * 3 / 4)};
	const POINT ptHead = {ptBase.x + nWidth / 2, ptBase.y + (nHeight * 1 / 4)};
	const POINT ptBranch1 = {ptHead.x - nWidth / 2, ptHead.y + nWidth / 2};
	const POINT ptBranch2 = {ptHead.x + nWidth / 2, ptHead.y + nWidth / 2};

	DrawArrow(dc, rcFill, ptTail, ptHead, ptBranch1, ptBranch2, colorPen, colorBack);
}

// `
void EditView::DrawArrowDown(
	wgc::DeviceContext &dc,
	const POINT &pt,
	const UINT     nWidth    , const UINT     nHeight,
	const UINT     nFillWidth, const UINT     nFillHeight,
	const COLORREF colorPen  , const COLORREF colorBack) const
{
	// 
	POINT ptBase;
	CalcDisplayPos(pt, ptBase);

	// hԂ̈
	const RECT rcFill = {ptBase.x, ptBase.y, ptBase.x + nFillWidth, ptBase.y + nFillHeight};

	// e_vZ
	const POINT ptTail = {ptBase.x + nWidth / 2, ptBase.y + (nHeight * 1 / 4)};
	const POINT ptHead = {ptBase.x + nWidth / 2, ptBase.y + (nHeight * 3 / 4)};
	const POINT ptBranch1 = {ptHead.x - nWidth / 2, ptHead.y - nWidth / 2};
	const POINT ptBranch2 = {ptHead.x + nWidth / 2, ptHead.y - nWidth / 2};

	DrawArrow(dc, rcFill, ptTail, ptHead, ptBranch1, ptBranch2, colorPen, colorBack);
}

// `
UINT EditView::PutString(wgc::DeviceContext &dc, const POINT &pt, LPCWSTR lpString, const SIZE_T nCount, const UINT nOpaqueLength /* = 0 */) const
{
	POINT ptDisplay;
	CalcDisplayPos(pt, ptDisplay);

	UINT nWidth = 0;

	// Ԋu̐ݒ
	sgc::array<int> dx(nCount);
	for(SIZE_T i = 0; i < nCount; i++)
	{
		const wchar_t wch = lpString[i];
		const UINT nLength = CalcCodeWidth(wch);
		dx[i]   = nLength;
		nWidth += nLength;
	}

	if(nOpaqueLength > 0)
	{
		nWidth = nOpaqueLength;
	}

	RECT rect;
	rect.left   = ptDisplay.x;
	rect.top    = ptDisplay.y;
	rect.right  = rect.left + nWidth;
	rect.bottom = rect.top  + GetFontHeight();

	dc.ExtTextOutWide(
		ptDisplay,
		ETO_OPAQUE | ETO_CLIPPED,
		rect,
		lpString, static_cast<int>(nCount),
		dx);

	return nWidth;
}


////////////////////////////////////////////////////////////
// EChEbZ[W֘A

// EChEvV[W
LRESULT EditView::WindowProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
	case EM_GETMODIFY: return OnEmGetModify();
	case EM_SETMODIFY: OnEmSetModify(static_cast<BOOL>(wParam)); return 0;

	case EM_SETREADONLY: return OnEmSetReadOnly(static_cast<BOOL>(wParam));

	case EM_GETMARGINS: return OnEmGetMargins();
	case EM_SETMARGINS: OnEmSetMargins(static_cast<WORD>(wParam), LOWORD(lParam), HIWORD(lParam)); return 0;

	case EM_GETLINECOUNT: return OnEmGetLineCount();

	case WM_UNDO:    // no break
	case EM_UNDO:    return OnEmUndo();
	case EM_CANUNDO: return OnEmCanUndo();

	case EM_REDO:    return OnEmRedo();
	case EM_CANREDO: return OnEmCanRedo();

	case EM_SETUNDOLIMIT:    return OnEmSetUndoLimit(wParam);
	case EM_EMPTYUNDOBUFFER: OnEmEmptyUndoBuffer(); return 0;

	case WM_CUT:      OnCut  (); return 0;
	case WM_COPY:     OnCopy (); return 0;
	case WM_CLEAR:    OnClear(); return 0;
	case WM_PASTE:    OnPaste(); return 0;
	case EM_CANPASTE: return OnEmCanPaste(static_cast<UINT>(wParam));

	case EM_RECONVERSION: OnEmReconversion(); return 0;
	}

	// NX̃vV[WĂяo
	return Window::WindowProc(uMsg, wParam, lParam);
}


void EditView::PostNcDestroy(void)
{
	delete this;
}

// EChE쐬
int EditView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if(Window::OnCreate(lpCreateStruct) == -1)
	{
		return -1;
	}

	SetProperty(m_property, m_keyword, m_hFont);

	// {block}
	// XN[o[̐ݒ
	{
		SyncHScroll();
		SyncVScroll();
	}

	// hbv^[Qbg̓o^
	m_oleDropTarget.Register(this);
	return 0;
}

void EditView::OnDestroy(void)
{
	// hbv^[Qbg
	RevokeDragDrop();
}


UINT EditView::OnGetDlgCode(LPMSG /* lpMsg */)
{
	return DLGC_WANTARROWS | DLGC_WANTCHARS;
}


// TCYύX
void EditView::OnSize(const UINT /* nType */, const int /* cx */, const int /* cy */)
{
	UpdateTextAreaSize();
}


// tH[JX̐ݒ
void EditView::OnSetFocus(HWND /* hWndLoseFocus */)
{
	// Jbg쐬
	CreateEditCaret();

	// ۑJ[\ʒu𕜌
	m_rDocument.SetXY(m_ptLogicalPrev, sgc::edit_manager::MS_NOCHANGE, FALSE);

	ShowCaret();

	SetImeFont();

	// {block}
	// hLgɒʒm
	{
		const int nID = GetDlgCtrlID();
		m_rDocument.SetFocusTo(nID);
	}
}

void EditView::OnKillFocus(HWND /* hWndGetFocus */)
{
	// tH[JXƂ͈̓ʒuۑ
	m_ptLogicalPrev = m_rDocument.GetXY();

	// Jbgj
	HideCaret();
	::DestroyCaret();

	// 
	if(IsCursorUnderline() && !m_rDocument.IsSelected())
	{
		wgc::DeviceContext_Client dc(m_hWnd);
		PaintUnderline(dc, m_ptCaretPrev, FALSE);
	}
}


// tHg̐ݒ
void EditView::OnSetFont(HFONT hFont, const BOOL bRedraw)
{
	// ÂtHg̔j`͌Ăяo
	m_hFont = hFont;

	// {block}
	{
		wgc::DeviceContext_Client dc(m_hWnd);
		wgc::GdiFont font(m_hFont);
		{
			wgc::AutoSelectGDI selectFont(dc, font);

			FreeCharWidthArray();

			// l̍̕ől擾
			m_nNumWidthMax = INT_MIN;
			for(wchar_t ch = L'0'; ch <= L'9'; ch++)
			{
				INT nWidth = CalcCodeWidth(ch, FALSE);
				if(m_nNumWidthMax < nWidth)
				{
					m_nNumWidthMax = nWidth;
				}
			}

			// {block}
			// tHgTCY擾
			{
				TEXTMETRIC tm;
				dc.GetTextMetrics(tm);

				SetFontSize(tm.tmAveCharWidth, tm.tmHeight);
			}

			SetImeFont();

			// tH[JXĂ΃Jbgč쐬
			if(IsFocused())
			{
				HideCaret();
				CreateEditCaret();
				ShowCaret();
			}
		}
	}

	// ĕ`
	if(bRedraw)
	{
		Invalidate();
	}
}

HFONT EditView::OnGetFont(void)
{
	return m_hFont;
}


// XN[
void EditView::OnHScroll(const UINT nSBCode, const UINT /* nPos */, HWND /* hWndScrollBar */)
{
	INT_PTR dx = 0;                         // XN[

	const int nFontWidth = GetFontWidth();

	// nPos  16bit Ȃ̂ŁA𒴂l GetScrollInfo() gĎ擾
	SCROLLINFO si = {sizeof(si), SIF_RANGE | SIF_POS | SIF_TRACKPOS};
	GetHScrollInfo(si);

	// XN[ʂ
	switch(nSBCode)
	{
	case SB_TOP:    dx =                               - si.nPos; break;
	case SB_BOTTOM: dx = (si.nMax - m_sizeTextArea.cx) - si.nPos; break;

	case SB_LINEUP:   dx = -nFontWidth; break;
	case SB_LINEDOWN: dx = +nFontWidth; break;

	case SB_PAGEUP:   dx = -m_sizeTextArea.cx; break;
	case SB_PAGEDOWN: dx = +m_sizeTextArea.cx; break;

	case SB_THUMBTRACK: dx = si.nTrackPos - si.nPos; break;
	}

	int diff = nFontWidth - 1;
	if(dx < 0) { diff = -diff; }
	dx = (dx + diff) / nFontWidth;

	// {block}
	// XN[
	{
		UPDATE_CLIENT_INFO update_info;
		InitUpdateClientInfo(update_info);

		ScrollPhysical(dx, 0, update_info);
		UpdateClient(update_info);
	}
}

// XN[
void EditView::OnVScroll(const UINT nSBCode, const UINT /* nPos */, HWND /* hWndScrollBar */)
{
	INT_PTR dy = 0;                         // XN[

	// XN[ʂ
	switch(nSBCode)
	{
	case SB_TOP:    dy = 1 - m_nLineNumberTop; break;
	case SB_BOTTOM: dy = m_rDocument.GetLineCount() - m_nLineNumberTop; break;

	case SB_LINEUP:   dy = -1; break;
	case SB_LINEDOWN: dy = +1; break;

	case SB_PAGEUP:   dy = -m_sizeTextArea.cy; break;
	case SB_PAGEDOWN: dy = +m_sizeTextArea.cy; break;

	case SB_THUMBTRACK:
		{
			// nPos  16bit Ȃ̂ŁA𒴂l GetScrollInfo() gĎ擾
			SCROLLINFO si = {sizeof(si), SIF_POS | SIF_TRACKPOS};
			GetVScrollInfo(si);
			dy = si.nTrackPos - si.nPos;
		}
		break;
	}

	// {block}
	// XN[
	{
		UPDATE_CLIENT_INFO update_info;
		InitUpdateClientInfo(update_info);

		ScrollPhysical(0, dy, update_info);
		UpdateClient(update_info);
	}
}


// J[\`̕ύX
BOOL EditView::OnSetCursor(const HWND hWnd, const UINT nHitTest, const UINT message)
{
	// NCAg̈ɂꍇ
	if(nHitTest == HTCLIENT)
	{
		switch(m_cht)
		{
		case CHT_MARGIN:
			::SetCursor(m_hCursorMargin);
			return TRUE;

		case CHT_SELECTED:
			::SetCursor(::LoadCursor(NULL, IDC_ARROW));
			return TRUE;
		}
	}

	return Window::OnSetCursor(hWnd, nHitTest, message);
}


////////////////////////////////////////////////////////////
// }EXbZ[W

BOOL EditView::OnMouseWheel(const UINT /* nFlags */, const short zDelta, const POINT & /* point */)
{
	const int scroll = -zDelta / WHEEL_DELTA * 3;

	UPDATE_CLIENT_INFO update_info;
	InitUpdateClientInfo(update_info);

	// XN[̂ݍs
	ScrollPhysical(0, scroll, update_info);
	UpdateClient(update_info);
	return TRUE;
}

void EditView::OnMouseMove(const UINT nFlags, const POINT &point)
{
	// gvNbN
	m_dwDblClkTickCount = 0;

	// qbgeXg
	m_cht = ClientHitTest(point);

	// {^ĂȂΉȂ
	if((nFlags & MK_LBUTTON) == 0)
	{
		return;
	}

	// }EXLv`ĂȂΉȂ
	if(!IsCaptured())
	{
		return;
	}

	// ÏXVNbNꂽꏊփJbgړ
	MoveCaretToPoint(point, TRUE);

	// sI[h̏ꍇ
	if(m_bSelectLine)
	{
		m_rDocument.SelectLine(sgc::edit_manager::SC_END, TRUE);
	}
}

void EditView::OnLButtonDown(const UINT nFlags, const POINT &point)
{
	if(IsTripleClick())
	{
		// gvNbNȂsŜI
		m_rDocument.SelectLine(sgc::edit_manager::SC_NOMOVE);
		return;
	}

	// ÏȂOLEhbOhbv
	if(m_cht == CHT_SELECTED)
	{
		OleDragDrop();
		return;
	}

	// }EXLv`
	SetCapture();
	SetFocus();

	// {block}
	// I[gXN[p^C}d|
	{
		DWORD dwKeyboardSpeed = 0;
		::SystemParametersInfo(SPI_GETKEYBOARDSPEED, 0, &dwKeyboardSpeed, 0 );
		SetTimer(TID_AUTOSCROLL, dwKeyboardSpeed);
	}

	// NbNꂽꏊփJbgړ
	// VtgL[ĂΑÏXV
	const BOOL bShiftPressed = nFlags & MK_SHIFT;
	MoveCaretToPoint(point, bShiftPressed);

	// Rg[L[ĂΒPI
	const BOOL bControlPressed = nFlags & MK_CONTROL;
	if(bControlPressed)
	{
		// ݈ʒu̒PI
		m_rDocument.SelectWord(sgc::edit_manager::SC_NOMOVE, bShiftPressed);
		m_cht = CHT_SELECTED;
	}

	// ]̈ȂsŜI
	if(m_cht == CHT_MARGIN)
	{
		m_bSelectLine = TRUE;
		m_rDocument.SelectLine(sgc::edit_manager::SC_END, bShiftPressed);
	}
}

void EditView::OnLButtonUp(const UINT /* nFlags */, const POINT & /* point */)
{
	m_bSelectLine = FALSE;

	if(IsCaptured())
	{
		// Lv`
		::ReleaseCapture();

		// ^C}
		KillTimer(TID_AUTOSCROLL);
	}
}

void EditView::OnLButtonDblClk(const UINT /* nFlags */, const POINT & /* point */)
{
	// ݂̃VXeԂ擾i~bj
	m_dwDblClkTickCount = ::GetTickCount();

	// ݈ʒu̒PI
	m_rDocument.SelectWord();
	m_cht = CHT_SELECTED;
}

void EditView::OnRButtonDown(const UINT /* nFlags */, const POINT &point)
{
	SetFocus();

	SetLogicalPos(point);

	// {block}
	// J[\悤ɃXN[
	{
		UPDATE_CLIENT_INFO update_info;
		InitUpdateClientInfo(update_info);
		EnsureVisible       (update_info);
		UpdateClient        (update_info);
	}
}

void EditView::OnMButtonDown(const UINT /* nFlags */, const POINT & /* point */)
{
	SetFocus();
}


////////////////////////////////////////////////////////////
// L[{[hbZ[W

// L[{[h
void EditView::OnKeyDown(const UINT nChar, const UINT /* nRepeatCount */, const UINT /* nFlags */)
{
	UPDATE_CLIENT_INFO update_info;
	InitUpdateClientInfo(update_info);

	switch(nChar)
	{
	case VK_PRIOR: KeyPageUp  (update_info); break;
	case VK_NEXT:  KeyPageDown(update_info); break;
	case VK_HOME:  KeyHome    (update_info); break;
	case VK_END:   KeyEnd     (update_info); break;

	case VK_LEFT:  KeyLeft (update_info); break;
	case VK_RIGHT: KeyRight(update_info); break;
	case VK_UP:    KeyUp   (update_info); break;
	case VK_DOWN:  KeyDown (update_info); break;

	case VK_RETURN: KeyReturn(); return;
	case VK_BACK:   KeyBack  (); return;
	case VK_DELETE: KeyDelete(); return;

	case VK_INSERT: KeyInsert(); return;
	case VK_ESCAPE: KeyEscape(); return;
	}

	UpdateClient(update_info);
}

// 
void EditView::OnChar(const UINT nChar, const UINT nRepeatCount, const UINT /* nFlags */)
{
	const TCHAR tch = static_cast<TCHAR>(nChar);

	WCHAR wch = tch;
#ifndef UNICODE
	::MultiByteToWideChar(CP_ACP, MB_COMPOSITE, &tch, 1, &wch, 1);
#endif

	CharInput(wch, nRepeatCount);
}

void EditView::OnUniChar(const UINT nChar, const UINT nRepeatCount, const UINT /* nFlags */)
{
	if(nChar != UNICODE_NOCHAR)
	{
		const WCHAR wch = static_cast<WCHAR>(nChar);
		CharInput(wch, nRepeatCount);
	}
}

// IME̕
void EditView::OnImeComposition(const WORD chDBCS, const UINT nFlags)
{
	if((nFlags & GCS_RESULTSTR) != GCS_RESULTSTR)
	{
		Window::OnImeComposition(chDBCS, nFlags);
		return;
	}

	wgc::Imm immcontext(m_hWnd);
	wgc::wstring_t wtext;

	// Unicode`ŕϊ̕擾iWindows 98ȍ~j
	immcontext.GetCompositionString_ResultStrWide(wtext);

#ifndef UNICODE
	if(wtext.empty())
	{
		// Windows 95łUnicode`Ŏ擾łȂ̂ŁAAPIgĕϊ
		wgc::string_t tstr;
		immcontext.GetCompositionString_ResultStr(tstr);

		wgc::wgfMultiByteToWideChar(tstr, wtext);
	}
#endif

	m_rDocument.InsertText(wtext);
}

// ĕϊ̐ݒ
DWORD EditView::OnImeRequest_ReconvertString(RECONVERTSTRING *lpRs)
{
	// IꂽeLXg擾
	wgc::tstring_t tstr;
	m_rDocument.GetSelectedText(tstr);

	// TCYvZ
	const DWORD dwStrLength = static_cast<DWORD>(tstr.length());
	const DWORD dwSize      = static_cast<DWORD>(sizeof(RECONVERTSTRING) + (dwStrLength + 1) * sizeof(TCHAR));

	if(lpRs != NULL)
	{
		// RECONVERTSTRING 𖄂߂
		lpRs->dwSize            = dwSize;
		lpRs->dwVersion         = 0;
		lpRs->dwStrLen          = dwStrLength;
		lpRs->dwStrOffset       = sizeof(RECONVERTSTRING);
		lpRs->dwCompStrLen      = dwStrLength;
		lpRs->dwCompStrOffset   = 0;
		lpRs->dwTargetStrLen    = dwStrLength;
		lpRs->dwTargetStrOffset = 0;

		// RECONVERTSTRING ̌ɍĕϊݒ
		if(dwStrLength > 0)
		{
			LPBYTE lpHead   = reinterpret_cast<LPBYTE>(lpRs);
			LPTSTR lpString = reinterpret_cast<LPTSTR>(lpHead + lpRs->dwStrOffset);
			::lstrcpy(lpString, tstr.c_str());
		}

		// {block}
		// I͈͂̍ŏֈړ
		{
			position_t sel_begin, sel_end;
			m_rDocument.GetSelectedRange(sel_begin, sel_end);
			m_rDocument.SetXY(sel_begin, sgc::edit_manager::MS_NOCHANGE);
		}

		// {block}
		// J[\ʓɕ\
		{
			UPDATE_CLIENT_INFO update_info;
			InitUpdateClientInfo(update_info);

			EnsureVisible(update_info);
			UpdateClient (update_info);
		}
	}

	return dwSize;
}


// ^C}
void EditView::OnTimer(const UINT uIDEvent)
{
	switch(uIDEvent)
	{
	case TID_AUTOSCROLL:
		// I[gXN[
		ScrollAuto();
		break;
	}
}


// ʕ`
void EditView::OnPaint(void)
{
	// œK̂߁Aĕ`̕Kvȗ݂̈̂`悵Ă
	wgc::DeviceContext_Paint dc(m_hWnd);

	// sԍĕ`悷邩H
	BOOL bLineNumber = FALSE;
	if(IsLineNumberVisible())
	{
		RECT rcLineNumber;
		CalcRectLineNumber(rcLineNumber);

		// sԍ̈悪NbsÖɊ܂܂Ă΍ĕ`
		if(dc.RectVisible(rcLineNumber))
		{
			bLineNumber = TRUE;
			dc.ExcludeClipRect(rcLineNumber);
		}
	}

	// [[ĕ`悷邩H
	BOOL bRuler = FALSE;
	if(IsRulerVisible())
	{
		RECT rcRuler;
		CalcRectRuler(rcRuler);

		// [[̈悪NbsÖɊ܂܂Ă΍ĕ`
		if(dc.RectVisible(rcRuler))
		{
			bRuler = TRUE;
			dc.ExcludeClipRect(rcRuler);
		}
	}

	// {block}
	// ĕ`悷eLXg̈vZ
	INT_PTR nLineNumberRedraw = 0;
	INT_PTR nLineCountRedraw  = -1;
	{
		RECT rcText;
		CalcRectText(rcText, FALSE);

		RECT rcClip;
		dc.GetClipBox(rcClip);
		::OffsetRect(&rcClip, -rcText.left, -rcText.top);

		const LONG nFontHeight = GetFontHeight();
		nLineNumberRedraw = rcClip.top / nFontHeight;
		nLineCountRedraw  = ((rcClip.bottom + nFontHeight - 1) / nFontHeight) - nLineNumberRedraw;
	}

	// NCAg̈ĕ`
	PaintClient(dc, nLineNumberRedraw, nLineCountRedraw, bLineNumber, bRuler);

	// `
	if(IsCursorUnderline() && IsFocused() && !m_rDocument.IsSelected())
	{
		PaintUnderline(dc, m_ptCaret, TRUE);
	}
}

// wi
BOOL EditView::OnEraseBkgnd(HDC hDC)
{
	wgc::DeviceContext dc = hDC;

	PaintTextBack      (dc);
	PaintLineNumberBack(dc);
	PaintRulerBack     (dc);

	return TRUE;
}


////////////////////////////////////////////////////////////////////////////////
// ҏWbZ[Wnh

// _[eBtO擾(EM_GETMODIFY)
BOOL EditView::OnEmGetModify(void) const
{
	return m_rDocument.IsModified();
}

// _[eBtOݒ(EM_SETMODIFY)
void EditView::OnEmSetModify(const BOOL bModified)
{
	m_rDocument.SetModify(bModified);
}

// ǂݎpt/iEM_SETREADONLYj
BOOL EditView::OnEmSetReadOnly(const BOOL bReadOnly)
{
	return m_rDocument.SetReadOnly(bReadOnly);
}

// E̗]ݒiEM_SETMARGINSj
void EditView::OnEmSetMargins(const WORD fwMargin, const WORD wLeft, const WORD wRight)
{
	// tHg̕ɂė]
	if(fwMargin == EC_USEFONTINFO)
	{
		m_nTextMarginLeft  = CalcCodeWidth(L'C', FALSE);
		m_nTextMarginRight = CalcCodeWidth(L'A', FALSE);
	}
	else
	{
		if(fwMargin & EC_LEFTMARGIN ) { m_nTextMarginLeft  = wLeft;  }
		if(fwMargin & EC_RIGHTMARGIN) { m_nTextMarginRight = wRight; }
	}
	UpdateTextAreaSize();
}

// E̗]擾iEM_GETMARGINSj
DWORD EditView::OnEmGetMargins(void) const
{
	return MAKELONG(m_nTextMarginLeft, m_nTextMarginRight);
}

// obt@̍s擾iEM_GETLINECOUNTj
SIZE_T EditView::OnEmGetLineCount(void) const
{
	return m_rDocument.GetLineCount();
}

// AhD(WM_UNDO, EM_UNDO)
BOOL EditView::OnEmUndo(void)
{
	return m_rDocument.Undo();
}

// AhDł邩H(EM_CANUNDO)
BOOL EditView::OnEmCanUndo(void) const
{
	return m_rDocument.CanUndo();
}

// hD(EM_REDO)
BOOL EditView::OnEmRedo(void)
{
	return m_rDocument.Redo();
}

// hDł邩H(EM_CANREDO)
BOOL EditView::OnEmCanRedo(void) const
{
	return m_rDocument.CanRedo();
}

// őAhD񐔂ݒ
INT_PTR EditView::OnEmSetUndoLimit(const INT_PTR nLimit)
{
	return m_rDocument.SetUndoLimit(nLimit);
}

void EditView::OnEmEmptyUndoBuffer(void)
{
	m_rDocument.EmptyUndoBuffer();
}

// Jbg(WM_CUT)
void EditView::OnCut(void)
{
	return m_rDocument.Cut();
}

// I͈͂Nbv{[hɃRs[(WM_COPY)
void EditView::OnCopy(void)
{
	m_rDocument.Copy();
}

// I͈͂폜(WM_CLEAR)
void EditView::OnClear(void)
{
	m_rDocument.Delete();
}

// Nbv{[h̃f[^y[Xg(WM_PASTE)
void EditView::OnPaste(void)
{
	m_rDocument.Paste();
}

// wtH[}bgy[Xgł邩H(EM_CANPASTE)
BOOL EditView::OnEmCanPaste(const UINT uFormat) const
{
	return m_rDocument.CanPaste(uFormat);
}

// ĕϊ
void EditView::OnEmReconversion(void)
{
	// obt@TCY擾
	const LRESULT lSize = SendMessage(WM_IME_REQUEST, IMR_RECONVERTSTRING);
	if(lSize == 0)
	{
		return;
	}

	// obt@m
	sgc::array<BYTE>  arBuffer(lSize);
	LPBYTE            lpBuffer = arBuffer;
	LPRECONVERTSTRING lpRs     = reinterpret_cast<LPRECONVERTSTRING>(lpBuffer);

	// RECONVERTSTRING 𖄂߂
	const LRESULT lResult = SendMessage(WM_IME_REQUEST, IMR_RECONVERTSTRING, reinterpret_cast<LPARAM>(lpRs));
	if(lResult == 0)
	{
		return;
	}

	// {block}
	// ĕϊ
	{
		wgc::Imm immcontext(m_hWnd);
		immcontext.SetCompositionString_QueryReconvertString(lpRs);
		immcontext.SetCompositionString_SetReconvertString  (lpRs);
	}
}


////////////////////////////////////////////////////////////////////////////////
// oϐ̐ݒ
// oϐ̒ɂ́AύXƂɑ̃IuWFNgƓ
// eEChE֒ʒmKv̂̂B
// ̂悤ȕϐύXƂ́AڕύX̂ł͂ȂύXp̃o֐KvB
// ́uύXp̃o֐vB
// GȂ͎̂́unhvœB

// tHgTCY̕ύX
void EditView::SetFontSize(const UINT cx, const UINT cy)
{
	m_sizeFont.cx = cx;
	m_sizeFont.cy = cy;

	UpdateTextAreaSize();
}

// eLXg̈̃TCY̕ύX
void EditView::SetTextAreaSize(const UINT cx, const UINT cy)
{
	m_sizeTextArea.cx = cx;
	m_sizeTextArea.cy = cy;

	// XN[o[Ɠ
	SyncHScroll();
	SyncVScroll();
}

// r[[̍sԍ̕ύX
void EditView::SetLineNumberTop(const INT_PTR nNewLineNumberTop)
{
	const  SIZE_T uLineCount = m_rDocument.GetLineCount();
	const INT_PTR sLineCount = uLineCount;

	// sԍ𐳋K
	INT_PTR nCorrectedLineNumberTop = nNewLineNumberTop;
	sgc::utility::saturate(nCorrectedLineNumberTop, 1, sLineCount);

	const LONG dy = static_cast<LONG>(m_nLineNumberTop - nCorrectedLineNumberTop);
	m_ptCaret    .y += dy;
	m_ptCaretPrev.y += dy;

	m_nLineNumberTop = nCorrectedLineNumberTop;
}

// r[[̌̕ύX
void EditView::SetColumnLeft(const INT_PTR nNewColumnLeft)
{
	// 𐳋K
	INT_PTR nCorrectedColumnLeft = nNewColumnLeft;
	if(nCorrectedColumnLeft < 0) { nCorrectedColumnLeft = 0; }

	const LINENUMBER_T  dx = (m_nColumnLeft - nCorrectedColumnLeft) * GetFontWidth();
	const LONG         ldx = static_cast<LONG>(dx);
	m_ptCaret    .x += ldx;
	m_ptCaretPrev.x += ldx;

	m_nColumnLeft = nCorrectedColumnLeft;
}


////////////////////////////////////////////////////////////////////////////////
// nh
// hLgƂ̘AgȂǁÁuoϐ̐ݒvgpłȂGȃIuWFNg̓Ƃ
// ύXꂽɂ̓nhĂԁB

// obt@ei͈ʒujύXꂽ
void EditView::OnSyncBuffer(const LINENUMBER_T lineModify, const BOOL bUpdateLineNumber /* = FALSE */)
{
	UPDATE_CLIENT_INFO update_info;
	InitUpdateClientInfo(update_info);

	update_info.bUpdateLineNumber = bUpdateLineNumber;

	if(m_nLineNumberTop > GetLineCount())
	{
		ScrollPhysical(0, GetLineCount() - m_nLineNumberTop, update_info);
	}

	// {block}
	// ύXꂽobt@̈ʒuȍ~𖳌
	{
		const LINENUMBER_T nFontHeight  = GetFontHeight();
		const LINENUMBER_T nValidHeight = (lineModify - m_nLineNumberTop) * nFontHeight;
		const LONG lValidHeight = static_cast<LONG>(nValidHeight);
		if(update_info.rcValid.bottom > lValidHeight)
		{
			update_info.rcValid.bottom = lValidHeight;
		}
	}

	// tH[JXĂ΃J[\ʒuXV
	if(IsFocused())
	{
		m_ptCaret = LogicalToPhysical(m_rDocument.GetXY(), &m_nInternalX);
		EnsureVisible(update_info);
	}

	// {block}
	// ݍs̒XV
	// {͕ύXꂽsȍ~`ݍslɓȂ΂Ȃ
	// Ƃ肠͕sy[Xg邱Ƃ͍lȂ
	// iʂɒvIȖłȂ̂Łj
	{
		EditDoc::const_iterator_t p = m_rDocument.GetIteratorNow();
		const UINT uLength = CalcPhysicalLength(p->c_str(), p->length());
		if(uLength > m_nLongestLine)
		{
			m_nLongestLine = uLength;
			update_info.bUpdateLongestLine = TRUE;
		}
	}

	UpdateClient(update_info);
}

// Jbg̈ʒuύXꂽ
void EditView::OnSyncCaret(const BOOL bUpdateSelection /* = FALSE */, const BOOL bUpdateInternalX /* = TRUE */)
{
	LPUINT pInternalX = NULL;
	if(bUpdateInternalX) { pInternalX = &m_nInternalX; }

	// {block}
	// Jbgʒuݒ
	{
		const position_t ptLogical = m_rDocument.GetXY();
		m_ptCaret = LogicalToPhysical(ptLogical, pInternalX);
		MoveCaret_Physical(m_ptCaret);
	}

	if(bUpdateSelection)
	{
		Invalidate(FALSE);
	}
}

// 񑀍֐
SIZE_T EditView::String_strspn(LPCWSTR lpString, const SIZE_T nCount, LPCWSTR lpSearchString, const SIZE_T nSearchCount)
{
	for(SIZE_T i = 0; i < nCount; i++)
	{
		for(SIZE_T j = 0; j < nSearchCount; j++)
		{
			if(lpString[i] == lpSearchString[j])
			{
				return i;
			}
		}
	}
	return nCount;
}
