// sfmt.h c SIMD-oriented Fast Mersenne TwisterASYɂ[NX
// SFMTASYɂĂ͉LURIQ
// http://www.math.sci.hiroshima-u.ac.jp/~m-mat/MT/SFMT/index-jp.html
// SFMT ver1.3.3̃\[XR[hx[XɁA]ȃvvZbTi#ifjłȂĂ
#ifndef __SGC_SFMT__
#define __SGC_SFMT__

#include "sgc.h"

////////////////////////////////////////////////////////////////////////////////
// p[^
#ifndef SFMT_MEXP
  #define SFMT_MEXP 19937
#endif
/*-----------------
  BASIC DEFINITIONS
  -----------------*/
/** Mersenne Exponent. The period of the sequence 
 *  is a multiple of 2^SFMT_MEXP-1.
 * #define SFMT_MEXP 19937 */
/** SFMT generator has an internal state array of 128-bit integers,
 * and N is its size. */
#define N (SFMT_MEXP / 128 + 1)
/** N32 is the size of internal state array when regarded as an array
 * of 32-bit integers.*/
#define N32 (N * 4)
/** N64 is the size of internal state array when regarded as an array
 * of 64-bit integers.*/
#define N64 (N * 2)


#if   SFMT_MEXP == 607
	#define POS1	2
	#define SL1	15
	#define SL2	3
	#define SR1	13
	#define SR2	3
	#define MSK1	0xfdff37ffU
	#define MSK2	0xef7f3f7dU
	#define MSK3	0xff777b7dU
	#define MSK4	0x7ff7fb2fU
	#define PARITY1	0x00000001U
	#define PARITY2	0x00000000U
	#define PARITY3	0x00000000U
	#define PARITY4	0x5986f054U


	/* PARAMETERS FOR ALTIVEC */
	#if defined(__APPLE__)	/* For OSX */
		#define ALTI_SL1	(vector unsigned int)(SL1, SL1, SL1, SL1)
		#define ALTI_SR1	(vector unsigned int)(SR1, SR1, SR1, SR1)
		#define ALTI_MSK	(vector unsigned int)(MSK1, MSK2, MSK3, MSK4)
		#define ALTI_MSK64 \
		(vector unsigned int)(MSK2, MSK1, MSK4, MSK3)
		#define ALTI_SL2_PERM \
		(vector unsigned char)(3,21,21,21,7,0,1,2,11,4,5,6,15,8,9,10)
		#define ALTI_SL2_PERM64 \
		(vector unsigned char)(3,4,5,6,7,29,29,29,11,12,13,14,15,0,1,2)
		#define ALTI_SR2_PERM \
		(vector unsigned char)(5,6,7,0,9,10,11,4,13,14,15,8,19,19,19,12)
		#define ALTI_SR2_PERM64 \
		(vector unsigned char)(13,14,15,0,1,2,3,4,19,19,19,8,9,10,11,12)
	#else	/* For OTHER OSs(Linux?) */
		#define ALTI_SL1	{SL1, SL1, SL1, SL1}
		#define ALTI_SR1	{SR1, SR1, SR1, SR1}
		#define ALTI_MSK	{MSK1, MSK2, MSK3, MSK4}
		#define ALTI_MSK64	{MSK2, MSK1, MSK4, MSK3}
		#define ALTI_SL2_PERM	{3,21,21,21,7,0,1,2,11,4,5,6,15,8,9,10}
		#define ALTI_SL2_PERM64	{3,4,5,6,7,29,29,29,11,12,13,14,15,0,1,2}
		#define ALTI_SR2_PERM	{5,6,7,0,9,10,11,4,13,14,15,8,19,19,19,12}
		#define ALTI_SR2_PERM64	{13,14,15,0,1,2,3,4,19,19,19,8,9,10,11,12}
	#endif	/* For OSX */
	#define IDSTR	"SFMT-607:2-15-3-13-3:fdff37ff-ef7f3f7d-ff777b7d-7ff7fb2f"
#elif SFMT_MEXP == 1279
	#define POS1	7
	#define SL1	14
	#define SL2	3
	#define SR1	5
	#define SR2	1
	#define MSK1	0xf7fefffdU
	#define MSK2	0x7fefcfffU
	#define MSK3	0xaff3ef3fU
	#define MSK4	0xb5ffff7fU
	#define PARITY1	0x00000001U
	#define PARITY2	0x00000000U
	#define PARITY3	0x00000000U
	#define PARITY4	0x20000000U


	/* PARAMETERS FOR ALTIVEC */
	#if defined(__APPLE__)	/* For OSX */
		#define ALTI_SL1	(vector unsigned int)(SL1, SL1, SL1, SL1)
		#define ALTI_SR1	(vector unsigned int)(SR1, SR1, SR1, SR1)
		#define ALTI_MSK	(vector unsigned int)(MSK1, MSK2, MSK3, MSK4)
		#define ALTI_MSK64 \
		(vector unsigned int)(MSK2, MSK1, MSK4, MSK3)
		#define ALTI_SL2_PERM \
		(vector unsigned char)(3,21,21,21,7,0,1,2,11,4,5,6,15,8,9,10)
		#define ALTI_SL2_PERM64 \
		(vector unsigned char)(3,4,5,6,7,29,29,29,11,12,13,14,15,0,1,2)
		#define ALTI_SR2_PERM \
		(vector unsigned char)(7,0,1,2,11,4,5,6,15,8,9,10,17,12,13,14)
		#define ALTI_SR2_PERM64 \
		(vector unsigned char)(15,0,1,2,3,4,5,6,17,8,9,10,11,12,13,14)
	#else	/* For OTHER OSs(Linux?) */
		#define ALTI_SL1	{SL1, SL1, SL1, SL1}
		#define ALTI_SR1	{SR1, SR1, SR1, SR1}
		#define ALTI_MSK	{MSK1, MSK2, MSK3, MSK4}
		#define ALTI_MSK64	{MSK2, MSK1, MSK4, MSK3}
		#define ALTI_SL2_PERM	{3,21,21,21,7,0,1,2,11,4,5,6,15,8,9,10}
		#define ALTI_SL2_PERM64	{3,4,5,6,7,29,29,29,11,12,13,14,15,0,1,2}
		#define ALTI_SR2_PERM	{7,0,1,2,11,4,5,6,15,8,9,10,17,12,13,14}
		#define ALTI_SR2_PERM64	{15,0,1,2,3,4,5,6,17,8,9,10,11,12,13,14}
	#endif	/* For OSX */
	#define IDSTR	"SFMT-1279:7-14-3-5-1:f7fefffd-7fefcfff-aff3ef3f-b5ffff7f"
#elif SFMT_MEXP == 2281
	#define POS1	12
	#define SL1	19
	#define SL2	1
	#define SR1	5
	#define SR2	1
	#define MSK1	0xbff7ffbfU
	#define MSK2	0xfdfffffeU
	#define MSK3	0xf7ffef7fU
	#define MSK4	0xf2f7cbbfU
	#define PARITY1	0x00000001U
	#define PARITY2	0x00000000U
	#define PARITY3	0x00000000U
	#define PARITY4	0x41dfa600U


	/* PARAMETERS FOR ALTIVEC */
	#if defined(__APPLE__)	/* For OSX */
		#define ALTI_SL1	(vector unsigned int)(SL1, SL1, SL1, SL1)
		#define ALTI_SR1	(vector unsigned int)(SR1, SR1, SR1, SR1)
		#define ALTI_MSK	(vector unsigned int)(MSK1, MSK2, MSK3, MSK4)
		#define ALTI_MSK64 \
		(vector unsigned int)(MSK2, MSK1, MSK4, MSK3)
		#define ALTI_SL2_PERM \
		(vector unsigned char)(1,2,3,23,5,6,7,0,9,10,11,4,13,14,15,8)
		#define ALTI_SL2_PERM64 \
		(vector unsigned char)(1,2,3,4,5,6,7,31,9,10,11,12,13,14,15,0)
		#define ALTI_SR2_PERM \
		(vector unsigned char)(7,0,1,2,11,4,5,6,15,8,9,10,17,12,13,14)
		#define ALTI_SR2_PERM64 \
		(vector unsigned char)(15,0,1,2,3,4,5,6,17,8,9,10,11,12,13,14)
	#else	/* For OTHER OSs(Linux?) */
		#define ALTI_SL1	{SL1, SL1, SL1, SL1}
		#define ALTI_SR1	{SR1, SR1, SR1, SR1}
		#define ALTI_MSK	{MSK1, MSK2, MSK3, MSK4}
		#define ALTI_MSK64	{MSK2, MSK1, MSK4, MSK3}
		#define ALTI_SL2_PERM	{1,2,3,23,5,6,7,0,9,10,11,4,13,14,15,8}
		#define ALTI_SL2_PERM64	{1,2,3,4,5,6,7,31,9,10,11,12,13,14,15,0}
		#define ALTI_SR2_PERM	{7,0,1,2,11,4,5,6,15,8,9,10,17,12,13,14}
		#define ALTI_SR2_PERM64	{15,0,1,2,3,4,5,6,17,8,9,10,11,12,13,14}
	#endif	/* For OSX */
	#define IDSTR	"SFMT-2281:12-19-1-5-1:bff7ffbf-fdfffffe-f7ffef7f-f2f7cbbf"
#elif SFMT_MEXP == 4253
	#define POS1	17
	#define SL1	20
	#define SL2	1
	#define SR1	7
	#define SR2	1
	#define MSK1	0x9f7bffffU
	#define MSK2	0x9fffff5fU
	#define MSK3	0x3efffffbU
	#define MSK4	0xfffff7bbU
	#define PARITY1	0xa8000001U
	#define PARITY2	0xaf5390a3U
	#define PARITY3	0xb740b3f8U
	#define PARITY4	0x6c11486dU


	/* PARAMETERS FOR ALTIVEC */
	#if defined(__APPLE__)	/* For OSX */
		#define ALTI_SL1	(vector unsigned int)(SL1, SL1, SL1, SL1)
		#define ALTI_SR1	(vector unsigned int)(SR1, SR1, SR1, SR1)
		#define ALTI_MSK	(vector unsigned int)(MSK1, MSK2, MSK3, MSK4)
		#define ALTI_MSK64 \
		(vector unsigned int)(MSK2, MSK1, MSK4, MSK3)
		#define ALTI_SL2_PERM \
		(vector unsigned char)(1,2,3,23,5,6,7,0,9,10,11,4,13,14,15,8)
		#define ALTI_SL2_PERM64 \
		(vector unsigned char)(1,2,3,4,5,6,7,31,9,10,11,12,13,14,15,0)
		#define ALTI_SR2_PERM \
		(vector unsigned char)(7,0,1,2,11,4,5,6,15,8,9,10,17,12,13,14)
		#define ALTI_SR2_PERM64 \
		(vector unsigned char)(15,0,1,2,3,4,5,6,17,8,9,10,11,12,13,14)
	#else	/* For OTHER OSs(Linux?) */
		#define ALTI_SL1	{SL1, SL1, SL1, SL1}
		#define ALTI_SR1	{SR1, SR1, SR1, SR1}
		#define ALTI_MSK	{MSK1, MSK2, MSK3, MSK4}
		#define ALTI_MSK64	{MSK2, MSK1, MSK4, MSK3}
		#define ALTI_SL2_PERM	{1,2,3,23,5,6,7,0,9,10,11,4,13,14,15,8}
		#define ALTI_SL2_PERM64	{1,2,3,4,5,6,7,31,9,10,11,12,13,14,15,0}
		#define ALTI_SR2_PERM	{7,0,1,2,11,4,5,6,15,8,9,10,17,12,13,14}
		#define ALTI_SR2_PERM64	{15,0,1,2,3,4,5,6,17,8,9,10,11,12,13,14}
	#endif	/* For OSX */
	#define IDSTR	"SFMT-4253:17-20-1-7-1:9f7bffff-9fffff5f-3efffffb-fffff7bb"
#elif SFMT_MEXP == 11213
	#define POS1	68
	#define SL1	14
	#define SL2	3
	#define SR1	7
	#define SR2	3
	#define MSK1	0xeffff7fbU
	#define MSK2	0xffffffefU
	#define MSK3	0xdfdfbfffU
	#define MSK4	0x7fffdbfdU
	#define PARITY1	0x00000001U
	#define PARITY2	0x00000000U
	#define PARITY3	0xe8148000U
	#define PARITY4	0xd0c7afa3U


	/* PARAMETERS FOR ALTIVEC */
	#if defined(__APPLE__)	/* For OSX */
		#define ALTI_SL1	(vector unsigned int)(SL1, SL1, SL1, SL1)
		#define ALTI_SR1	(vector unsigned int)(SR1, SR1, SR1, SR1)
		#define ALTI_MSK	(vector unsigned int)(MSK1, MSK2, MSK3, MSK4)
		#define ALTI_MSK64 \
		(vector unsigned int)(MSK2, MSK1, MSK4, MSK3)
		#define ALTI_SL2_PERM \
		(vector unsigned char)(3,21,21,21,7,0,1,2,11,4,5,6,15,8,9,10)
		#define ALTI_SL2_PERM64 \
		(vector unsigned char)(3,4,5,6,7,29,29,29,11,12,13,14,15,0,1,2)
		#define ALTI_SR2_PERM \
		(vector unsigned char)(5,6,7,0,9,10,11,4,13,14,15,8,19,19,19,12)
		#define ALTI_SR2_PERM64 \
		(vector unsigned char)(13,14,15,0,1,2,3,4,19,19,19,8,9,10,11,12)
	#else	/* For OTHER OSs(Linux?) */
		#define ALTI_SL1	{SL1, SL1, SL1, SL1}
		#define ALTI_SR1	{SR1, SR1, SR1, SR1}
		#define ALTI_MSK	{MSK1, MSK2, MSK3, MSK4}
		#define ALTI_MSK64	{MSK2, MSK1, MSK4, MSK3}
		#define ALTI_SL2_PERM	{3,21,21,21,7,0,1,2,11,4,5,6,15,8,9,10}
		#define ALTI_SL2_PERM64	{3,4,5,6,7,29,29,29,11,12,13,14,15,0,1,2}
		#define ALTI_SR2_PERM	{5,6,7,0,9,10,11,4,13,14,15,8,19,19,19,12}
		#define ALTI_SR2_PERM64	{13,14,15,0,1,2,3,4,19,19,19,8,9,10,11,12}
	#endif	/* For OSX */
	#define IDSTR	"SFMT-11213:68-14-3-7-3:effff7fb-ffffffef-dfdfbfff-7fffdbfd"
#elif SFMT_MEXP == 19937
	#define POS1	122
	#define SL1	18
	#define SL2	1
	#define SR1	11
	#define SR2	1
	#define MSK1	0xdfffffefU
	#define MSK2	0xddfecb7fU
	#define MSK3	0xbffaffffU
	#define MSK4	0xbffffff6U
	#define PARITY1	0x00000001U
	#define PARITY2	0x00000000U
	#define PARITY3	0x00000000U
	#define PARITY4	0x13c9e684U


	/* PARAMETERS FOR ALTIVEC */
	#if defined(__APPLE__)	/* For OSX */
		#define ALTI_SL1	(vector unsigned int)(SL1, SL1, SL1, SL1)
		#define ALTI_SR1	(vector unsigned int)(SR1, SR1, SR1, SR1)
		#define ALTI_MSK	(vector unsigned int)(MSK1, MSK2, MSK3, MSK4)
		#define ALTI_MSK64 \
		(vector unsigned int)(MSK2, MSK1, MSK4, MSK3)
		#define ALTI_SL2_PERM \
		(vector unsigned char)(1,2,3,23,5,6,7,0,9,10,11,4,13,14,15,8)
		#define ALTI_SL2_PERM64 \
		(vector unsigned char)(1,2,3,4,5,6,7,31,9,10,11,12,13,14,15,0)
		#define ALTI_SR2_PERM \
		(vector unsigned char)(7,0,1,2,11,4,5,6,15,8,9,10,17,12,13,14)
		#define ALTI_SR2_PERM64 \
		(vector unsigned char)(15,0,1,2,3,4,5,6,17,8,9,10,11,12,13,14)
	#else	/* For OTHER OSs(Linux?) */
		#define ALTI_SL1	{SL1, SL1, SL1, SL1}
		#define ALTI_SR1	{SR1, SR1, SR1, SR1}
		#define ALTI_MSK	{MSK1, MSK2, MSK3, MSK4}
		#define ALTI_MSK64	{MSK2, MSK1, MSK4, MSK3}
		#define ALTI_SL2_PERM	{1,2,3,23,5,6,7,0,9,10,11,4,13,14,15,8}
		#define ALTI_SL2_PERM64	{1,2,3,4,5,6,7,31,9,10,11,12,13,14,15,0}
		#define ALTI_SR2_PERM	{7,0,1,2,11,4,5,6,15,8,9,10,17,12,13,14}
		#define ALTI_SR2_PERM64	{15,0,1,2,3,4,5,6,17,8,9,10,11,12,13,14}
	#endif	/* For OSX */
	#define IDSTR	"SFMT-19937:122-18-1-11-1:dfffffef-ddfecb7f-bffaffff-bffffff6"
#elif SFMT_MEXP == 44497
	#define POS1	330
	#define SL1	5
	#define SL2	3
	#define SR1	9
	#define SR2	3
	#define MSK1	0xeffffffbU
	#define MSK2	0xdfbebfffU
	#define MSK3	0xbfbf7befU
	#define MSK4	0x9ffd7bffU
	#define PARITY1	0x00000001U
	#define PARITY2	0x00000000U
	#define PARITY3	0xa3ac4000U
	#define PARITY4	0xecc1327aU


	/* PARAMETERS FOR ALTIVEC */
	#if defined(__APPLE__)	/* For OSX */
		#define ALTI_SL1	(vector unsigned int)(SL1, SL1, SL1, SL1)
		#define ALTI_SR1	(vector unsigned int)(SR1, SR1, SR1, SR1)
		#define ALTI_MSK	(vector unsigned int)(MSK1, MSK2, MSK3, MSK4)
		#define ALTI_MSK64 \
		(vector unsigned int)(MSK2, MSK1, MSK4, MSK3)
		#define ALTI_SL2_PERM \
		(vector unsigned char)(3,21,21,21,7,0,1,2,11,4,5,6,15,8,9,10)
		#define ALTI_SL2_PERM64 \
		(vector unsigned char)(3,4,5,6,7,29,29,29,11,12,13,14,15,0,1,2)
		#define ALTI_SR2_PERM \
		(vector unsigned char)(5,6,7,0,9,10,11,4,13,14,15,8,19,19,19,12)
		#define ALTI_SR2_PERM64 \
		(vector unsigned char)(13,14,15,0,1,2,3,4,19,19,19,8,9,10,11,12)
	#else	/* For OTHER OSs(Linux?) */
		#define ALTI_SL1	{SL1, SL1, SL1, SL1}
		#define ALTI_SR1	{SR1, SR1, SR1, SR1}
		#define ALTI_MSK	{MSK1, MSK2, MSK3, MSK4}
		#define ALTI_MSK64	{MSK2, MSK1, MSK4, MSK3}
		#define ALTI_SL2_PERM	{3,21,21,21,7,0,1,2,11,4,5,6,15,8,9,10}
		#define ALTI_SL2_PERM64	{3,4,5,6,7,29,29,29,11,12,13,14,15,0,1,2}
		#define ALTI_SR2_PERM	{5,6,7,0,9,10,11,4,13,14,15,8,19,19,19,12}
		#define ALTI_SR2_PERM64	{13,14,15,0,1,2,3,4,19,19,19,8,9,10,11,12}
	#endif	/* For OSX */
	#define IDSTR	"SFMT-44497:330-5-3-9-3:effffffb-dfbebfff-bfbf7bef-9ffd7bff"
#elif SFMT_MEXP == 86243
	#define POS1	366
	#define SL1	6
	#define SL2	7
	#define SR1	19
	#define SR2	1
	#define MSK1	0xfdbffbffU
	#define MSK2	0xbff7ff3fU
	#define MSK3	0xfd77efffU
	#define MSK4	0xbf9ff3ffU
	#define PARITY1	0x00000001U
	#define PARITY2	0x00000000U
	#define PARITY3	0x00000000U
	#define PARITY4	0xe9528d85U


	/* PARAMETERS FOR ALTIVEC */
	#if defined(__APPLE__)	/* For OSX */
		#define ALTI_SL1	(vector unsigned int)(SL1, SL1, SL1, SL1)
		#define ALTI_SR1	(vector unsigned int)(SR1, SR1, SR1, SR1)
		#define ALTI_MSK	(vector unsigned int)(MSK1, MSK2, MSK3, MSK4)
		#define ALTI_MSK64 \
		(vector unsigned int)(MSK2, MSK1, MSK4, MSK3)
		#define ALTI_SL2_PERM \
		(vector unsigned char)(25,25,25,25,3,25,25,25,7,0,1,2,11,4,5,6)
		#define ALTI_SL2_PERM64 \
		(vector unsigned char)(7,25,25,25,25,25,25,25,15,0,1,2,3,4,5,6)
		#define ALTI_SR2_PERM \
		(vector unsigned char)(7,0,1,2,11,4,5,6,15,8,9,10,17,12,13,14)
		#define ALTI_SR2_PERM64 \
		(vector unsigned char)(15,0,1,2,3,4,5,6,17,8,9,10,11,12,13,14)
	#else	/* For OTHER OSs(Linux?) */
		#define ALTI_SL1	{SL1, SL1, SL1, SL1}
		#define ALTI_SR1	{SR1, SR1, SR1, SR1}
		#define ALTI_MSK	{MSK1, MSK2, MSK3, MSK4}
		#define ALTI_MSK64	{MSK2, MSK1, MSK4, MSK3}
		#define ALTI_SL2_PERM	{25,25,25,25,3,25,25,25,7,0,1,2,11,4,5,6}
		#define ALTI_SL2_PERM64	{7,25,25,25,25,25,25,25,15,0,1,2,3,4,5,6}
		#define ALTI_SR2_PERM	{7,0,1,2,11,4,5,6,15,8,9,10,17,12,13,14}
		#define ALTI_SR2_PERM64	{15,0,1,2,3,4,5,6,17,8,9,10,11,12,13,14}
	#endif	/* For OSX */
	#define IDSTR	"SFMT-86243:366-6-7-19-1:fdbffbff-bff7ff3f-fd77efff-bf9ff3ff"
#elif SFMT_MEXP == 132049
	#define POS1	110
	#define SL1	19
	#define SL2	1
	#define SR1	21
	#define SR2	1
	#define MSK1	0xffffbb5fU
	#define MSK2	0xfb6ebf95U
	#define MSK3	0xfffefffaU
	#define MSK4	0xcff77fffU
	#define PARITY1	0x00000001U
	#define PARITY2	0x00000000U
	#define PARITY3	0xcb520000U
	#define PARITY4	0xc7e91c7dU


	/* PARAMETERS FOR ALTIVEC */
	#if defined(__APPLE__)	/* For OSX */
		#define ALTI_SL1	(vector unsigned int)(SL1, SL1, SL1, SL1)
		#define ALTI_SR1	(vector unsigned int)(SR1, SR1, SR1, SR1)
		#define ALTI_MSK	(vector unsigned int)(MSK1, MSK2, MSK3, MSK4)
		#define ALTI_MSK64 \
		(vector unsigned int)(MSK2, MSK1, MSK4, MSK3)
		#define ALTI_SL2_PERM \
		(vector unsigned char)(1,2,3,23,5,6,7,0,9,10,11,4,13,14,15,8)
		#define ALTI_SL2_PERM64 \
		(vector unsigned char)(1,2,3,4,5,6,7,31,9,10,11,12,13,14,15,0)
		#define ALTI_SR2_PERM \
		(vector unsigned char)(7,0,1,2,11,4,5,6,15,8,9,10,17,12,13,14)
		#define ALTI_SR2_PERM64 \
		(vector unsigned char)(15,0,1,2,3,4,5,6,17,8,9,10,11,12,13,14)
	#else	/* For OTHER OSs(Linux?) */
		#define ALTI_SL1	{SL1, SL1, SL1, SL1}
		#define ALTI_SR1	{SR1, SR1, SR1, SR1}
		#define ALTI_MSK	{MSK1, MSK2, MSK3, MSK4}
		#define ALTI_MSK64	{MSK2, MSK1, MSK4, MSK3}
		#define ALTI_SL2_PERM	{1,2,3,23,5,6,7,0,9,10,11,4,13,14,15,8}
		#define ALTI_SL2_PERM64	{1,2,3,4,5,6,7,31,9,10,11,12,13,14,15,0}
		#define ALTI_SR2_PERM	{7,0,1,2,11,4,5,6,15,8,9,10,17,12,13,14}
		#define ALTI_SR2_PERM64	{15,0,1,2,3,4,5,6,17,8,9,10,11,12,13,14}
	#endif	/* For OSX */
	#define IDSTR	"SFMT-132049:110-19-1-21-1:ffffbb5f-fb6ebf95-fffefffa-cff77fff"
#elif SFMT_MEXP == 216091
	#define POS1	627
	#define SL1	11
	#define SL2	3
	#define SR1	10
	#define SR2	1
	#define MSK1	0xbff7bff7U
	#define MSK2	0xbfffffffU
	#define MSK3	0xbffffa7fU
	#define MSK4	0xffddfbfbU
	#define PARITY1	0xf8000001U
	#define PARITY2	0x89e80709U
	#define PARITY3	0x3bd2b64bU
	#define PARITY4	0x0c64b1e4U


	/* PARAMETERS FOR ALTIVEC */
	#if defined(__APPLE__)	/* For OSX */
		#define ALTI_SL1	(vector unsigned int)(SL1, SL1, SL1, SL1)
		#define ALTI_SR1	(vector unsigned int)(SR1, SR1, SR1, SR1)
		#define ALTI_MSK	(vector unsigned int)(MSK1, MSK2, MSK3, MSK4)
		#define ALTI_MSK64 \
		(vector unsigned int)(MSK2, MSK1, MSK4, MSK3)
		#define ALTI_SL2_PERM \
		(vector unsigned char)(3,21,21,21,7,0,1,2,11,4,5,6,15,8,9,10)
		#define ALTI_SL2_PERM64 \
		(vector unsigned char)(3,4,5,6,7,29,29,29,11,12,13,14,15,0,1,2)
		#define ALTI_SR2_PERM \
		(vector unsigned char)(7,0,1,2,11,4,5,6,15,8,9,10,17,12,13,14)
		#define ALTI_SR2_PERM64 \
		(vector unsigned char)(15,0,1,2,3,4,5,6,17,8,9,10,11,12,13,14)
	#else	/* For OTHER OSs(Linux?) */
		#define ALTI_SL1	{SL1, SL1, SL1, SL1}
		#define ALTI_SR1	{SR1, SR1, SR1, SR1}
		#define ALTI_MSK	{MSK1, MSK2, MSK3, MSK4}
		#define ALTI_MSK64	{MSK2, MSK1, MSK4, MSK3}
		#define ALTI_SL2_PERM	{3,21,21,21,7,0,1,2,11,4,5,6,15,8,9,10}
		#define ALTI_SL2_PERM64	{3,4,5,6,7,29,29,29,11,12,13,14,15,0,1,2}
		#define ALTI_SR2_PERM	{7,0,1,2,11,4,5,6,15,8,9,10,17,12,13,14}
		#define ALTI_SR2_PERM64	{15,0,1,2,3,4,5,6,17,8,9,10,11,12,13,14}
	#endif	/* For OSX */
	#define IDSTR	"SFMT-216091:627-11-3-10-1:bff7bff7-bfffffff-bffffa7f-ffddfbfb"
#else
  #undef SFMT_MEXP
#endif


////////////////////////////////////////////////////////////////////////////////

_SGC_BEGIN

class sfmt
{
public:
	sfmt(const uint32_t seed = 0);
	sfmt(const uint32_t *init_key, const int key_length);
	~sfmt();


	////////////////////////////////////////
	// ʂ̕ϐ֐̂悤Ɏgȗ\Li32bitj
	operator uint32_t(void) { return gen32(); }

	uint32_t operator()(void)                                                   { return gen32(); }
	uint32_t operator()(const uint32_t upper_bound)                             { return gen32(upper_bound); }
	uint32_t operator()(const uint32_t lower_bound, const uint32_t upper_bound) { return gen32(lower_bound, upper_bound); }


	////////////////////////////////////////
	// 32bit
	uint32_t gen32(void);
	uint32_t gen32(const uint32_t upper_bound);
	uint32_t gen32(const uint32_t lower_bound, const uint32_t upper_bound);


	////////////////////////////////////////
	// 64bit
	uint64_t gen64(void);
	uint64_t gen64(const uint64_t upper_bound);
	uint64_t gen64(const uint64_t lower_bound, const uint64_t upper_bound);


	////////////////////////////////////////
	// double
	double gen_double1(void) { return  gen32()        * (1.0/4294967295.0); } // [0,1]
	double gen_double2(void) { return  gen32()        * (1.0/4294967296.0); } // [0,1)
	double gen_double3(void) { return (gen32() + 0.5) * (1.0/4294967296.0); } // (0,1)


	////////////////////////////////////////
	// long double
	long double gen_ld(void) { return gen64() * (1.0/18446744073709551616.0L); }

private:
	void init_param(void);

private:
	// ȉASFMTIWi̊֐
	const char *get_idstring(void) { return IDSTR; }
	int get_min_array_size32(void) { return N32; }
	int get_min_array_size64(void) { return N64; }

	uint32_t gen_rand32(void);
	uint64_t gen_rand64(void);

	void fill_array32(uint32_t *array, int size);
	void fill_array64(uint64_t *array, int size);

	void init_gen_rand(const uint32_t seed);
	void init_by_array(const uint32_t *init_key, int key_length);

private:
	/** 128-bit data structure */
	struct W128_T {
		uint32_t u[4];
	};
	/** 128-bit data type */
	typedef struct W128_T w128_t;

private:
	/** the 128-bit internal state array */
	w128_t m_sfmt[N];
	/** the 32bit integer pointer to the 128-bit internal state array */
	uint32_t *m_psfmt32;

	/** the 64bit integer pointer to the 128-bit internal state array */
	uint64_t *m_psfmt64;

	/** index counter to the 32-bit internal state array */
	int m_idx;
	/** a flag: it is 0 if and only if the internal state is not yet
	 * m_initialized. */
	int m_initialized;
	/** a m_parity check vector which certificate the period of 2^{SFMT_MEXP} */
	uint32_t m_parity[4];

private:
	void rshift128(w128_t *out,  w128_t const *in, int shift);
	void lshift128(w128_t *out,  w128_t const *in, int shift);

	void do_recursion(w128_t *r, w128_t *a, w128_t *b, w128_t *c, w128_t *d);

	void gen_rand_all(void);
	void gen_rand_array(w128_t *array, int size);

	uint32_t func1(uint32_t x);
	uint32_t func2(uint32_t x);

	void period_certification(void);
};

_SGC_END

#endif // __SGC_SFMT__
