// COM.h cCommon Object Model
#ifndef __WGC_COM__
#define __WGC_COM__

#include "wgc.h"


_WGC_BEGIN                              // namespace wgc {

// IUnknown C^[tF[X̎Jistd::auto_ptr ݂Ȃj
// LCWP[^̑ɎQƃJEggă\[X̊ǗĂ
template<typename _Ty>
class COM_AutoInterface
{
public:
	COM_AutoInterface(_Ty *pInterface) : m_pInterface(pInterface)
	{
	}
	COM_AutoInterface(COM_AutoInterface<_Ty> &rhs)
	{
		assign(rhs);
	}
	~COM_AutoInterface(void)
	{
		m_pInterface->Release();
		m_pInterface = NULL;
	}

	COM_AutoInterface<_Ty> operator=(COM_AutoInterface<_Ty> &rhs)
	{
		assign(rhs);
	}

	_Ty &operator* (void) const { return *m_pInterface; }
	_Ty *operator->(void) const { return  m_pInterface; }

private:
	_Ty *m_pInterface;

	void assign(COM_AutoInterface<_Ty> &rhs)
	{
		m_pInterface = rhs.m_pInterface;
		m_pInterface->AddRef();
	}
};

_WGC_END                                // }

#endif // __WGC_COM__
