// SliderCtrl.cpp cCve[Vt@C
#include "SliderCtrl.h"


_WGC_BEGIN                              // namespace wgc {

// RXgN^
SliderCtrl::SliderCtrl(HWND hWnd /* = NULL */) : Control(hWnd)
{
}

// fXgN^
SliderCtrl::~SliderCtrl(void)
{
}


// s̃TCY
int SliderCtrl::GetLineSize(void) const
{
	const LRESULT lResult = SendMessage(TBM_GETLINESIZE);
	return static_cast<int>(lResult);
}

int SliderCtrl::SetLineSize(const int nSize)
{
	const LRESULT lResult = SendMessage(TBM_SETLINESIZE, 0, nSize);
	return static_cast<int>(lResult);
}


// y[WTCY
int SliderCtrl::GetPageSize(void) const
{
	const LRESULT lResult = SendMessage(TBM_GETPAGESIZE);
	return static_cast<int>(lResult);
}

int SliderCtrl::SetPageSize(const int nSize)
{
	const LRESULT lResult = SendMessage(TBM_SETPAGESIZE, 0, nSize);
	return static_cast<int>(lResult);
}


// ŏl
int SliderCtrl::GetRangeMin(void) const
{
	const LRESULT lResult = SendMessage(TBM_GETRANGEMIN);
	return static_cast<int>(lResult);
}

void SliderCtrl::SetRangeMin(const int nMin, const BOOL bRedraw /* = FALSE */)
{
	SendMessage(TBM_SETRANGEMIN, bRedraw, nMin);
}


// ől
int SliderCtrl::GetRangeMax(void) const
{
	const LRESULT lResult = SendMessage(TBM_GETRANGEMAX);
	return static_cast<int>(lResult);
}

void SliderCtrl::SetRangeMax(const int nMax, const BOOL bRedraw /* = FALSE */)
{
	SendMessage(TBM_SETRANGEMAX, bRedraw, nMax);
}


// ͈
void SliderCtrl::GetRange(int &rMin, int &rMax) const
{
	rMin = GetRangeMin();
	rMax = GetRangeMax();
}

void SliderCtrl::SetRange(const int nMin, const int nMax, const BOOL bRedraw /* = FALSE */)
{
	SendMessage(TBM_SETRANGE, (WPARAM)bRedraw, (LPARAM)MAKELONG(nMin, nMax));
}


// `
void SliderCtrl::GetChannelRect(LPRECT lprc) const
{
	SendMessage(TBM_GETCHANNELRECT, 0, (LPARAM)lprc);
}

void SliderCtrl::GetThumbRect(LPRECT lprc) const
{
	SendMessage(TBM_GETTHUMBRECT, 0, (LPARAM)lprc);
}


// ܂݂̈ʒu
int SliderCtrl::GetPos(void) const
{
	const LRESULT lResult = SendMessage(TBM_GETPOS, 0, 0);
	return static_cast<int>(lResult);
}

void SliderCtrl::SetPos(const int nPos)
{
	SendMessage(TBM_SETPOS, (WPARAM)TRUE, (LPARAM)nPos);
}


// ڐ}[N
UINT SliderCtrl::GetNumTics(void) const
{
	const LRESULT lResult = SendMessage(TBM_GETNUMTICS);
	return static_cast<UINT>(lResult);
}

int SliderCtrl::GetTic(const int nTic) const
{
	const LRESULT lResult = SendMessage(TBM_GETTIC, nTic);
	return static_cast<int>(lResult);
}

BOOL SliderCtrl::SetTic(const int nTic)
{
	const LRESULT lResult = SendMessage(TBM_SETTIC, 0, nTic);
	return static_cast<BOOL>(lResult);
}

int SliderCtrl::GetTicPos(const int nTic) const
{
	const LRESULT lResult = SendMessage(TBM_GETTICPOS, nTic);
	return static_cast<int>(lResult);
}

void SliderCtrl::SetTicFreq(const int nFreq)
{
	SendMessage(TBM_SETTICFREQ, nFreq);
}


// ofB
HWND SliderCtrl::GetBuddy(const BOOL fLocation /* = TRUE */) const
{
	LRESULT result = SendMessage(TBM_GETBUDDY, fLocation);
	return reinterpret_cast<HWND>(result);
}

HWND SliderCtrl::SetBuddy(HWND hWndBuddy, const BOOL fLocation /* = TRUE */)
{
	LRESULT result = SendMessage(TBM_SETBUDDY, fLocation, (LPARAM)hWndBuddy);
	return reinterpret_cast<HWND>(result);
}


// 
void SliderCtrl::ClearSel(const BOOL bRedraw /* = FALSE */)
{
	SendMessage(TBM_CLEARSEL, bRedraw);
}

void SliderCtrl::ClearTics(const BOOL bRedraw /* = FALSE */)
{
	SendMessage(TBM_CLEARTICS, bRedraw);
}

_WGC_END                                // }
