name 'test-on-localhost'
description 'Testing on local machine'

run_list(
  'role[mocker]',
  'role[node_commons]',
  'role[chef_utils]',
  'role[nameservice-client]',
  'role[ganglia-gmond-ucast-localhost]',
  'role[ganglia-gmetad-localhost]',
  'role[ganglia-web]',
  'role[nagios]',
  'role[hadoop-pseudo-distributed-with-security]',
  'role[zookeeper-pseudo-replicated-with-security]',
  'role[hbase-pseudo-distributed-with-security]',
  'role[pig]'
)

#env_run_lists "prod" => ["recipe[apache2]"], "staging" => ["recipe[apache2::staging]"], "_default" => []

default_attributes(
  'openldap' => {
    'client' => {
      'URI' => 'ldap://localhost/',
      'BASE' => 'dc=localdomain',
      'TLS_CACERT' => '/etc/ssl/certs/cacert.pem',
      'TLS_REQCERT' => 'allow',
      'TLS_CHECKPEER' => 'yes',
      'SASL_MECH' => 'GSSAPI'
    },
    'nss-ldapd' => {
      'uri' => 'ldap://localhost/',
      'base' => 'dc=localdomain',
      'ssl' => 'start_tls',
      'tls_cacertfile' => '/etc/ssl/certs/cacert.pem',
      'tls_reqcert' => 'demand'
    },
    #'ldap_lookup_nameservices' => ['passwd', 'group']
  },
  'krb5' => {
    'libdefaults' => {
      'default_realm' => 'LOCALDOMAIN',
      # strong crypto
      'default_tgs_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5',
      'default_tkt_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5',
      'permitted_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5'
      # or weak crypto for 1.0.x KSSL
      #'allow_weak_crypto' => 'true',
      #'default_tgs_enctypes' \
      #  => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5 des-cbc-crc des-cbc-md5',
      #'default_tkt_enctypes' \
      #  => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5 des-cbc-crc des-cbc-md5',
      #'permitted_enctypes' \
      #  => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5 des-cbc-crc des-cbc-md5'
    }
  },
  'ganglia' => {
    'trusted_hosts' => ['127.0.0.1'],
    'web' => {
      #'Allow' => ['from .grid.example.com'],
      'AuthType' => 'Kerberos',
      'mod_auth_kerb' => {
        'KrbAuthRealms' => 'LOCALDOMAIN',
        'Krb5Keytab' => '/etc/krb5.keytab'
      }
    }
  },
  'nagios' => {
    'web' => {
      #'Allow' => ['from .grid.example.com'],
      'AuthType' => 'Kerberos',
      'mod_auth_kerb' => {
        'KrbAuthRealms' => 'LOCALDOMAIN',
        'Krb5Keytab' => '/etc/krb5.keytab'
      }
    },
    'check_external_commands' => '1',
    'use_regexp_matching' => '1',
    'authorized_for_system_information' => '*',
    'authorized_for_configuration_information' => '*',
    'authorized_for_system_commands' => '*',
    'authorized_for_all_services' => '*',
    'authorized_for_all_hosts' => '*',
    'authorized_for_all_service_commands' => '*',
    'authorized_for_all_host_commands' => '*',
    'check_ganglia_metric' => {
      'enabled' => true,
      'gmetad_host' => 'localhost'
    },
    'objects' => {
      'hosts' => [
        {
          'use' => 'generic-host',
          'host_name' => 'localhost4gmon',
          'address' => 'localhost'  # not 127.0.0.1
        }
      ],
      'services' => [
        # ganglia gmetad monitoring
        {
          'use' => 'generic-check_ganglia_cache-service',
          'contact_groups' => 'admins',
          'host_name' => 'localhost'
        },
        {
          'use' => 'generic-ganglia_heartbeat-service',
          'contact_groups' => 'admins',
          'host_name' => 'localhost4gmon'
          #'hostgroup_name' => 'gmetads',
        },
        # standard monitoring.
        {
          'use' => 'generic-ping-service',
          'contact_groups' => 'admins',
          #'contact_groups' => 'grid-admins',
          'host_name' => 'localhost',
          #'hostgroup_name' => 'grid-servers',
        },
        # monitoring via Ganglia
        {
          'use' => 'generic-load_one-service',
          'contact_groups' => 'admins',
          'host_name' => 'localhost4gmon'
        },
      ],
      'servicedependencies' => [
        {
          'host_name' => 'localhost',
          'service_description' => 'Cache for check_ganglia_metric',
          'dependent_host_name' => 'localhost4gmon',
          #'dependent_host_name' => '.*',
          #'dependent_hostgroup_name' => 'grid-servers',
          'dependent_service_description' => '.* via Ganglia$',
          'execution_failure_criteria' => 'c,p'
        }
      ]
    }
  },
  'zookeeper' => {
    'version' => '3.4.5'
  },
  'hadoop' => {
    'version' => '2.0.5-alpha',
    #'version' => '2.0.4-alpha',
    #'version' => '1.1.2',
    #'version' => '1.0.4',
    'metrics2' => {
      'namenode.sink.ganglia.servers' => 'localhost:8649',
      'datanode.sink.ganglia.servers' => 'localhost:8649',
      # for 2.0.x only
      'resourcemanager.sink.ganglia.servers' => 'localhost:8649',
      'nodemanager.sink.ganglia.servers' => 'localhost:8649',
      # for 1.0.x only
      'jobtracker.sink.ganglia.servers' => 'localhost:8649',
      'tasktracker.sink.ganglia.servers' => 'localhost:8649',
      'maptask.sink.ganglia.servers' => 'localhost:8649',
      'reducetask.sink.ganglia.servers' => 'localhost:8649'
    },
    # for 2.0.x only >>
    'yarn.nodemanager.linux-container-executor.resources-handler.class' \
      => 'org.apache.hadoop.yarn.server.nodemanager.util.CgroupsLCEResourcesHandler',
    # for 1.0.x only >>
    'extra_configs' => {
      'core-site.xml' => {
        'hadoop.http.authentication.signature.secret' \
          => '91d365813d6dd1f4ceafff73f90a9a06'
      }
    },
    'krb5_strong_crypto' => {
      'default_tgs_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5',
      'default_tkt_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5',
      'permitted_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5'
    },
    'krb5_weak_crypto' => {
      'default_tgs_enctypes' \
        => 'des-cbc-crc des-cbc-md5',
      'default_tkt_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5 des-cbc-crc des-cbc-md5',
      'permitted_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5 des-cbc-crc des-cbc-md5'
    }
    # <<
  },
  'hbase' => {
    'version' => '0.94.7'
  },
  'pig' => {
    'version' => '0.11.1'
    #'version' => '0.11.0'
  }
)

override_attributes(
  'ganglia' => {
    'trusted_hosts' => ['127.0.0.1'],
=begin
    # for TEST
    'gmond_conf_type' => 'automatic',
    'automatic' => {
      #'cast_mode' => 'multi'
      'cast_mode' => 'uni'
    }
=end
  }
)

