# Copyright 2011 The Apache Software Foundation
# 
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Set Hadoop-specific environment variables here.


export JAVA_HOME=/usr/local/jvm/java-6-ora
# The directory where pid files are stored. /tmp by default.
export HADOOP_PID_DIR=/var/run/hadoop-hdfs
# Where log files are stored. $HADOOP_PREFIX/logs by default.
#export HADOOP_LOG_DIR=/grid/vol/0/var/log/${USER}
# for secure datanode. $USER ('root': Apache, HDP; '': CDH)
if [ x"$USER" = x'root' -o x"$USER" = x'' ]; then
    export HADOOP_LOG_DIR=/grid/vol/0/var/log/hdfs
else
    export HADOOP_LOG_DIR=/grid/vol/0/var/log/${USER}
fi

# Extra Java CLASSPATH elements.  Optional.
if [ x"$HADOOP_CLASSPATH" = x ]; then
    export HADOOP_CLASSPATH=""
    #export HADOOP_CLASSPATH=${HADOOP_CLASSPATH}:/grid/usr/commons-daemon-1.0.13/commons-daemon-1.0.13.jar
else
    # for Hive and HCatalog
    export HADOOP_CLASSPATH="${HADOOP_CLASSPATH}:"
    #export HADOOP_CLASSPATH=${HADOOP_CLASSPATH}:/grid/usr/commons-daemon-1.0.13/commons-daemon-1.0.13.jar
fi
export HADOOP_USER_CLASSPATH_FIRST=false
 

