# Set Hadoop-specific environment variables here.


#export JAVA_HOME=/usr/lib/jvm/java-6-sun
#export JAVA_HOME=/usr/lib/jvm/java-6-openjdk
#export JAVA_HOME=/usr/lib/jvm/java-6-openjdk-i386
#export JAVA_HOME=/usr/lib/jvm/java-6-openjdk-amd64
export JAVA_HOME=/usr/local/jvm/java-6-ora
#export JAVA_HOME=/usr/lib/jvm/java-7-openjdk-i386
#export JAVA_HOME=/usr/local/jvm/java-7-ora
# The directory where pid files are stored. /tmp by default.
export HADOOP_PID_DIR=/grid/vol/0/var/run/$USER
# Where log files are stored. $HADOOP_HOME/logs by default.
export HADOOP_LOG_DIR=/grid/vol/0/var/log/$USER 

export HADOOP_SECURE_DN_USER=hdfs
export HADOOP_SECURE_DN_PID_DIR=/grid/vol/0/var/run/${HADOOP_SECURE_DN_USER}
export HADOOP_SECURE_DN_LOG_DIR=/grid/vol/0/var/log/${HADOOP_SECURE_DN_USER} 
# Extra Java CLASSPATH elements.  Optional.
if [ x"$HADOOP_CLASSPATH" = x ]; then
        export HADOOP_CLASSPATH=/usr/share/java/commons-daemon.jar
else
        export HADOOP_CLASSPATH=${HADOOP_CLASSPATH}:/usr/share/java/commons-daemon.jar
fi
export HADOOP_USER_CLASSPATH_FIRST=true


# The only required environment variable is JAVA_HOME.  All others are
# optional.  When running a distributed configuration it is best to
# set JAVA_HOME in this file, so that it is correctly defined on
# remote nodes.

# The java implementation to use.  Required.
# export JAVA_HOME=/usr/lib/j2sdk1.5-sun

# Extra Java CLASSPATH elements.  Optional.
# export HADOOP_CLASSPATH=

# The maximum amount of heap to use, in MB. Default is 1000.
# export HADOOP_HEAPSIZE=2000

# Extra Java runtime options.  Empty by default.
# export HADOOP_OPTS=-server

# Command specific options appended to HADOOP_OPTS when specified
HDFS_OPTS="-Djava.security.krb5.conf=${HADOOP_PREFIX}/conf/krb5-hdfs.conf"
MAPRED_OPTS="-Djava.security.krb5.conf=${HADOOP_PREFIX}/conf/krb5-mapred.conf"
export HADOOP_NAMENODE_OPTS="-Dcom.sun.management.jmxremote $HDFS_OPTS $HADOOP_NAMENODE_OPTS"
export HADOOP_SECONDARYNAMENODE_OPTS="-Dcom.sun.management.jmxremote $HDFS_OPTS $HADOOP_SECONDARYNAMENODE_OPTS"
export HADOOP_DATANODE_OPTS="-Dcom.sun.management.jmxremote $HDFS_OPTS $HADOOP_DATANODE_OPTS"
export HADOOP_BALANCER_OPTS="-Dcom.sun.management.jmxremote $HDFS_OPTS $HADOOP_BALANCER_OPTS"
export HADOOP_JOBTRACKER_OPTS="-Dcom.sun.management.jmxremote $MAPRED_OPTS $HADOOP_JOBTRACKER_OPTS"
export HADOOP_TASKTRACKER_OPTS="-Dcom.sun.management.jmxremote $MAPRED_OPTS $HADOOP_TASKTRACKER_OPTS"
# for fsck command only
#export HADOOP_CLIENT_OPTS="$HDFS_OPTS $HADOOP_CLIENT_OPTS"
# for standard hadoop sub-commands
export HADOOP_CLIENT_OPTS="$MAPRED_OPTS $HADOOP_CLIENT_OPTS"
# export HADOOP_TASKTRACKER_OPTS=
# The following applies to multiple commands (fs, dfs, fsck, distcp etc)
# export HADOOP_CLIENT_OPTS

# Extra ssh options.  Empty by default.
# export HADOOP_SSH_OPTS="-o ConnectTimeout=1 -o SendEnv=HADOOP_CONF_DIR"

# Where log files are stored.  $HADOOP_HOME/logs by default.
# export HADOOP_LOG_DIR=${HADOOP_HOME}/logs

# File naming remote slave hosts.  $HADOOP_HOME/conf/slaves by default.
# export HADOOP_SLAVES=${HADOOP_HOME}/conf/slaves

# host:path where hadoop code should be rsync'd from.  Unset by default.
# export HADOOP_MASTER=master:/home/$USER/src/hadoop

# Seconds to sleep between slave commands.  Unset by default.  This
# can be useful in large clusters, where, e.g., slave rsyncs can
# otherwise arrive faster than the master can service them.
# export HADOOP_SLAVE_SLEEP=0.1

# The directory where pid files are stored. /tmp by default.
# export HADOOP_PID_DIR=/var/hadoop/pids

# A string representing this instance of hadoop. $USER by default.
# export HADOOP_IDENT_STRING=$USER

# The scheduling priority for daemon processes.  See 'man nice'.
# export HADOOP_NICENESS=10
