# for convenience 

PROJECT="$1"

if [ -z "$PROJECT" ]; then
  for i in `ls -d *.xcodeproj`; do
    PROJECT=`basename "$i" .xcodeproj`
    break
  done
  if [ -z "$PROJECT" ]; then
    exit 1
  fi
fi

osascript <<END
tell application "Xcode"
  open alias ("$PWD/$PROJECT.xcodeproj" as POSIX file)
  tell project "$PROJECT" to set theResult to build
  activate
  if not theResult contains "failed" then launch
end tell
END
