#!/bin/sh
#
# wineprefixcreate.sh - update a wineprefix
#
# Copyright (C) 2008 MikuInstaller Project. All rights reserved.
# http://mikuinstaller.sourceforge.jp/
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
# THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
# BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
# IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

MIKUVERSION=@VERSION@

set -e
PATH=/usr/bin:/bin:/usr/sbin

if [ -z "$MIKUBUNDLE" ]; then
  dir=`dirname "$0"`
  MIKUBUNDLE=`cd "$dir/../../.." && pwd`
fi
MIKURESOURCE="$MIKUBUNDLE/Contents/Resources"

if [ -n "$WINEPREFIX" ]; then
  timestamp="$WINEPREFIX/.miku-timestamp"
else
  timestamp="$HOME/.wine/.miku-timestamp"
fi
updated=no

for i in "$MIKURESOURCE/inf/"*.inf; do
  if [ "$i" -nt "$timestamp" ]; then
    updated=yes
    # InstallHinfSection requires UNQUOTED filename but wine does quote
    # a command line argument if it includes spaces.
    # To prevent the quotation, make a temporary file, whose path doesn't
    # include any spaces, copy inf file to the file, and then run
    # InstallHinfSection.
    tmp=`mktemp -t tmp`
    cp "$i" "$tmp"
    (
      trap "rm $tmp" EXIT
      set -- wine rundll32 setupapi,InstallHinfSection \
             DefaultInstall 128 '\\?\unix'"$tmp"
      . "$MIKURESOURCE/script/startwine.sh"
    ) || exit $?
  fi
done

if [ "x$updated" = "xyes" ]; then
  date '+%s' > "$timestamp" || :
fi

# wait until wineserver is terminated.
(. "$MIKURESOURCE/script/startwine.sh" wineserver -w) || :
