/*
 * Copyright 2008 CodeWeavers, Aric Stewart
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef TSMHandle
typedef void *TSMHandle;
#endif

/* mactext functions */

int MacNewTSMDocument(TSMHandle handle, long refcon);
int MacTSMEventCFS(TSMHandle handle, char theChar, unsigned long
			theCode, unsigned long modifiers, unsigned long unichar);
TSMHandle MacInitTSMAwareApplication(void);
void MacCloseTSMAwareApplication(TSMHandle handle);
int MacTSMFixTextService(TSMHandle handle);
int MacActivateTSMDocument(TSMHandle handle);
int MacTSMRevertToPreviousMode(TSMHandle handle);
int MacTSMCheckModeAndIME(TSMHandle handle);
void MacRemoveAppEventHandler(TSMHandle handle);
void MacInstallAppEventHandler(TSMHandle handle);

/* toAscii */
int MacToAscii(UINT uVKey, UINT keysym, UINT keycode, CONST LPBYTE lpbKeyState,
    LPDWORD lpdwTransKey);

/* IME support */
extern void IME_RegisterClasses(HINSTANCE hImeInst);
extern void IME_UnregisterClasses(HINSTANCE hImeInst);
extern void IME_SetOpenStatus(BOOL fOpen);
extern LRESULT IME_SendMessageToSelectedHWND(UINT msg, WPARAM wParam, LPARAM lParam);
extern INT IME_GetCursorPos();
extern void IME_UpdateAssociation(HWND focus);
extern void IME_SetCompositionString(LPCVOID lpComp, DWORD dwCompLen);
extern BOOL IME_NotifyIME();

/* MAC */
void MAC_SetupXIM();
