#ifdef __APPLE__

#include <Carbon/Carbon.h>


typedef struct CXIMKClient* CXIMKClientRef;


typedef void (*CXIMKClientUpdatedEdit)(CXIMKClientRef inClient, CFStringRef inString,
        long inReplacementRangeLocation, long inReplacementRangeLength,
        void *data);

typedef void (*CXIMKClientCompletedText)(CXIMKClientRef inClient, CFStringRef inString,
        long inReplacementRangeLocation, long inReplacementRangeLength,
        void* data);

typedef void (*CXIMKClientModeChanged)(CXIMKClientRef inClient, CFStringRef mode, void* data);


CXIMKClientRef CXIMKClientInitialize(
        CFStringRef inServerName,
        CXIMKClientUpdatedEdit inUpdateEditCallback,
        CXIMKClientCompletedText inCompletedTextCallback,
        CXIMKClientModeChanged inModeChanged,
        void* data);

void CXIMKClientCleanup(CXIMKClientRef inClient);

int CXIMKClientActivate(CXIMKClientRef inClient);

void CXIMKClientDeactivate(CXIMKClientRef inClient);

void CXIMKClientSetInputMode(CXIMKClientRef inClient, CFStringRef inMode);

int CXIMKClientSendEvent(CXIMKClientRef inClient, EventRef inEvent);

void CXIMKClientForceComplete(CXIMKClientRef inClient);

#endif /* __APPLE__ */
