/*
 * initialization code
 *
 * Copyright 2008 CodeWeavers, Aric Stewart
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <stdarg.h>
#include <stdlib.h>
#include "windef.h"
#include "winbase.h"
#include "osxime_private.h"

#include "wine/debug.h"
WINE_DEFAULT_DEBUG_CHANNEL(mac_ime);

#ifdef __APPLE__
TSMHandle gHandle = NULL;

void RemoveAEHandler(void)
{
  MacRemoveAppEventHandler(gHandle);
  MacCloseTSMAwareApplication(gHandle);

  TRACE("MacIM:End.\n");
}
#endif

BOOL WINAPI DllMain( HINSTANCE hinst, DWORD reason, LPVOID reserved )
{
#ifdef __APPLE__
    BOOL ret = TRUE;

    switch(reason)
    {
    case DLL_PROCESS_ATTACH:
        DisableThreadLibraryCalls(hinst);
        IME_RegisterClasses(hinst);

        if (!gHandle)
        {
            gHandle = MacInitTSMAwareApplication();
            if (gHandle)
            {
                MacInstallAppEventHandler(gHandle);
                MacNewTSMDocument(gHandle,(long)0xfeedface);
                atexit(RemoveAEHandler);
            }
        }
        break;
    case DLL_PROCESS_DETACH:
        IME_UnregisterClasses(hinst);
        break;
    }
    return ret;
#else
    return FALSE;
#endif
}
