/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.Sys;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.ALCcontext;
import org.lwjgl.openal.ALCdevice;
import org.lwjgl.openal.OpenALException;

public class ALC {
    protected static boolean created;
    public static final int ALC_INVALID = -1;
    public static final int ALC_FALSE = 0;
    public static final int ALC_TRUE = 1;
    public static final int ALC_NO_ERROR = 0;
    public static final int ALC_MAJOR_VERSION = 4096;
    public static final int ALC_MINOR_VERSION = 4097;
    public static final int ALC_ATTRIBUTES_SIZE = 4098;
    public static final int ALC_ALL_ATTRIBUTES = 4099;
    public static final int ALC_DEFAULT_DEVICE_SPECIFIER = 4100;
    public static final int ALC_DEVICE_SPECIFIER = 4101;
    public static final int ALC_EXTENSIONS = 4102;
    public static final int ALC_FREQUENCY = 4103;
    public static final int ALC_REFRESH = 4104;
    public static final int ALC_SYNC = 4105;
    public static final int ALC_INVALID_DEVICE = 40961;
    public static final int ALC_INVALID_CONTEXT = 40962;
    public static final int ALC_INVALID_ENUM = 40963;
    public static final int ALC_INVALID_VALUE = 40964;
    public static final int ALC_OUT_OF_MEMORY = 40965;

    protected ALC() {
    }

    protected static void init() {
    }

    private static void initialize() {
        System.loadLibrary(Sys.getLibraryName());
    }

    protected static void create() throws OpenALException {
        if (created) {
            return;
        }
        if (!ALC.nCreate()) {
            throw new OpenALException("ALC instance could not be created.");
        }
        ALC.init();
        created = true;
    }

    protected static native boolean nCreate();

    protected static void destroy() {
        if (!created) {
            return;
        }
        created = false;
        ALC.nDestroy();
    }

    protected static native void nDestroy();

    public static String alcGetString(int n) {
        return ALC.nalcGetString(AL.device.device, n);
    }

    static native String nalcGetString(int var0, int var1);

    public static void alcGetInteger(int n, IntBuffer intBuffer) {
        ALC.nalcGetIntegerv(AL.device.device, n, intBuffer.remaining(), intBuffer, intBuffer.position());
    }

    static native void nalcGetIntegerv(int var0, int var1, int var2, Buffer var3, int var4);

    static native ALCdevice alcOpenDevice(String var0);

    static native void alcCloseDevice(int var0);

    static native ALCcontext alcCreateContext(int var0, IntBuffer var1);

    static native boolean alcMakeContextCurrent(int var0);

    public static void alcProcessContext() {
        ALC.nalcProcessContext(AL.context.context);
    }

    static native void nalcProcessContext(int var0);

    static native ALCcontext alcGetCurrentContext();

    static native ALCdevice alcGetContextsDevice(int var0);

    static native void alcSuspendContext(int var0);

    static native void alcDestroyContext(int var0);

    public static int alcGetError() {
        return ALC.nalcGetError(AL.device.device);
    }

    static native int nalcGetError(int var0);

    public static boolean alcIsExtensionPresent(String string) {
        return ALC.nalcIsExtensionPresent(AL.device.device, string);
    }

    static native boolean nalcIsExtensionPresent(int var0, String var1);

    public static int alcGetEnumValue(String string) {
        return ALC.nalcGetEnumValue(AL.device.device, string);
    }

    static native int nalcGetEnumValue(int var0, String var1);

    static {
        ALC.initialize();
    }
}

