/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vector;

import java.io.Serializable;
import java.nio.FloatBuffer;
import org.lwjgl.vector.Matrix;
import org.lwjgl.vector.Vector2f;

public class Matrix2f
extends Matrix
implements Serializable {
    public float m00 = 1.0f;
    public float m01;
    public float m10;
    public float m11 = 1.0f;

    public Matrix2f() {
    }

    public Matrix2f(Matrix2f matrix2f) {
        this.load(matrix2f);
    }

    public Matrix2f load(Matrix2f matrix2f) {
        this.m00 = matrix2f.m00;
        this.m01 = matrix2f.m01;
        this.m10 = matrix2f.m10;
        this.m11 = matrix2f.m11;
        return this;
    }

    public Matrix load(FloatBuffer floatBuffer) {
        this.m00 = floatBuffer.get();
        this.m01 = floatBuffer.get();
        this.m10 = floatBuffer.get();
        this.m11 = floatBuffer.get();
        return this;
    }

    public Matrix loadTranspose(FloatBuffer floatBuffer) {
        this.m00 = floatBuffer.get();
        this.m10 = floatBuffer.get();
        this.m01 = floatBuffer.get();
        this.m11 = floatBuffer.get();
        return this;
    }

    public Matrix store(FloatBuffer floatBuffer) {
        floatBuffer.put(this.m00);
        floatBuffer.put(this.m01);
        floatBuffer.put(this.m10);
        floatBuffer.put(this.m11);
        return this;
    }

    public Matrix storeTranspose(FloatBuffer floatBuffer) {
        floatBuffer.put(this.m00);
        floatBuffer.put(this.m10);
        floatBuffer.put(this.m01);
        floatBuffer.put(this.m11);
        return this;
    }

    public static Matrix2f add(Matrix2f matrix2f, Matrix2f matrix2f2, Matrix2f matrix2f3) {
        Matrix2f matrix2f4 = null;
        if (matrix2f3 == null) {
            matrix2f3 = new Matrix2f();
        } else if (matrix2f3 == matrix2f || matrix2f3 == matrix2f2) {
            matrix2f4 = matrix2f3;
            matrix2f3 = new Matrix2f();
        }
        matrix2f3.m00 = matrix2f.m00 + matrix2f2.m00;
        matrix2f3.m01 = matrix2f.m01 + matrix2f2.m01;
        matrix2f3.m10 = matrix2f.m10 + matrix2f2.m10;
        matrix2f3.m11 = matrix2f.m11 + matrix2f2.m11;
        if (matrix2f4 != null) {
            matrix2f4.load(matrix2f3);
            return matrix2f4;
        }
        return matrix2f3;
    }

    public static Matrix2f sub(Matrix2f matrix2f, Matrix2f matrix2f2, Matrix2f matrix2f3) {
        Matrix2f matrix2f4 = null;
        if (matrix2f3 == null) {
            matrix2f3 = new Matrix2f();
        } else if (matrix2f3 == matrix2f || matrix2f3 == matrix2f2) {
            matrix2f4 = matrix2f3;
            matrix2f3 = new Matrix2f();
        }
        matrix2f3.m00 = matrix2f.m00 - matrix2f2.m00;
        matrix2f3.m01 = matrix2f.m01 - matrix2f2.m01;
        matrix2f3.m10 = matrix2f.m10 - matrix2f2.m10;
        matrix2f3.m11 = matrix2f.m11 - matrix2f2.m11;
        if (matrix2f4 != null) {
            matrix2f4.load(matrix2f3);
            return matrix2f4;
        }
        return matrix2f3;
    }

    public static Matrix2f mul(Matrix2f matrix2f, Matrix2f matrix2f2, Matrix2f matrix2f3) {
        Matrix2f matrix2f4 = null;
        if (matrix2f3 == null) {
            matrix2f3 = new Matrix2f();
        } else if (matrix2f3 == matrix2f || matrix2f3 == matrix2f2) {
            matrix2f4 = matrix2f3;
            matrix2f3 = new Matrix2f();
        }
        matrix2f3.m00 = matrix2f.m00 * matrix2f2.m00 + matrix2f.m10 * matrix2f2.m01;
        matrix2f3.m01 = matrix2f.m01 * matrix2f2.m00 + matrix2f.m11 * matrix2f2.m01;
        matrix2f3.m10 = matrix2f.m00 * matrix2f2.m10 + matrix2f.m10 * matrix2f2.m11;
        matrix2f3.m11 = matrix2f.m01 * matrix2f2.m10 + matrix2f.m11 * matrix2f2.m11;
        if (matrix2f4 != null) {
            matrix2f4.load(matrix2f3);
            return matrix2f4;
        }
        return matrix2f3;
    }

    public static Vector2f transform(Matrix2f matrix2f, Vector2f vector2f, Vector2f vector2f2) {
        Vector2f vector2f3 = null;
        if (vector2f2 == null) {
            vector2f2 = new Vector2f();
        } else if (vector2f2 == vector2f) {
            vector2f3 = vector2f2;
            vector2f2 = new Vector2f();
        }
        vector2f2.x = matrix2f.m00 * vector2f.x + matrix2f.m10 * vector2f.y;
        vector2f2.y = matrix2f.m01 * vector2f.x + matrix2f.m11 * vector2f.y;
        if (vector2f3 != null) {
            vector2f3.set(vector2f2);
            return vector2f3;
        }
        return vector2f2;
    }

    public Matrix transpose() {
        float f = this.m01;
        this.m01 = this.m10;
        this.m10 = f;
        return this;
    }

    public Matrix2f transpose(Matrix2f matrix2f) {
        if (matrix2f == null) {
            matrix2f = new Matrix2f();
        }
        if (matrix2f == this) {
            this.transpose();
        } else {
            matrix2f.m01 = this.m10;
            matrix2f.m10 = this.m01;
        }
        return matrix2f;
    }

    public Matrix invert() {
        float f = this.determinant();
        if (f != 0.0f) {
            float f2 = 1.0f / f;
            float f3 = this.m11 * f2;
            float f4 = -this.m01 * f2;
            float f5 = this.m00 * f2;
            float f6 = -this.m10 * f2;
            this.m00 = f3;
            this.m01 = f4;
            this.m10 = f6;
            this.m11 = f5;
            return this;
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m00).append(' ').append(this.m10).append(' ').append('\n');
        stringBuffer.append(this.m01).append(' ').append(this.m11).append(' ').append('\n');
        return stringBuffer.toString();
    }

    public Matrix negate() {
        this.m00 = -this.m00;
        this.m01 = -this.m01;
        this.m10 = -this.m10;
        this.m11 = -this.m11;
        return this;
    }

    public Matrix2f negate(Matrix2f matrix2f) {
        if (matrix2f == null) {
            matrix2f = new Matrix2f();
        }
        matrix2f.m00 = -this.m00;
        matrix2f.m01 = -this.m01;
        matrix2f.m10 = -this.m10;
        matrix2f.m11 = -this.m11;
        return matrix2f;
    }

    public Matrix setIdentity() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        return this;
    }

    public Matrix setZero() {
        this.m00 = 0.0f;
        this.m01 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 0.0f;
        return this;
    }

    public float determinant() {
        return this.m00 * this.m11 - this.m01 * this.m10;
    }
}

