/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vector;

import java.io.Serializable;
import java.nio.FloatBuffer;
import org.lwjgl.vector.Matrix;
import org.lwjgl.vector.Vector3f;

public class Matrix3f
extends Matrix
implements Serializable {
    public float m00 = 1.0f;
    public float m01;
    public float m02;
    public float m10;
    public float m11 = 1.0f;
    public float m12;
    public float m20;
    public float m21;
    public float m22 = 1.0f;

    public Matrix3f load(Matrix3f matrix3f) {
        this.m00 = matrix3f.m00;
        this.m10 = matrix3f.m10;
        this.m20 = matrix3f.m20;
        this.m01 = matrix3f.m01;
        this.m11 = matrix3f.m11;
        this.m21 = matrix3f.m21;
        this.m02 = matrix3f.m02;
        this.m12 = matrix3f.m12;
        this.m22 = matrix3f.m22;
        return this;
    }

    public Matrix load(FloatBuffer floatBuffer) {
        this.m00 = floatBuffer.get();
        this.m01 = floatBuffer.get();
        this.m02 = floatBuffer.get();
        this.m10 = floatBuffer.get();
        this.m11 = floatBuffer.get();
        this.m12 = floatBuffer.get();
        this.m20 = floatBuffer.get();
        this.m21 = floatBuffer.get();
        this.m22 = floatBuffer.get();
        return this;
    }

    public Matrix loadTranspose(FloatBuffer floatBuffer) {
        this.m00 = floatBuffer.get();
        this.m10 = floatBuffer.get();
        this.m20 = floatBuffer.get();
        this.m01 = floatBuffer.get();
        this.m11 = floatBuffer.get();
        this.m21 = floatBuffer.get();
        this.m02 = floatBuffer.get();
        this.m12 = floatBuffer.get();
        this.m22 = floatBuffer.get();
        return this;
    }

    public Matrix store(FloatBuffer floatBuffer) {
        floatBuffer.put(this.m00);
        floatBuffer.put(this.m01);
        floatBuffer.put(this.m02);
        floatBuffer.put(this.m10);
        floatBuffer.put(this.m11);
        floatBuffer.put(this.m12);
        floatBuffer.put(this.m20);
        floatBuffer.put(this.m21);
        floatBuffer.put(this.m22);
        return this;
    }

    public Matrix storeTranspose(FloatBuffer floatBuffer) {
        floatBuffer.put(this.m00);
        floatBuffer.put(this.m10);
        floatBuffer.put(this.m20);
        floatBuffer.put(this.m01);
        floatBuffer.put(this.m11);
        floatBuffer.put(this.m21);
        floatBuffer.put(this.m02);
        floatBuffer.put(this.m12);
        floatBuffer.put(this.m22);
        return this;
    }

    public static Matrix3f add(Matrix3f matrix3f, Matrix3f matrix3f2, Matrix3f matrix3f3) {
        Matrix3f matrix3f4 = null;
        if (matrix3f3 == null) {
            matrix3f3 = new Matrix3f();
        } else if (matrix3f3 == matrix3f || matrix3f3 == matrix3f2) {
            matrix3f4 = matrix3f3;
            matrix3f3 = new Matrix3f();
        }
        matrix3f3.m00 = matrix3f.m00 + matrix3f2.m00;
        matrix3f3.m01 = matrix3f.m01 + matrix3f2.m01;
        matrix3f3.m02 = matrix3f.m02 + matrix3f2.m02;
        matrix3f3.m10 = matrix3f.m10 + matrix3f2.m10;
        matrix3f3.m11 = matrix3f.m11 + matrix3f2.m11;
        matrix3f3.m12 = matrix3f.m12 + matrix3f2.m12;
        matrix3f3.m20 = matrix3f.m20 + matrix3f2.m20;
        matrix3f3.m21 = matrix3f.m21 + matrix3f2.m21;
        matrix3f3.m22 = matrix3f.m22 + matrix3f2.m22;
        if (matrix3f4 != null) {
            matrix3f4.load(matrix3f3);
            return matrix3f4;
        }
        return matrix3f3;
    }

    public static Matrix3f sub(Matrix3f matrix3f, Matrix3f matrix3f2, Matrix3f matrix3f3) {
        Matrix3f matrix3f4 = null;
        if (matrix3f3 == null) {
            matrix3f3 = new Matrix3f();
        } else if (matrix3f3 == matrix3f || matrix3f3 == matrix3f2) {
            matrix3f4 = matrix3f3;
            matrix3f3 = new Matrix3f();
        }
        matrix3f3.m00 = matrix3f.m00 - matrix3f2.m00;
        matrix3f3.m01 = matrix3f.m01 - matrix3f2.m01;
        matrix3f3.m02 = matrix3f.m02 - matrix3f2.m02;
        matrix3f3.m10 = matrix3f.m10 - matrix3f2.m10;
        matrix3f3.m11 = matrix3f.m11 - matrix3f2.m11;
        matrix3f3.m12 = matrix3f.m12 - matrix3f2.m12;
        matrix3f3.m20 = matrix3f.m20 - matrix3f2.m20;
        matrix3f3.m21 = matrix3f.m21 - matrix3f2.m21;
        matrix3f3.m22 = matrix3f.m22 - matrix3f2.m22;
        if (matrix3f4 != null) {
            matrix3f4.load(matrix3f3);
            return matrix3f4;
        }
        return matrix3f3;
    }

    public static Matrix3f mul(Matrix3f matrix3f, Matrix3f matrix3f2, Matrix3f matrix3f3) {
        Matrix3f matrix3f4 = null;
        if (matrix3f3 == null) {
            matrix3f3 = new Matrix3f();
        } else if (matrix3f3 == matrix3f || matrix3f3 == matrix3f2) {
            matrix3f4 = matrix3f3;
            matrix3f3 = new Matrix3f();
        }
        matrix3f3.m00 = matrix3f.m00 * matrix3f2.m00 + matrix3f.m10 * matrix3f2.m01 + matrix3f.m20 * matrix3f2.m02;
        matrix3f3.m01 = matrix3f.m01 * matrix3f2.m00 + matrix3f.m11 * matrix3f2.m01 + matrix3f.m21 * matrix3f2.m02;
        matrix3f3.m02 = matrix3f.m02 * matrix3f2.m00 + matrix3f.m12 * matrix3f2.m01 + matrix3f.m22 * matrix3f2.m02;
        matrix3f3.m10 = matrix3f.m00 * matrix3f2.m10 + matrix3f.m10 * matrix3f2.m11 + matrix3f.m20 * matrix3f2.m12;
        matrix3f3.m11 = matrix3f.m01 * matrix3f2.m10 + matrix3f.m11 * matrix3f2.m11 + matrix3f.m21 * matrix3f2.m12;
        matrix3f3.m12 = matrix3f.m02 * matrix3f2.m10 + matrix3f.m12 * matrix3f2.m11 + matrix3f.m22 * matrix3f2.m12;
        matrix3f3.m20 = matrix3f.m00 * matrix3f2.m20 + matrix3f.m10 * matrix3f2.m21 + matrix3f.m20 * matrix3f2.m22;
        matrix3f3.m21 = matrix3f.m01 * matrix3f2.m20 + matrix3f.m11 * matrix3f2.m21 + matrix3f.m21 * matrix3f2.m22;
        matrix3f3.m22 = matrix3f.m02 * matrix3f2.m20 + matrix3f.m12 * matrix3f2.m21 + matrix3f.m22 * matrix3f2.m22;
        if (matrix3f4 != null) {
            matrix3f4.load(matrix3f3);
            return matrix3f4;
        }
        return matrix3f3;
    }

    public static Vector3f transform(Matrix3f matrix3f, Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = null;
        if (vector3f2 == null) {
            vector3f2 = new Vector3f();
        } else if (vector3f2 == vector3f) {
            vector3f3 = vector3f2;
            vector3f2 = new Vector3f();
        }
        vector3f2.x = matrix3f.m00 * vector3f.x + matrix3f.m10 * vector3f.y + matrix3f.m20 * vector3f.z;
        vector3f2.y = matrix3f.m01 * vector3f.x + matrix3f.m11 * vector3f.y + matrix3f.m21 * vector3f.z;
        vector3f2.z = matrix3f.m02 * vector3f.x + matrix3f.m12 * vector3f.y + matrix3f.m22 * vector3f.z;
        if (vector3f3 != null) {
            vector3f3.set(vector3f2);
            return vector3f3;
        }
        return vector3f2;
    }

    public Matrix transpose() {
        float f = this.m10;
        this.m10 = this.m01;
        this.m01 = f;
        f = this.m20;
        this.m20 = this.m02;
        this.m02 = f;
        f = this.m21;
        this.m21 = this.m12;
        this.m12 = f;
        return this;
    }

    public Matrix3f transpose(Matrix3f matrix3f) {
        if (matrix3f == null) {
            matrix3f = new Matrix3f();
        }
        if (this == matrix3f) {
            this.transpose();
        } else {
            matrix3f.m00 = this.m00;
            matrix3f.m01 = this.m10;
            matrix3f.m02 = this.m20;
            matrix3f.m10 = this.m01;
            matrix3f.m11 = this.m11;
            matrix3f.m12 = this.m21;
            matrix3f.m20 = this.m02;
            matrix3f.m21 = this.m12;
            matrix3f.m22 = this.m22;
        }
        return matrix3f;
    }

    public float determinant() {
        float f = this.m00 * (this.m11 * this.m22 - this.m12 * this.m21) + this.m01 * (this.m12 * this.m20 - this.m10 * this.m22) + this.m02 * (this.m10 * this.m21 - this.m11 * this.m20);
        return f;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m00).append(' ').append(this.m10).append(' ').append(this.m20).append(' ').append('\n');
        stringBuffer.append(this.m01).append(' ').append(this.m11).append(' ').append(this.m21).append(' ').append('\n');
        stringBuffer.append(this.m02).append(' ').append(this.m12).append(' ').append(this.m22).append(' ').append('\n');
        return stringBuffer.toString();
    }

    public Matrix invert() {
        float f = this.determinant();
        if (f != 0.0f) {
            float f2 = 1.0f / f;
            float f3 = this.m11 * this.m22 - this.m12 * this.m21;
            float f4 = -this.m10 * this.m22 + this.m12 * this.m20;
            float f5 = this.m10 * this.m21 - this.m11 * this.m20;
            float f6 = -this.m01 * this.m22 + this.m02 * this.m21;
            float f7 = this.m00 * this.m22 - this.m02 * this.m20;
            float f8 = -this.m00 * this.m21 + this.m01 * this.m20;
            float f9 = this.m01 * this.m12 - this.m02 * this.m11;
            float f10 = -this.m00 * this.m12 + this.m02 * this.m10;
            float f11 = this.m00 * this.m11 - this.m01 * this.m10;
            this.m00 = f3 * f2;
            this.m11 = f7 * f2;
            this.m22 = f11 * f2;
            this.m01 = f6 * f2;
            this.m10 = f4 * f2;
            this.m20 = f5 * f2;
            this.m02 = f9 * f2;
            this.m12 = f10 * f2;
            this.m21 = f8 * f2;
            return this;
        }
        return null;
    }

    public Matrix negate() {
        this.m00 = -this.m00;
        this.m01 = -this.m02;
        this.m02 = -this.m01;
        this.m10 = -this.m10;
        this.m11 = -this.m12;
        this.m12 = -this.m11;
        this.m20 = -this.m20;
        this.m21 = -this.m22;
        this.m22 = -this.m21;
        return this;
    }

    public Matrix3f negate(Matrix3f matrix3f) {
        if (matrix3f == null) {
            matrix3f = new Matrix3f();
        }
        matrix3f.m00 = -this.m00;
        matrix3f.m01 = -this.m02;
        matrix3f.m02 = -this.m01;
        matrix3f.m10 = -this.m10;
        matrix3f.m11 = -this.m12;
        matrix3f.m12 = -this.m11;
        matrix3f.m20 = -this.m20;
        matrix3f.m21 = -this.m22;
        matrix3f.m22 = -this.m21;
        return matrix3f;
    }

    public Matrix setIdentity() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        return this;
    }

    public Matrix setZero() {
        this.m00 = 0.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 0.0f;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 0.0f;
        return this;
    }
}

