/*
 * Decompiled with CFR 0.152.
 */
package jme.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import jme.entity.EntityInterface;
import jme.entity.camera.Frustum;
import jme.exception.MonkeyGLException;
import jme.exception.MonkeyRuntimeException;
import jme.geometry.Geometry;
import jme.geometry.bounding.BoundingVolume;
import jme.math.Vector;
import jme.physics.PhysicsModule;
import jme.utility.LoggingSystem;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.Window;

public class Entity
implements EntityInterface {
    public static final int VISIBILITY_POINT = 0;
    public static final int VISIBILITY_SPHERE = 1;
    public static final int VISIBILITY_CUBE = 2;
    private int id = 0;
    protected List children = null;
    protected Geometry geometry = null;
    protected BoundingVolume boundingVolume = null;
    private Vector position = null;
    private float yaw;
    private float roll;
    private float pitch;
    private boolean hasMoved;
    private boolean isVisible = true;
    private int visibilityType;
    private PhysicsModule physics;

    public Entity(int n) {
        if (n < 1) {
            throw new MonkeyRuntimeException("Entity id must be greater than 0");
        }
        this.children = new ArrayList();
        this.position = new Vector();
        if (!Window.isCreated()) {
            throw new MonkeyGLException("Window must be created before Entity.");
        }
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Created a new entity");
    }

    public Entity(int n, Entity entity) {
        if (n < 1) {
            throw new MonkeyRuntimeException("Entity id must be greater than 0");
        }
        this.children = new ArrayList();
        this.position = new Vector();
        this.children.add(entity);
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Created a new entity");
    }

    public void addChild(Entity entity) {
        this.children.add(entity);
    }

    public void removeChild(Entity entity) {
        this.children.remove(entity);
    }

    public void setBoundingVolume(BoundingVolume boundingVolume) {
        this.boundingVolume = boundingVolume;
    }

    public BoundingVolume getBoundingVolume() {
        return this.boundingVolume;
    }

    public boolean hasCollision(Entity entity) {
        if (null != this.boundingVolume) {
            return this.boundingVolume.hasCollision(entity.getBoundingVolume());
        }
        return false;
    }

    public float distance(Entity entity) {
        if (null != this.boundingVolume) {
            return this.boundingVolume.distance(entity.getBoundingVolume());
        }
        return -1.0f;
    }

    public void setPosition(Vector vector) {
        this.position = vector;
    }

    public void setYaw(float f) {
        this.yaw = f;
    }

    public void setRoll(float f) {
        this.roll = f;
    }

    public void setPitch(float f) {
        this.pitch = f;
    }

    public void setMoved(boolean bl) {
        this.hasMoved = bl;
    }

    public void setPhysicsModule(PhysicsModule physicsModule) {
        this.physics = physicsModule;
    }

    public boolean hasMoved() {
        return this.hasMoved;
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    public Vector getPosition() {
        return this.position;
    }

    public PhysicsModule getPhysics() {
        return this.physics;
    }

    public int getId() {
        return this.id;
    }

    public void update(float f) {
        if (null != this.physics) {
            this.physics.update(f);
            this.physics.updatePosition(this.position);
        }
    }

    public void render() {
        GL.glPushMatrix();
        GL.glEnable((int)2929);
        GL.glTranslatef((float)this.position.x, (float)this.position.y, (float)this.position.z);
        GL.glRotatef((float)this.roll, (float)0.0f, (float)0.0f, (float)1.0f);
        GL.glRotatef((float)this.yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GL.glRotatef((float)this.pitch, (float)1.0f, (float)0.0f, (float)1.0f);
        if (null != this.geometry) {
            this.geometry.render();
        }
        for (int i = 0; i < this.children.size(); ++i) {
            ((Entity)this.children.get(i)).render();
        }
        GL.glDisable((int)2929);
        GL.glPopMatrix();
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void checkVisibility(Frustum frustum) {
        this.isVisible = null != this.boundingVolume ? this.boundingVolume.isVisible(frustum) : true;
    }

    public void setVisibilityType(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new MonkeyRuntimeException("Invalid visibility type.");
        }
        this.visibilityType = n;
    }

    public String toString() {
        String string = "-----";
        string = string + "Entity: \nPosition: " + this.position.toString() + "\n";
        for (int i = 0; i < this.children.size(); ++i) {
            string = string + "\nChild " + i + ": \n";
            string = string + ((Entity)this.children.get(i)).toString() + "\n";
        }
        if (null != this.geometry) {
            string = string + "\nGeometry: " + this.geometry.toString() + "\n-----";
        }
        return string;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }
}

