/*
 * Decompiled with CFR 0.152.
 */
package jme.geometry.bounding;

import jme.entity.camera.Frustum;
import jme.geometry.bounding.BoundingVolume;
import jme.math.Approximation;
import jme.math.Distance;
import jme.math.Line;
import jme.math.Vector;

public class BoundingCapsule
implements BoundingVolume {
    private Line lineSegment;
    private float radius;

    public BoundingCapsule() {
        this.lineSegment = new Line();
    }

    public BoundingCapsule(Line line, float f) {
        this.lineSegment = line;
        this.radius = f;
    }

    public Vector getOrigin() {
        return this.lineSegment.getOrigin();
    }

    public Vector getDirection() {
        return this.lineSegment.getDirection();
    }

    public float getRadius() {
        return this.radius;
    }

    public void leastSquaresFit(Vector[] vectorArray) {
        Line line = Approximation.orthogonalLineFit(vectorArray);
        float f = 0.0f;
        for (int i = 0; i < vectorArray.length; ++i) {
            float f2 = Distance.distancePointLineSquared(vectorArray[i], line);
            if (!(f2 > f)) continue;
            f = f2;
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = line.getDirection();
        Vector.generateOrthonormalBasis(vector, vector2, vector3, true);
        float f3 = Float.MAX_VALUE;
        float f4 = Float.MIN_VALUE;
        for (int i = 0; i < vectorArray.length; ++i) {
            float f5;
            float f6;
            Vector vector4 = vectorArray[i].subtract(line.getOrigin());
            float f7 = vector.dot(vector4);
            float f8 = vector2.dot(vector4);
            float f9 = vector3.dot(vector4);
            float f10 = f9 + (f6 = (float)Math.sqrt(Math.abs(f5 = f - (f7 * f7 + f8 * f8))));
            if (f10 < f3) {
                f3 = f10;
            }
            if (!((f10 = f9 - f6) > f4)) continue;
            f4 = f10;
        }
        if (f3 < f4) {
            this.lineSegment.setOrigin(line.getOrigin().add(line.getDirection().mult(f3)));
            this.lineSegment.setDirection(line.getDirection().mult(f4 - f3));
        } else {
            this.lineSegment.setOrigin(line.getOrigin().add(line.getDirection().mult(0.5f * (f3 + f4))));
            this.lineSegment.setDirection(new Vector());
        }
        this.radius = (float)Math.sqrt(f);
    }

    public boolean hasCollision(BoundingVolume boundingVolume) {
        return false;
    }

    public float distance(BoundingVolume boundingVolume) {
        return -1.0f;
    }

    public boolean isVisible(Frustum frustum) {
        return true;
    }
}

