/*
 * Decompiled with CFR 0.152.
 */
package jme.geometry.bounding;

import jme.entity.camera.Frustum;
import jme.geometry.bounding.BoundingVolume;
import jme.math.Approximation;
import jme.math.Matrix;
import jme.math.Vector;

public class BoundingEllipsoid
implements BoundingVolume {
    private Vector center;
    private Matrix a;
    private Matrix inverseA;

    public BoundingEllipsoid() {
        this.center = new Vector();
        this.a = new Matrix();
        this.inverseA = new Matrix();
    }

    public BoundingEllipsoid(Vector vector, Matrix matrix, Matrix matrix2) {
        this.center = vector;
        this.a = matrix;
        this.inverseA = matrix2;
    }

    public void gaussianDistribution(Vector[] vectorArray) {
        Vector[] vectorArray2 = new Vector[3];
        float[] fArray = new float[3];
        Approximation.gaussPointsFit(vectorArray, this.center, vectorArray2, fArray);
        float f = 0.0f;
        for (int i = 0; i < vectorArray.length; ++i) {
            Vector vector = vectorArray[i].subtract(this.center);
            float[] fArray2 = new float[]{vectorArray2[0].dot(vector), vectorArray2[1].dot(vector), vectorArray2[2].dot(vector)};
            float[] fArray3 = fArray2;
            float f2 = fArray[0] * fArray3[0] * fArray3[0] + fArray[1] * fArray3[1] * fArray3[1] + fArray[2] * fArray3[2] * fArray3[2];
            if (!(f2 > f)) continue;
            f = f2;
        }
        Matrix[] matrixArray = new Matrix[3];
        matrixArray[0].tensorProduct(vectorArray2[0], vectorArray2[0]);
        matrixArray[1].tensorProduct(vectorArray2[1], vectorArray2[1]);
        matrixArray[2].tensorProduct(vectorArray2[2], vectorArray2[2]);
        float f3 = 1.0f / f;
        matrixArray[0].multiply(f3 * fArray[0]);
        matrixArray[1].multiply(f3 * fArray[1]);
        matrixArray[2].multiply(f3 * fArray[2]);
        matrixArray[1].add(matrixArray[2]);
        matrixArray[0].add(matrixArray[1]);
        this.a = matrixArray[0];
    }

    public boolean hasCollision(BoundingVolume boundingVolume) {
        return false;
    }

    public float distance(BoundingVolume boundingVolume) {
        return -1.0f;
    }

    public boolean isVisible(Frustum frustum) {
        return true;
    }
}

