/*
 * Decompiled with CFR 0.152.
 */
package jme.geometry.hud;

import jme.exception.MonkeyGLException;
import jme.exception.MonkeyRuntimeException;
import jme.texture.TextureManager;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.Window;

public class SplashScreen {
    private int texId;
    private float x;
    private float y;
    private float width;
    private float height;
    private boolean isBlended;
    private float red;
    private float green;
    private float blue;
    private float alpha;
    private long delay;

    public SplashScreen() {
        if (!Window.isCreated()) {
            throw new MonkeyGLException("Window must be created first.");
        }
        this.red = 1.0f;
        this.blue = 1.0f;
        this.green = 1.0f;
        this.alpha = 1.0f;
        this.width = Window.getWidth();
        this.height = Window.getHeight();
        this.isBlended = true;
    }

    public void setTexture(String string) {
        this.texId = TextureManager.getTextureManager().loadTexture(string, 9729, 9729, true);
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.red = f;
        this.green = f2;
        this.blue = f3;
        this.alpha = f4;
    }

    public void setPosition(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public void setSize(float f, float f2) {
        if (f < 0.0f || f2 < 0.0f) {
            throw new MonkeyRuntimeException("Neither height nor width may be negative");
        }
        this.width = f2;
        this.height = f;
    }

    public void setBlended(boolean bl) {
        this.isBlended = bl;
    }

    public void setDelay(long l) {
        this.delay = l;
    }

    public void holdDisplay() {
        try {
            Thread.sleep(this.delay);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void render() {
        if (this.isBlended) {
            GL.glEnable((int)3042);
        }
        GL.glDisable((int)2929);
        GL.glEnable((int)3553);
        GL.glMatrixMode((int)5889);
        GL.glPushMatrix();
        GL.glLoadIdentity();
        GL.glOrtho((double)0.0, (double)Window.getWidth(), (double)0.0, (double)Window.getHeight(), (double)-1.0, (double)1.0);
        GL.glMatrixMode((int)5888);
        GL.glPushMatrix();
        GL.glLoadIdentity();
        GL.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
        GL.glColor4f((float)this.red, (float)this.green, (float)this.blue, (float)this.alpha);
        TextureManager.getTextureManager().bind(this.texId);
        GL.glBegin((int)7);
        GL.glTexCoord2f((float)0.0f, (float)1.0f);
        GL.glVertex3f((float)0.0f, (float)this.height, (float)0.0f);
        GL.glTexCoord2f((float)0.0f, (float)0.0f);
        GL.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL.glTexCoord2f((float)1.0f, (float)0.0f);
        GL.glVertex3f((float)this.width, (float)0.0f, (float)0.0f);
        GL.glTexCoord2f((float)1.0f, (float)1.0f);
        GL.glVertex3f((float)this.width, (float)this.height, (float)0.0f);
        GL.glEnd();
        if (this.isBlended) {
            GL.glDisable((int)3042);
        }
        GL.glMatrixMode((int)5889);
        GL.glPopMatrix();
        GL.glMatrixMode((int)5888);
        GL.glPopMatrix();
        GL.glEnable((int)2929);
        GL.glDisable((int)3553);
    }
}

