/*
 * Decompiled with CFR 0.152.
 */
package jme.geometry.model.ms;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import jme.geometry.model.Joint;
import jme.geometry.model.Keyframe;
import jme.geometry.model.Material;
import jme.geometry.model.Mesh;
import jme.geometry.model.Model;
import jme.geometry.model.Triangle;
import jme.geometry.model.Vertex;
import jme.math.Matrix;
import jme.math.Quaternion;
import jme.math.Vector;
import jme.texture.TextureManager;
import org.lwjgl.opengl.GL;

public class MilkshapeModel
implements Model {
    private boolean animated;
    private int totalFrames;
    private float currentFrame;
    private int numberMeshes;
    private int numberMaterials;
    private int numberJoints;
    private Mesh[] meshes;
    private Material[] materials;
    private Joint[] joints;
    private ArrayList points;
    private String absoluteFilePath;
    private float r = 1.0f;
    private float g = 1.0f;
    private float b = 1.0f;
    private float a = 1.0f;
    private String filename;

    public MilkshapeModel(String string) {
        this.filename = string;
        this.animated = false;
        this.initialize();
    }

    public MilkshapeModel(String string, boolean bl) {
        this.filename = string;
        this.animated = bl;
        this.initialize();
    }

    public void render() {
        boolean bl = GL.glIsEnabled((int)3553);
        for (int i = 0; i < this.numberMeshes; ++i) {
            int n = this.meshes[i].materialIndex;
            if (n >= 0) {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder());
                GL.glMaterial((int)1028, (int)4608, (FloatBuffer)byteBuffer.asFloatBuffer().put(this.materials[n].ambient));
                GL.glMaterial((int)1028, (int)4609, (FloatBuffer)byteBuffer.asFloatBuffer().put(this.materials[n].diffuse));
                GL.glMaterial((int)1028, (int)4610, (FloatBuffer)byteBuffer.asFloatBuffer().put(this.materials[n].specular));
                GL.glMaterial((int)1028, (int)5632, (FloatBuffer)byteBuffer.asFloatBuffer().put(this.materials[n].emissive));
                GL.glMaterialf((int)1028, (int)5633, (float)this.materials[n].shininess);
                if (this.materials[n].glTextureAddress > 0) {
                    TextureManager.getTextureManager().bind(this.materials[n].glTextureAddress);
                    GL.glEnable((int)3553);
                } else {
                    GL.glDisable((int)3553);
                }
            } else {
                GL.glDisable((int)3553);
            }
            int n2 = this.meshes[i].numberTriangles;
            Vertex[] vertexArray = this.meshes[i].vertices;
            GL.glBegin((int)4);
            GL.glColor4f((float)this.r, (float)this.g, (float)this.b, (float)this.a);
            for (int j = 0; j < n2; ++j) {
                Vector vector;
                Triangle triangle = this.meshes[i].triangles[j];
                Vertex vertex = vertexArray[triangle.vertexIndex1];
                float[] fArray = this.meshes[i].normals[triangle.normalIndex1];
                if (!this.animated || vertex.boneIndex == -1) {
                    GL.glNormal3f((float)fArray[0], (float)fArray[1], (float)fArray[2]);
                    GL.glTexCoord2f((float)vertex.u, (float)vertex.v);
                    GL.glVertex3f((float)vertex.x, (float)vertex.y, (float)vertex.z);
                } else {
                    vector = new Vector(vertex.x, vertex.y, vertex.z).rotate(this.joints[vertex.boneIndex].finalMatrix);
                    vector.x += this.joints[vertex.boneIndex].finalMatrix.matrix[0][3];
                    vector.y += this.joints[vertex.boneIndex].finalMatrix.matrix[1][3];
                    vector.z += this.joints[vertex.boneIndex].finalMatrix.matrix[2][3];
                    GL.glNormal3f((float)fArray[0], (float)fArray[1], (float)fArray[2]);
                    GL.glTexCoord2f((float)vertex.u, (float)vertex.v);
                    GL.glVertex3f((float)vector.x, (float)vector.y, (float)vector.z);
                }
                vertex = vertexArray[triangle.vertexIndex2];
                fArray = this.meshes[i].normals[triangle.normalIndex2];
                if (!this.animated || vertex.boneIndex == -1) {
                    GL.glNormal3f((float)fArray[0], (float)fArray[1], (float)fArray[2]);
                    GL.glTexCoord2f((float)vertex.u, (float)vertex.v);
                    GL.glVertex3f((float)vertex.x, (float)vertex.y, (float)vertex.z);
                } else {
                    vector = new Vector(vertex.x, vertex.y, vertex.z).rotate(this.joints[vertex.boneIndex].finalMatrix);
                    vector.x += this.joints[vertex.boneIndex].finalMatrix.matrix[0][3];
                    vector.y += this.joints[vertex.boneIndex].finalMatrix.matrix[1][3];
                    vector.z += this.joints[vertex.boneIndex].finalMatrix.matrix[2][3];
                    GL.glNormal3f((float)fArray[0], (float)fArray[1], (float)fArray[2]);
                    GL.glTexCoord2f((float)vertex.u, (float)vertex.v);
                    GL.glVertex3f((float)vector.x, (float)vector.y, (float)vector.z);
                }
                vertex = vertexArray[triangle.vertexIndex3];
                fArray = this.meshes[i].normals[triangle.normalIndex3];
                if (!this.animated || vertex.boneIndex == -1) {
                    GL.glNormal3f((float)fArray[0], (float)fArray[1], (float)fArray[2]);
                    GL.glTexCoord2f((float)vertex.u, (float)vertex.v);
                    GL.glVertex3f((float)vertex.x, (float)vertex.y, (float)vertex.z);
                    continue;
                }
                vector = new Vector(vertex.x, vertex.y, vertex.z).rotate(this.joints[vertex.boneIndex].finalMatrix);
                vector.x += this.joints[vertex.boneIndex].finalMatrix.matrix[0][3];
                vector.y += this.joints[vertex.boneIndex].finalMatrix.matrix[1][3];
                vector.z += this.joints[vertex.boneIndex].finalMatrix.matrix[2][3];
                GL.glNormal3f((float)fArray[0], (float)fArray[1], (float)fArray[2]);
                GL.glTexCoord2f((float)vertex.u, (float)vertex.v);
                GL.glVertex3f((float)vector.x, (float)vector.y, (float)vector.z);
            }
            GL.glEnd();
        }
        if (bl) {
            GL.glEnable((int)3553);
        } else {
            GL.glDisable((int)3553);
        }
    }

    public void update(float f) {
        if (!this.animated) {
            return;
        }
        this.currentFrame += f;
        if (this.currentFrame > (float)this.totalFrames) {
            this.currentFrame = 0.0f;
        }
        for (int i = 0; i < this.numberJoints; ++i) {
            Keyframe keyframe;
            Joint joint = this.joints[i];
            int n = joint.numberPosistionKeyframes;
            int n2 = joint.numberRotationKeyframes;
            if (n == 0 && n2 == 0) {
                this.joints[i].finalMatrix.copy(this.joints[i].absoluteMatrix);
                continue;
            }
            Vector vector = new Vector();
            Quaternion quaternion = new Quaternion();
            Keyframe keyframe2 = null;
            Keyframe keyframe3 = null;
            for (int j = 0; j < n; ++j) {
                keyframe = joint.positionKeys[j];
                if (keyframe.time >= this.currentFrame) {
                    keyframe3 = keyframe;
                    break;
                }
                keyframe2 = keyframe;
            }
            if (keyframe2 != null && keyframe3 != null) {
                float f2 = keyframe3.time - keyframe2.time;
                float f3 = (this.currentFrame - keyframe2.time) / f2;
                vector.x = keyframe2.x + (keyframe3.x - keyframe2.x) * f3;
                vector.y = keyframe2.y + (keyframe3.y - keyframe2.y) * f3;
                vector.z = keyframe2.z + (keyframe3.z - keyframe2.z) * f3;
            } else if (keyframe2 == null) {
                keyframe3.x = vector.x;
                keyframe3.y = vector.y;
                keyframe3.z = vector.z;
            } else if (keyframe3 == null) {
                keyframe2.x = vector.x;
                keyframe2.y = vector.y;
                keyframe2.z = vector.z;
            }
            Matrix matrix = new Matrix();
            keyframe = null;
            Keyframe keyframe4 = null;
            for (int j = 0; j < n2; ++j) {
                Keyframe keyframe5 = joint.rotationKeys[j];
                if (keyframe5.time >= this.currentFrame) {
                    keyframe4 = keyframe5;
                    break;
                }
                keyframe = keyframe5;
            }
            if (keyframe != null && keyframe4 != null) {
                float f4 = keyframe4.time - keyframe.time;
                float f5 = (this.currentFrame - keyframe.time) / f4;
                Quaternion quaternion2 = new Quaternion();
                Quaternion quaternion3 = new Quaternion();
                Quaternion quaternion4 = new Quaternion();
                quaternion3.fromAngles(new float[]{keyframe.x, keyframe.y, keyframe.z});
                quaternion4.fromAngles(new float[]{keyframe4.x, keyframe4.y, keyframe4.z});
                quaternion2 = quaternion2.slerp(quaternion3, quaternion4, f5);
                matrix.set(quaternion2);
            } else if (keyframe == null) {
                quaternion.x = keyframe4.x * 180.0f / (float)Math.PI;
                quaternion.y = keyframe4.y * 180.0f / (float)Math.PI;
                quaternion.z = keyframe4.z * 180.0f / (float)Math.PI;
                matrix.angleRotationDegrees(new Vector(quaternion.x, quaternion.y, quaternion.z));
            } else if (keyframe4 == null) {
                quaternion.x = keyframe.x * 180.0f / (float)Math.PI;
                quaternion.y = keyframe.y * 180.0f / (float)Math.PI;
                quaternion.z = keyframe.z * 180.0f / (float)Math.PI;
                matrix.angleRotationDegrees(new Vector(quaternion.x, quaternion.y, quaternion.z));
            }
            matrix.matrix[0][3] = vector.x;
            matrix.matrix[1][3] = vector.y;
            matrix.matrix[2][3] = vector.z;
            this.joints[i].relativeFinalMatrix = this.joints[i].relativeMatrix.multiply(matrix);
            if (joint.parentIndex == -1) {
                this.joints[i].finalMatrix.copy(this.joints[i].relativeFinalMatrix);
                continue;
            }
            this.joints[i].finalMatrix = this.joints[joint.parentIndex].finalMatrix.multiply(this.joints[i].relativeFinalMatrix);
        }
    }

    public void initialize() {
        this.points = new ArrayList();
        try {
            String string;
            File file = new File(this.filename);
            this.absoluteFilePath = file.getAbsolutePath();
            this.absoluteFilePath = this.absoluteFilePath.substring(0, this.absoluteFilePath.lastIndexOf(File.separator) + 1);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = this.getNextLine(bufferedReader)) != null) {
                if (string.startsWith("Frames: ")) {
                    this.totalFrames = Integer.parseInt(string.substring(8));
                }
                if (string.startsWith("Frame: ")) {
                    this.currentFrame = Integer.parseInt(string.substring(7));
                }
                if (string.startsWith("Meshes: ")) {
                    this.numberMeshes = Integer.parseInt(string.substring(8));
                    this.meshes = new Mesh[this.numberMeshes];
                    this.parseMeshes(bufferedReader);
                }
                if (string.startsWith("Materials: ")) {
                    this.numberMaterials = Integer.parseInt(string.substring(11));
                    this.materials = new Material[this.numberMaterials];
                    this.parseMaterials(bufferedReader);
                }
                if (!string.startsWith("Bones: ")) continue;
                this.numberJoints = Integer.parseInt(string.substring(7));
                this.joints = new Joint[this.numberJoints];
                this.parseJoints(bufferedReader);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.reloadTextures();
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.r = f;
        this.g = f2;
        this.b = f3;
        this.a = f4;
    }

    public void setTexture(String string) {
    }

    public Vector[] getPoints() {
        Vector[] vectorArray = new Vector[this.points.size()];
        return this.points.toArray(vectorArray);
    }

    private void parseMeshes(BufferedReader bufferedReader) throws Exception {
        for (int i = 0; i < this.numberMeshes; ++i) {
            Object[] objectArray;
            Mesh mesh = new Mesh();
            String string = this.getNextLine(bufferedReader);
            mesh.name = string.substring(1, string.lastIndexOf("\""));
            mesh.flags = Integer.parseInt(string.substring(string.lastIndexOf("\"") + 2, string.lastIndexOf(" ")));
            mesh.materialIndex = Integer.parseInt(string.substring(string.lastIndexOf(" ") + 1));
            string = this.getNextLine(bufferedReader);
            mesh.numberVertices = Integer.parseInt(string);
            Vertex[] vertexArray = new Vertex[mesh.numberVertices];
            for (int j = 0; j < mesh.numberVertices; ++j) {
                string = this.getNextLine(bufferedReader);
                objectArray = string.split(" ");
                vertexArray[j] = new Vertex(Integer.parseInt(objectArray[0]), Float.parseFloat(objectArray[1]), Float.parseFloat(objectArray[2]), Float.parseFloat(objectArray[3]), Float.parseFloat(objectArray[4]), Float.parseFloat(objectArray[5]), Integer.parseInt(objectArray[6]));
                this.points.add(new Vector(vertexArray[j].x, vertexArray[j].y, vertexArray[j].z));
            }
            mesh.vertices = vertexArray;
            string = this.getNextLine(bufferedReader);
            mesh.numberNormals = Integer.parseInt(string);
            float[][] fArray = new float[mesh.numberNormals][3];
            for (int j = 0; j < mesh.numberNormals; ++j) {
                string = this.getNextLine(bufferedReader);
                String[] stringArray = string.split(" ");
                fArray[j] = new float[]{Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2])};
            }
            mesh.normals = fArray;
            string = this.getNextLine(bufferedReader);
            mesh.numberTriangles = Integer.parseInt(string);
            objectArray = new Triangle[mesh.numberTriangles];
            for (int j = 0; j < mesh.numberTriangles; ++j) {
                string = this.getNextLine(bufferedReader);
                String[] stringArray = string.split(" ");
                objectArray[j] = new Triangle(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]), Integer.parseInt(stringArray[4]), Integer.parseInt(stringArray[5]), Integer.parseInt(stringArray[6]), Integer.parseInt(stringArray[7]));
            }
            mesh.triangles = objectArray;
            this.meshes[i] = mesh;
        }
    }

    private void parseMaterials(BufferedReader bufferedReader) throws Exception {
        for (int i = 0; i < this.numberMaterials; ++i) {
            String string = this.getNextLine(bufferedReader);
            Material material = new Material();
            material.name = string.substring(1, string.length() - 1);
            string = this.getNextLine(bufferedReader);
            String[] stringArray = string.split(" ");
            material.ambient = new float[]{Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]), Float.parseFloat(stringArray[3])};
            string = this.getNextLine(bufferedReader);
            stringArray = string.split(" ");
            material.diffuse = new float[]{Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]), Float.parseFloat(stringArray[3])};
            string = this.getNextLine(bufferedReader);
            stringArray = string.split(" ");
            material.specular = new float[]{Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]), Float.parseFloat(stringArray[3])};
            string = this.getNextLine(bufferedReader);
            stringArray = string.split(" ");
            material.emissive = new float[]{Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]), Float.parseFloat(stringArray[3])};
            string = this.getNextLine(bufferedReader);
            material.shininess = Float.parseFloat(string);
            string = this.getNextLine(bufferedReader);
            material.transparency = Float.parseFloat(string);
            string = this.getNextLine(bufferedReader);
            material.colorMap = string.substring(1, string.length() - 1);
            string = this.getNextLine(bufferedReader);
            material.alphaMap = string.substring(1, string.length() - 1);
            this.materials[i] = material;
        }
    }

    private void parseJoints(BufferedReader bufferedReader) throws Exception {
        for (int i = 0; i < this.numberJoints; ++i) {
            int n;
            String string = this.getNextLine(bufferedReader);
            Joint joint = new Joint();
            joint.name = string.substring(1, string.length() - 1);
            string = this.getNextLine(bufferedReader);
            joint.parentName = string.substring(1, string.length() - 1);
            string = this.getNextLine(bufferedReader);
            String[] stringArray = string.split(" ");
            joint.flags = Integer.parseInt(stringArray[0]);
            joint.posx = Float.parseFloat(stringArray[1]);
            joint.posy = Float.parseFloat(stringArray[2]);
            joint.posz = Float.parseFloat(stringArray[3]);
            joint.rotx = Float.parseFloat(stringArray[4]);
            joint.roty = Float.parseFloat(stringArray[5]);
            joint.rotz = Float.parseFloat(stringArray[6]);
            string = this.getNextLine(bufferedReader);
            joint.numberPosistionKeyframes = Integer.parseInt(string);
            Keyframe[] keyframeArray = new Keyframe[joint.numberPosistionKeyframes];
            for (int j = 0; j < joint.numberPosistionKeyframes; ++j) {
                string = this.getNextLine(bufferedReader);
                stringArray = string.split(" ");
                keyframeArray[j] = new Keyframe(Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]), Float.parseFloat(stringArray[3]));
            }
            joint.positionKeys = keyframeArray;
            string = this.getNextLine(bufferedReader);
            joint.numberRotationKeyframes = Integer.parseInt(string);
            Keyframe[] keyframeArray2 = new Keyframe[joint.numberRotationKeyframes];
            for (n = 0; n < joint.numberRotationKeyframes; ++n) {
                string = this.getNextLine(bufferedReader);
                stringArray = string.split(" ");
                keyframeArray2[n] = new Keyframe(Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]), Float.parseFloat(stringArray[3]));
            }
            joint.rotationKeys = keyframeArray2;
            this.joints[i] = joint;
            n = -1;
            if (this.joints[i].parentName.length() > 0) {
                for (int j = 0; j < this.numberJoints; ++j) {
                    if (!this.joints[j].name.equalsIgnoreCase(this.joints[i].parentName)) continue;
                    n = j;
                    break;
                }
                if (n == -1) {
                    System.out.println("CRAP!");
                    System.exit(1);
                }
            }
            this.joints[i].parentIndex = n;
        }
        if (this.animated) {
            this.setupJointAnimations();
        }
    }

    private void setupJointAnimations() {
        Object object;
        int n;
        for (n = 0; n < this.numberJoints; ++n) {
            object = this.joints[n];
            Vector vector = new Vector();
            vector.x = ((Joint)object).rotx * 180.0f / (float)Math.PI;
            vector.y = ((Joint)object).roty * 180.0f / (float)Math.PI;
            vector.z = ((Joint)object).rotz * 180.0f / (float)Math.PI;
            this.joints[n].relativeMatrix.angleRotationDegrees(vector);
            this.joints[n].relativeMatrix.matrix[0][3] = ((Joint)object).posx;
            this.joints[n].relativeMatrix.matrix[1][3] = ((Joint)object).posy;
            this.joints[n].relativeMatrix.matrix[2][3] = ((Joint)object).posz;
            if (((Joint)object).parentIndex != -1) {
                this.joints[n].absoluteMatrix = this.joints[((Joint)object).parentIndex].absoluteMatrix.multiply(this.joints[n].relativeMatrix);
                this.joints[n].finalMatrix.copy(this.joints[n].absoluteMatrix);
                continue;
            }
            this.joints[n].absoluteMatrix.copy(this.joints[n].relativeMatrix);
            this.joints[n].finalMatrix.copy(this.joints[n].relativeMatrix);
        }
        for (n = 0; n < this.numberMeshes; ++n) {
            object = this.meshes[n];
            for (int i = 0; i < ((Mesh)object).numberVertices; ++i) {
                Vertex vertex = ((Mesh)object).vertices[i];
                if (vertex.boneIndex == -1) continue;
                vertex.x -= this.joints[vertex.boneIndex].absoluteMatrix.matrix[0][3];
                vertex.y -= this.joints[vertex.boneIndex].absoluteMatrix.matrix[1][3];
                vertex.z -= this.joints[vertex.boneIndex].absoluteMatrix.matrix[2][3];
                Vector vector = new Vector();
                vector = new Vector(vertex.x, vertex.y, vertex.z).inverseRotate(this.joints[vertex.boneIndex].absoluteMatrix);
                vertex.x = vector.x;
                vertex.y = vector.y;
                vertex.z = vector.z;
            }
        }
    }

    private String getNextLine(BufferedReader bufferedReader) throws Exception {
        String string = null;
        while ((string = bufferedReader.readLine()) != null && ((string = string.trim()).startsWith("//") || "".equals(string))) {
        }
        return string;
    }

    private final void reloadTextures() {
        for (int i = 0; i < this.numberMaterials; ++i) {
            if (this.materials[i].name.length() > 0) {
                try {
                    this.materials[i].glTextureAddress = this.loadTexture(this.absoluteFilePath + this.materials[i].colorMap);
                }
                catch (Exception exception) {
                    this.materials[i].glTextureAddress = 0;
                }
                continue;
            }
            this.materials[i].glTextureAddress = 0;
        }
    }

    private final int loadTexture(String string) throws Exception {
        System.out.println(string);
        return TextureManager.getTextureManager().loadTexture(string, 9987, 9729, true, false);
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setAnimated(boolean bl) {
        this.animated = bl;
    }
}

