/*
 * Decompiled with CFR 0.152.
 */
package jme.locale.external.data;

import java.util.logging.Level;
import jme.exception.MonkeyRuntimeException;
import jme.locale.external.data.AbstractHeightMap;
import jme.utility.LoggingSystem;

public class MidPointHeightMap
extends AbstractHeightMap {
    private float roughness;

    public MidPointHeightMap(int n, float f) {
        if (f < 0.0f || n <= 0) {
            throw new MonkeyRuntimeException("size and roughness must be greater than 0");
        }
        this.roughness = f;
        this.size = n;
        this.load();
    }

    public boolean load() {
        int n;
        int n2;
        if (null != this.heightData) {
            this.unloadHeightMap();
        }
        float f = this.size / 2;
        double d = Math.pow(2.0, -1.0f * this.roughness);
        this.heightData = new int[this.size][this.size];
        float[][] fArray = new float[this.size][this.size];
        for (int i = this.size; i > 0; i /= 2) {
            int n3;
            int n4;
            int n5;
            int n6;
            for (n2 = 0; n2 < this.size; n2 += i) {
                for (n = 0; n < this.size; n += i) {
                    n6 = (n2 + i) % this.size;
                    n5 = (n + i) % this.size;
                    n4 = n2 + i / 2;
                    n3 = n + i / 2;
                    fArray[n4][n3] = (float)((double)((fArray[n2][n] + fArray[n6][n] + fArray[n2][n5] + fArray[n6][n5]) / 4.0f) + (Math.random() * (double)f - (double)(f / 2.0f)));
                }
            }
            for (n2 = 0; n2 < this.size; n2 += i) {
                for (n = 0; n < this.size; n += i) {
                    n6 = (n2 + i) % this.size;
                    n5 = (n + i) % this.size;
                    n4 = n2 + i / 2;
                    n3 = n + i / 2;
                    int n7 = (n2 - i / 2 + this.size) % this.size;
                    int n8 = (n - i / 2 + this.size) % this.size;
                    fArray[n4][n] = (float)((double)((fArray[n2][n] + fArray[n6][n] + fArray[n4][n8] + fArray[n4][n3]) / 4.0f) + (Math.random() * (double)f - (double)(f / 2.0f)));
                    fArray[n2][n3] = (float)((double)((fArray[n2][n] + fArray[n2][n5] + fArray[n7][n3] + fArray[n4][n3]) / 4.0f) + (Math.random() * (double)f - (double)(f / 2.0f)));
                }
            }
            f = (float)((double)f * d);
        }
        this.normalizeTerrain(fArray);
        for (n2 = 0; n2 < this.size; ++n2) {
            for (n = 0; n < this.size; ++n) {
                this.setHeightAtPoint((int)fArray[n2][n], n2, n);
            }
        }
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Created Heightmap using Fault Fractal");
        return true;
    }

    public void setRoughness(float f) {
        if (f < 0.0f) {
            throw new MonkeyRuntimeException("roughness must be greater than 0");
        }
        this.roughness = f;
    }
}

