/*
 * Decompiled with CFR 0.152.
 */
package jme.math;

import java.util.logging.Level;
import jme.math.MathUtils;
import jme.utility.LoggingSystem;

public class EigenSystem {
    private float[][] matrix;
    private float[][] eigenVectors;
    private float[][] hessenberg;
    private float[] realEigenValues;
    private float[] imaginaryEigenValues;
    private int size;

    public EigenSystem(float[][] fArray) {
        int n;
        int n2;
        this.matrix = fArray;
        if (fArray[0].length != fArray.length) {
            LoggingSystem.getLoggingSystem().getLogger().log(Level.WARNING, "Matrix is not square.");
            return;
        }
        this.size = fArray.length;
        for (n2 = 0; n2 < this.size; ++n2) {
            for (n = 0; n < this.size; ++n) {
                if (this.matrix[n2][n] == this.matrix[n][n2]) continue;
                LoggingSystem.getLoggingSystem().getLogger().log(Level.WARNING, "Matrix is not symmetric.");
                return;
            }
        }
        this.realEigenValues = new float[this.size];
        this.imaginaryEigenValues = new float[this.size];
        this.eigenVectors = new float[this.size][this.size];
        this.hessenberg = new float[this.size][this.size];
        for (n2 = 0; n2 < this.size; ++n2) {
            for (n = 0; n < this.size; ++n) {
                this.eigenVectors[n2][n] = fArray[n2][n];
            }
        }
    }

    public void decreasingSort() {
        for (int i = 0; i <= this.size - 2; ++i) {
            int n;
            int n2 = i;
            float f = this.realEigenValues[n2];
            for (n = i + 1; n < this.size; ++n) {
                if (!(this.realEigenValues[n] > f)) continue;
                n2 = n;
                f = this.realEigenValues[n2];
            }
            if (n2 == i) continue;
            this.realEigenValues[n2] = this.realEigenValues[i];
            this.realEigenValues[i] = f;
            for (n = 0; n < this.size; ++n) {
                float f2 = this.eigenVectors[n][i];
                this.eigenVectors[n][i] = this.eigenVectors[n][n2];
                this.eigenVectors[n][n2] = f2;
            }
        }
    }

    public void increasingSort() {
        for (int i = 0; i <= this.size - 2; ++i) {
            int n;
            int n2 = i;
            float f = this.realEigenValues[n2];
            for (n = i + 1; n < this.size; ++n) {
                if (!(this.realEigenValues[n] < f)) continue;
                n2 = n;
                f = this.realEigenValues[n2];
            }
            if (n2 == i) continue;
            this.realEigenValues[n2] = this.realEigenValues[i];
            this.realEigenValues[i] = f;
            for (n = 0; n < this.size; ++n) {
                float f2 = this.eigenVectors[n][i];
                this.eigenVectors[n][i] = this.eigenVectors[n2][n];
                this.eigenVectors[n][n2] = f2;
            }
        }
    }

    public void tridiagonalReduction() {
        float f;
        int n;
        for (n = 0; n < this.size; ++n) {
            this.realEigenValues[n] = this.eigenVectors[this.size - 1][n];
        }
        for (n = this.size - 1; n > 0; --n) {
            int n2;
            f = 0.0f;
            float f2 = 0.0f;
            for (n2 = 0; n2 < n; ++n2) {
                f += Math.abs(this.realEigenValues[n2]);
            }
            if (f == 0.0f) {
                this.imaginaryEigenValues[n] = this.realEigenValues[n - 1];
                for (n2 = 0; n2 < n; ++n2) {
                    this.realEigenValues[n2] = this.eigenVectors[n - 1][n2];
                    this.eigenVectors[n][n2] = 0.0f;
                    this.eigenVectors[n2][n] = 0.0f;
                }
            } else {
                int n3;
                int n4;
                for (n2 = 0; n2 < n; ++n2) {
                    int n5 = n2;
                    this.realEigenValues[n5] = this.realEigenValues[n5] / f;
                    f2 += this.realEigenValues[n2] * this.realEigenValues[n2];
                }
                float f3 = this.realEigenValues[n - 1];
                float f4 = (float)Math.sqrt(f2);
                if (f3 > 0.0f) {
                    f4 = -f4;
                }
                this.imaginaryEigenValues[n] = f * f4;
                f2 -= f3 * f4;
                this.realEigenValues[n - 1] = f3 - f4;
                for (n4 = 0; n4 < n; ++n4) {
                    this.imaginaryEigenValues[n4] = 0.0f;
                }
                for (n4 = 0; n4 < n; ++n4) {
                    this.eigenVectors[n4][n] = f3 = this.realEigenValues[n4];
                    f4 = this.imaginaryEigenValues[n4] + this.eigenVectors[n4][n4] * f3;
                    for (n3 = n4 + 1; n3 <= n - 1; ++n3) {
                        f4 += this.eigenVectors[n3][n4] * this.realEigenValues[n3];
                        int n6 = n3;
                        this.imaginaryEigenValues[n6] = this.imaginaryEigenValues[n6] + this.eigenVectors[n3][n4] * f3;
                    }
                    this.imaginaryEigenValues[n4] = f4;
                }
                f3 = 0.0f;
                for (n4 = 0; n4 < n; ++n4) {
                    int n7 = n4;
                    this.imaginaryEigenValues[n7] = this.imaginaryEigenValues[n7] / f2;
                    f3 += this.imaginaryEigenValues[n4] * this.realEigenValues[n4];
                }
                float f5 = f3 / (f2 + f2);
                for (n3 = 0; n3 < n; ++n3) {
                    int n8 = n3;
                    this.imaginaryEigenValues[n8] = this.imaginaryEigenValues[n8] - f5 * this.realEigenValues[n3];
                }
                for (n3 = 0; n3 < n; ++n3) {
                    f3 = this.realEigenValues[n3];
                    f4 = this.imaginaryEigenValues[n3];
                    for (int i = n3; i <= n - 1; ++i) {
                        float[] fArray = this.eigenVectors[i];
                        int n9 = n3;
                        fArray[n9] = fArray[n9] - (f3 * this.imaginaryEigenValues[i] + f4 * this.realEigenValues[i]);
                    }
                    this.realEigenValues[n3] = this.eigenVectors[n - 1][n3];
                    this.eigenVectors[n][n3] = 0.0f;
                }
            }
            this.realEigenValues[n] = f2;
        }
        for (n = 0; n < this.size - 1; ++n) {
            int n10;
            this.eigenVectors[this.size - 1][n] = this.eigenVectors[n][n];
            this.eigenVectors[n][n] = 1.0f;
            f = this.realEigenValues[n + 1];
            if (f != 0.0f) {
                for (n10 = 0; n10 <= n; ++n10) {
                    this.realEigenValues[n10] = this.eigenVectors[n10][n + 1] / f;
                }
                for (n10 = 0; n10 <= n; ++n10) {
                    int n11;
                    float f6 = 0.0f;
                    for (n11 = 0; n11 <= n; ++n11) {
                        f6 += this.eigenVectors[n11][n + 1] * this.eigenVectors[n11][n10];
                    }
                    for (n11 = 0; n11 <= n; ++n11) {
                        float[] fArray = this.eigenVectors[n11];
                        int n12 = n10;
                        fArray[n12] = fArray[n12] - f6 * this.realEigenValues[n11];
                    }
                }
            }
            for (n10 = 0; n10 <= n; ++n10) {
                this.eigenVectors[n10][n + 1] = 0.0f;
            }
        }
        for (n = 0; n < this.size; ++n) {
            this.realEigenValues[n] = this.eigenVectors[this.size - 1][n];
            this.eigenVectors[this.size - 1][n] = 0.0f;
        }
        this.eigenVectors[this.size - 1][this.size - 1] = 1.0f;
        this.imaginaryEigenValues[0] = 0.0f;
    }

    public void tridiagonalQL() {
        int n;
        int n2;
        for (int i = 1; i < this.size; ++i) {
            this.imaginaryEigenValues[i - 1] = this.imaginaryEigenValues[i];
        }
        this.imaginaryEigenValues[this.size - 1] = 0.0f;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = (float)Math.pow(2.0, -52.0);
        for (n2 = 0; n2 < this.size; ++n2) {
            f2 = Math.max(f2, Math.abs(this.realEigenValues[n2]) + Math.abs(this.imaginaryEigenValues[n2]));
            for (n = n2; n < this.size && !(Math.abs(this.imaginaryEigenValues[n]) <= f3 * f2); ++n) {
            }
            if (n > n2) {
                int n3 = 0;
                do {
                    float f4;
                    ++n3;
                    float f5 = this.realEigenValues[n2];
                    float f6 = (this.realEigenValues[n2 + 1] - f5) / (2.0f * this.imaginaryEigenValues[n2]);
                    float f7 = MathUtils.hypot(f6, 1.0f);
                    if (f6 < 0.0f) {
                        f7 = -f7;
                    }
                    this.realEigenValues[n2] = this.imaginaryEigenValues[n2] / (f6 + f7);
                    this.realEigenValues[n2 + 1] = this.imaginaryEigenValues[n2] * (f6 + f7);
                    float f8 = this.realEigenValues[n2 + 1];
                    float f9 = f5 - this.realEigenValues[n2];
                    int n4 = n2 + 2;
                    while (n4 < this.size) {
                        int n5 = n4++;
                        this.realEigenValues[n5] = this.realEigenValues[n5] - f9;
                    }
                    f += f9;
                    f6 = this.realEigenValues[n];
                    float f10 = f4 = 1.0f;
                    float f11 = f4;
                    float f12 = this.imaginaryEigenValues[n2 + 1];
                    float f13 = 0.0f;
                    float f14 = 0.0f;
                    for (int i = n - 1; i >= n2; --i) {
                        f11 = f10;
                        f10 = f4;
                        f14 = f13;
                        f5 = f4 * this.imaginaryEigenValues[i];
                        f9 = f4 * f6;
                        f7 = MathUtils.hypot(f6, this.imaginaryEigenValues[i]);
                        this.imaginaryEigenValues[i + 1] = f13 * f7;
                        f13 = this.imaginaryEigenValues[i] / f7;
                        f4 = f6 / f7;
                        f6 = f4 * this.realEigenValues[i] - f13 * f5;
                        this.realEigenValues[i + 1] = f9 + f13 * (f4 * f5 + f13 * this.realEigenValues[i]);
                        for (int j = 0; j < this.size; ++j) {
                            f9 = this.eigenVectors[j][i + 1];
                            this.eigenVectors[j][i + 1] = f13 * this.eigenVectors[j][i] + f4 * f9;
                            this.eigenVectors[j][i] = f4 * this.eigenVectors[j][i] - f13 * f9;
                        }
                    }
                    f6 = -f13 * f14 * f11 * f12 * this.imaginaryEigenValues[n2] / f8;
                    this.imaginaryEigenValues[n2] = f13 * f6;
                    this.realEigenValues[n2] = f4 * f6;
                } while (Math.abs(this.imaginaryEigenValues[n2]) > f3 * f2);
            }
            this.realEigenValues[n2] = this.realEigenValues[n2] + f;
            this.imaginaryEigenValues[n2] = 0.0f;
        }
        for (n2 = 0; n2 < this.size - 1; ++n2) {
            int n6;
            n = n2;
            float f15 = this.realEigenValues[n2];
            for (n6 = n2 + 1; n6 < this.size; ++n6) {
                if (!(this.realEigenValues[n6] < f15)) continue;
                n = n6;
                f15 = this.realEigenValues[n6];
            }
            if (n == n2) continue;
            this.realEigenValues[n] = this.realEigenValues[n2];
            this.realEigenValues[n2] = f15;
            for (n6 = 0; n6 < this.size; ++n6) {
                f15 = this.eigenVectors[n6][n2];
                this.eigenVectors[n6][n2] = this.eigenVectors[n6][n];
                this.eigenVectors[n6][n] = f15;
            }
        }
    }

    public float getEigenvector(int n, int n2) {
        return this.eigenVectors[n][n2];
    }

    public float[][] getEigenvectors() {
        return this.eigenVectors;
    }

    public float[] getRealEigenvalue() {
        return this.realEigenValues;
    }

    public float getRealEigenvalue(int n) {
        return this.realEigenValues[n];
    }

    public float[] getImaginaryEigenValue() {
        return this.imaginaryEigenValues;
    }

    public float getImaginaryEigenValue(int n) {
        return this.imaginaryEigenValues[n];
    }

    public static void main(String[] stringArray) {
        int n;
        float[][] fArray = new float[3][3];
        fArray[0][0] = 2.0f;
        fArray[0][1] = 1.0f;
        fArray[0][2] = 1.0f;
        fArray[1][0] = 1.0f;
        fArray[1][1] = 2.0f;
        fArray[1][2] = 1.0f;
        fArray[2][0] = 1.0f;
        fArray[2][1] = 1.0f;
        fArray[2][2] = 2.0f;
        EigenSystem eigenSystem = new EigenSystem(fArray);
        eigenSystem.tridiagonalReduction();
        eigenSystem.tridiagonalQL();
        eigenSystem.increasingSort();
        System.out.println("eigenvalues = ");
        for (n = 0; n < 3; ++n) {
            System.out.print(eigenSystem.getRealEigenvalue(n) + " ");
        }
        System.out.println();
        System.out.println("eigenvectors = ");
        for (n = 0; n < 3; ++n) {
            for (int i = 0; i < 3; ++i) {
                System.out.print(eigenSystem.getEigenvector(n, i) + " ");
            }
            System.out.println();
        }
    }
}

