/*
 * Decompiled with CFR 0.152.
 */
package jme.math;

import jme.exception.MonkeyRuntimeException;
import jme.math.Vector;

public class Quaternion {
    public float x;
    public float y;
    public float z;
    public float w;

    public Quaternion() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 0.0f;
    }

    public Quaternion(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f4;
    }

    public Quaternion(float[] fArray) {
        this.fromAngles(fArray);
    }

    public Quaternion(Quaternion quaternion, Quaternion quaternion2, float f) {
        this.slerp(quaternion, quaternion2, f);
    }

    public Quaternion(Quaternion quaternion) {
        this.x = quaternion.x;
        this.y = quaternion.y;
        this.z = quaternion.z;
        this.w = quaternion.w;
    }

    public void fromAngles(float[] fArray) {
        float f = fArray[2] * 0.5f;
        float f2 = (float)Math.sin(f);
        float f3 = (float)Math.cos(f);
        f = fArray[1] * 0.5f;
        float f4 = (float)Math.sin(f);
        float f5 = (float)Math.cos(f);
        f = fArray[0] * 0.5f;
        float f6 = (float)Math.sin(f);
        float f7 = (float)Math.cos(f);
        float f8 = f7 * f5;
        float f9 = f6 * f4;
        this.x = f6 * f5 * f3 - f7 * f4 * f2;
        this.y = f7 * f4 * f3 + f6 * f5 * f2;
        this.z = f8 * f2 - f9 * f3;
        this.w = f8 * f3 + f9 * f2;
    }

    public void fromAngleAxis(float f, Vector vector) {
        float f2 = 0.5f * f;
        float f3 = (float)Math.sin(f2);
        this.w = (float)Math.cos(f2);
        this.x = f3 * vector.x;
        this.y = f3 * vector.y;
        this.z = f3 * vector.z;
    }

    public void fromMatrix(float[] fArray, int n) {
        if (fArray == null || n != 3 && n != 4) {
            throw new MonkeyRuntimeException("matrix cannot be null, whilerowColumnCount must be 3 or 4.");
        }
        float[] fArray2 = fArray;
        float[] fArray3 = new float[16];
        if (fArray.length == 9) {
            fArray3[0] = fArray[0];
            fArray3[1] = fArray[1];
            fArray3[2] = fArray[2];
            fArray3[3] = 0.0f;
            fArray3[4] = fArray[3];
            fArray3[5] = fArray[4];
            fArray3[6] = fArray[5];
            fArray3[7] = 0.0f;
            fArray3[8] = fArray[6];
            fArray3[9] = fArray[7];
            fArray3[10] = fArray[8];
            fArray3[11] = 0.0f;
            fArray3[12] = 0.0f;
            fArray3[13] = 0.0f;
            fArray3[14] = 0.0f;
            fArray3[15] = 1.0f;
            fArray2 = fArray3;
        }
        float f = fArray2[0] + fArray2[5] + fArray2[10] + 1.0f;
        float f2 = 0.0f;
        if (f > 1.0E-8f) {
            f2 = (float)Math.sqrt(f) * 2.0f;
            this.x = (fArray2[9] - fArray2[6]) / f2;
            this.y = (fArray2[2] - fArray2[8]) / f2;
            this.z = (fArray2[4] - fArray2[1]) / f2;
            this.w = 0.25f * f2;
        } else if (fArray2[0] > fArray2[5] && fArray2[0] > fArray2[10]) {
            f2 = (float)Math.sqrt(1.0f + fArray2[0] - fArray2[5] - fArray2[10]) * 2.0f;
            this.x = 0.25f * f2;
            this.y = (fArray2[4] + fArray2[1]) / f2;
            this.z = (fArray2[2] + fArray2[8]) / f2;
            this.w = (fArray2[9] - fArray2[6]) / f2;
        } else if (fArray2[5] > fArray2[10]) {
            f2 = (float)Math.sqrt(1.0f + fArray2[5] - fArray2[0] - fArray2[10]) * 2.0f;
            this.x = (fArray2[4] + fArray2[1]) / f2;
            this.y = 0.25f * f2;
            this.z = (fArray2[9] + fArray2[6]) / f2;
            this.w = (fArray2[2] - fArray2[8]) / f2;
        } else {
            f2 = (float)Math.sqrt(1.0f + fArray2[10] - fArray2[0] - fArray2[5]) * 2.0f;
            this.x = (fArray2[2] + fArray2[8]) / f2;
            this.y = (fArray2[9] + fArray2[6]) / f2;
            this.z = 0.25f * f2;
            this.w = (fArray2[4] - fArray2[1]) / f2;
        }
    }

    public float[] toMatrix() {
        float[] fArray = new float[]{1.0f - 2.0f * (this.y * this.y + this.z * this.z), 2.0f * (this.x * this.y - this.w * this.z), 2.0f * (this.x * this.z + this.w * this.y), 0.0f, 2.0f * (this.x * this.y + this.w * this.z), 1.0f - 2.0f * (this.x * this.x + this.z * this.z), 2.0f * (this.y * this.z - this.w * this.x), 0.0f, 2.0f * (this.x * this.z - this.w * this.y), 2.0f * (this.y * this.z + this.w * this.x), 1.0f - 2.0f * (this.x * this.x + this.y * this.y), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        return fArray;
    }

    public float toAngleAxis(Vector vector) {
        float f;
        float f2 = this.x * this.x + this.y * this.y + this.z * this.z;
        if ((double)f2 > 0.0) {
            f = (float)(2.0 * Math.cos(this.w));
            float f3 = (float)(1.0 / Math.sqrt(f2));
            vector.x = this.x * f3;
            vector.y = this.y * f3;
            vector.z = this.z * f3;
        } else {
            f = 0.0f;
            vector.x = 1.0f;
            vector.y = 0.0f;
            vector.z = 0.0f;
        }
        return f;
    }

    public Quaternion slerp(Quaternion quaternion, Quaternion quaternion2, float f) {
        Quaternion quaternion3 = new Quaternion();
        if (quaternion.x == quaternion2.x && quaternion.y == quaternion2.y && quaternion.z == quaternion2.z && quaternion.w == quaternion2.w) {
            return quaternion;
        }
        float f2 = quaternion.x * quaternion2.x + quaternion.y * quaternion2.y + quaternion.z * quaternion2.z + quaternion.w * quaternion2.w;
        if (f2 < 0.0f) {
            quaternion2.x = -quaternion2.x;
            quaternion2.y = -quaternion2.y;
            quaternion2.z = -quaternion2.z;
            quaternion2.w = -quaternion2.w;
            f2 = -f2;
        }
        float f3 = 1.0f - f;
        float f4 = f;
        if (1.0f - f2 > 0.1f) {
            float f5 = (float)Math.acos(f2);
            float f6 = (float)Math.sin(f5);
            f3 = (float)Math.sin((1.0f - f) * f5) / f6;
            f4 = (float)Math.sin(f * f5) / f6;
        }
        quaternion3.x = f3 * quaternion.x + f4 * quaternion2.x;
        quaternion3.y = f3 * quaternion.y + f4 * quaternion2.y;
        quaternion3.z = f3 * quaternion.z + f4 * quaternion2.z;
        quaternion3.w = f3 * quaternion.w + f4 * quaternion2.w;
        this.x = quaternion3.x;
        this.y = quaternion3.y;
        this.z = quaternion3.z;
        this.w = quaternion3.w;
        return quaternion3;
    }

    public Quaternion add(Quaternion quaternion) {
        return new Quaternion(this.x + quaternion.x, this.y + quaternion.y, this.z + quaternion.z, this.w + quaternion.w);
    }

    public Quaternion subtract(Quaternion quaternion) {
        return new Quaternion(this.x - quaternion.x, this.y - quaternion.y, this.z - quaternion.z, this.w - quaternion.w);
    }

    public Quaternion mult(Quaternion quaternion) {
        return new Quaternion(this.w * quaternion.w - this.x * quaternion.x - this.y * quaternion.y - this.z * quaternion.z, this.w * quaternion.x + this.x * quaternion.w + this.y * quaternion.z - this.z * quaternion.y, this.w * quaternion.y + this.y * quaternion.w + this.z * quaternion.x - this.x * quaternion.z, this.w * quaternion.z + this.z * quaternion.w + this.x * quaternion.y - this.y * quaternion.x);
    }

    public Quaternion mult(float f) {
        return new Quaternion(f * this.w, f * this.x, f * this.y, f * this.z);
    }

    public float dot(Quaternion quaternion) {
        return this.w * quaternion.w + this.x * quaternion.x + this.y * quaternion.y + this.z * quaternion.z;
    }

    public float norm() {
        return this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Quaternion inverse() {
        float f = this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z;
        if ((double)f > 0.0) {
            float f2 = 1.0f / f;
            return new Quaternion(this.w * f2, -this.x * f2, -this.y * f2, -this.z * f2);
        }
        return null;
    }

    public void negate() {
        this.x *= -1.0f;
        this.y *= -1.0f;
        this.z *= -1.0f;
        this.w *= -1.0f;
    }

    public static void main(String[] stringArray) {
        Quaternion quaternion = new Quaternion(4.0f, 1.0f, 0.0f, 0.0f);
        float f = 0.0f;
        Vector vector = new Vector();
        f = quaternion.toAngleAxis(vector);
        System.out.println(f);
        System.out.println(vector.toString());
    }
}

