/*
 * Decompiled with CFR 0.152.
 */
package jme.utility;

import java.util.logging.Level;
import jme.utility.LoggingSystem;
import org.lwjgl.Sys;

public class Timer {
    private long frameDiff;
    private static Timer instance = null;
    private long oldTime = 0L;
    private long newTime = 0L;
    private float fps = 0.0f;
    private float minFps;
    private float maxFps;
    private int frameCounter;

    private Timer() {
        Sys.setTime((long)0L);
        Sys.setProcessPriority((int)-1);
        this.minFps = 99999.0f;
        this.maxFps = -1.0f;
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Timer resolution: " + Sys.getTimerResolution() + " ticks per second");
    }

    public float getFrameRate() {
        return this.fps;
    }

    public float getMinFrameRate() {
        return this.minFps;
    }

    public float getMaxFrameRate() {
        return this.maxFps;
    }

    public void setProcessPriority(int n) {
        Sys.setProcessPriority((int)n);
    }

    public void setTime(long l) {
        Sys.setTime((long)l);
    }

    public void update() {
        this.newTime = Sys.getTime();
        this.frameDiff = this.newTime - this.oldTime;
        this.fps = (float)Sys.getTimerResolution() / (float)this.frameDiff;
        this.oldTime = this.newTime;
        if (this.frameCounter > 100) {
            if (this.fps < this.minFps) {
                this.minFps = this.fps;
            } else if (this.fps > this.maxFps) {
                this.maxFps = this.fps;
            }
        } else {
            ++this.frameCounter;
        }
    }

    public static Timer getTimer() {
        if (null == instance) {
            instance = new Timer();
        }
        return instance;
    }

    public String toString() {
        String string = super.toString();
        string = string + "\nTime: " + this.newTime;
        string = string + "\nFPS: " + this.fps;
        return string;
    }
}

