/*
 * Decompiled with CFR 0.152.
 */
package test.general;

import jme.AbstractGame;
import jme.entity.effects.ParticleEmitter;
import jme.entity.effects.ParticleSystem;
import jme.math.Vector;
import jme.system.DisplaySystem;
import jme.utility.Timer;
import org.lwjgl.Display;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLU;
import org.lwjgl.opengl.Window;

public class TestParticleSystem
extends AbstractGame {
    private ParticleSystem ps;
    private Timer timer;

    protected void update() {
        this.timer.update();
        this.ps.update(10.0f / this.timer.getFrameRate());
    }

    protected void render() {
        GL.glClear((int)16640);
        GL.glLoadIdentity();
        this.ps.render();
    }

    protected void initSystem() {
        DisplaySystem.createDisplaySystem("Particles", "data/Images/Monkey.jpg", true);
        GL.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL.glMatrixMode((int)5889);
        GL.glLoadIdentity();
        GLU.gluPerspective((double)45.0, (double)((float)Display.getWidth() / (float)Display.getHeight()), (double)0.01f, (double)750.0);
        GL.glMatrixMode((int)5888);
        GL.glHint((int)3152, (int)4354);
        GL.glDisable((int)2929);
    }

    protected void initGame() {
        this.timer = Timer.getTimer();
        ParticleEmitter pe = new ParticleEmitter(1000);
        pe.setStartColor(new Vector(1.0f, 1.0f, 1.0f));
        pe.setEndColor(new Vector(1.0f, 1.0f, 1.0f));
        pe.setStartSize(new Vector(0.25f, 1.0f, 0.25f));
        pe.setEndSize(new Vector(0.25f, 1.0f, 0.25f));
        pe.setFade(0.01f);
        pe.setSpeed(1.0f);
        pe.setGravity(new Vector(0.0f, -100.0f, 10.0f));
        pe.setFriction(1.0f);
        pe.setTexture("data/texture/star.png");
        pe.loopAnimation(true);
        this.ps = new ParticleSystem();
        this.ps.addEmitter(pe);
        this.ps.setPosition(new Vector(0.0f, 100.0f, -10.0f));
    }

    protected void reinit() {
    }

    protected void cleanup() {
        Window.destroy();
    }

    public static void main(String[] args) {
        TestParticleSystem app = new TestParticleSystem();
        app.start();
    }
}

