/**
 * httpdサーバのサンプルです。
 * ROMにある定義済みファイルの入出力と、クロスドメインRESTが確認できます。
 */
//#define SKETCH_STACK_SIZE
#include "boot/sketch.h"

#include "NyLPC_net.h"
#include "NyLPC_netif.h"
#include "NyLPC_utils.h"
#include "../netif/mimicip/NyLPC_cMiMicIpNetIf.h"
#include "../netif/apipa/NyLPC_cApipa.h"
#include <stdio.h>
#include <string.h>


const struct NyLPC_TiNetInterface_Interface* netif;
void setup(void)
{
	//uipサービス初期化。いろいろ利用可能に。
	netif=NyLPC_cMiMicIpNetIf_getNetInterface();
	NyLPC_cNet_initialize(netif);
}



void loop(void)
{
	NyLPC_TcNetConfig_t c2;
	NyLPC_TcApipa_t apipa;
	//デフォルト設定の呼び出し
	NyLPC_cNetConfig_initialize(&c2,NyLPC_TBool_TRUE);
	//DHCP
	NyLPC_cApipa_initialize(&apipa);
	NyLPC_cApipa_requestAddr(&apipa,&(c2.super),3);
	NyLPC_cNet_start(&(c2.super));
	//受信待ち
	for(;;){
	}
}




