/**
 * DHCPクライアントのサンプルです。
 * DHCPサーバからIPアドレスを受け取ってネットワークを起動します。
 */
#include "boot/sketch.h"

#include "NyLPC_net.h"
#include "NyLPC_utils.h"
#include "../netif/mimicip/NyLPC_cMiMicIpNetIf.h"
#include "../netif/dhcp/NyLPC_cDhcpClient.h"
#include <stdio.h>
#include <string.h>

const struct NyLPC_TiNetInterface_Interface* netif;

void setup(void)
{
	//uipサービス初期化。いろいろ利用可能に。
	netif=NyLPC_cMiMicIpNetIf_getNetInterface();
	NyLPC_cNet_initialize(netif);
}

void loop(void)
{
	NyLPC_TcNetConfig_t c2;
	//デフォルト設定の呼び出し
	NyLPC_cNetConfig_initialize(&c2,NyLPC_TBool_TRUE);
	//DHCP
	NyLPC_cNet_requestAddrDhcp(&(c2.super),3);
	NyLPC_cNet_start(&c2);
	//受信待ち
	for(;;){
	}
}




