/**
 * httpdサーバのサンプルです。
 * ROMにある定義済みファイルの入出力と、クロスドメインRESTが確認できます。
 */
#include "boot/sketch.h"
#include "NyLPC_net.h"
#include "../netif/mimicip/NyLPC_cMiMicIpNetIf.h"
#include "NyLPC_http.h"
#include "NyLPC_utils.h"


const struct NyLPC_TiNetInterface_Interface* netif;
struct MyHttpd{
	NyLPC_TcHttpd_t super;
}httpd;

#define NUM_OF_FSDATA 4
extern struct NyLPC_TRomFileData fsdata[];
char dummy[1000];

void handler(NyLPC_TcHttpdConnection_t* i_connection)
{
	NyLPC_TcModUrl_t mod;
	int i;


	NyLPC_cHttpdConnection_sendResponseHeader2(i_connection,200,"binary/octet-stream",1024*1024*1024,NULL);
	for(i=0;i<1024*1024;i++){
		if(!NyLPC_cHttpdConnection_sendResponseBody(i_connection,dummy,1024))
		{
			break;
		}
	}
	NyLPC_cModUrl_finalize(&mod);
	return;
}
void setup(void)
{
	//uipサービス初期化。いろいろ利用可能に。
	netif=NyLPC_cMiMicIpNetIf_getNetInterface();
	NyLPC_cNet_initialize(netif);
	NyLPC_cHttpd_initialize(&httpd.super,80);
	httpd.super.function.onRequest=handler;

}


void loop(void)
{
	NyLPC_TcNetConfig_t c2;
	NyLPC_cNetConfig_initialize(&c2,NyLPC_TBool_TRUE);
	NyLPC_cNetConfig_setIpAddr(&c2,192,168,128,39);
	NyLPC_cNetConfig_setGateway(&c2,192,168,128,254);
	NyLPC_cNet_start(&c2.super);
	NyLPC_cHttpd_loop(&httpd.super);
	for(;;);
}


