/**
 * UPnP BasicDeviceのサンプルです。
 */
#include "boot/sketch.h"
#include "NyLPC_net.h"

#include "NyLPC_http.h"
#include "NyLPC_utils.h"
#include "../netif/mimicip/NyLPC_cMiMicIpNetIf.h"
struct NyLPC_TUPnPDevDescIcon icon=
{
	"image/png",
	64,
	64,
	24,
	"/rom/icon.png"
};
const struct NyLPC_TUPnPDevDescDevice devdesc=
{
	"urn:schemas-upnp-org:device:Basic:1",			//REQ:device_type
	"MiMicUPnP basic device",		//REQ:frendly_name
	"MiMicProject@nyatla.jp",		//REQ:manufacturer
	"http://nyatla.jp/",			//OPT:manufacturer_url
	NULL,							//REC:model_descriprion
	"MiMicUPnP Device",				//REQ:model_name
	"1",							//REC:model_number
	"http://nyatla.jp/",							//OPT:model_url
	0,												//REC:serial_number
	"uuid:e29f7100-4ba2-11e0-8000-000000000000",	//REQ:udn
	NULL,											//OPT:upc
	/** Recommended*/
	"/rom/index.html",								//REQ:presentation_url
	0,//Number of Device
	0,//Number of Service
	1,//Number of Icon
	0,//padding
	NULL,	//Required if devices;
	NULL,	//Required if services;
	&icon	//Required if icons
};




const struct NyLPC_TiNetInterface_Interface* netif;
struct MyHttpd{
	NyLPC_TcHttpd_t super;
}httpd;

NyLPC_TcNetConfig_t c2;
NyLPC_TcUPnP_t upnp;

#define NUM_OF_FSDATA 2
extern struct NyLPC_TRomFileData fsdata[];

const static char* PATH_rom="rom";
const static char* PATH_upnp="upnp";
void handler(NyLPC_TcHttpdConnection_t* i_connection)
{
	union{
		NyLPC_TcModRomFiles_t rom;
		NyLPC_TcModUPnPDevice_t upnp;
	}mod;

	NyLPC_cModUPnPDevice_initialize(&mod.upnp,&upnp);
	if(NyLPC_cModUPnPDevice_canHandle(&mod.upnp,i_connection)){
		NyLPC_cModUPnPDevice_execute(&mod.upnp,i_connection);
		NyLPC_cModUPnPDevice_finalize(&mod.upnp);
		return;
	}
	NyLPC_cModUPnPDevice_finalize(&mod.upnp);

	NyLPC_cModRomFiles_initialize(&mod.rom,PATH_rom,fsdata,NUM_OF_FSDATA);
	if(NyLPC_cModRomFiles_canHandle(&mod.rom,i_connection)){
		NyLPC_cModRomFiles_execute(&mod.rom,i_connection);
		NyLPC_cModRomFiles_finalize(&mod.rom);
		return;
	}
	NyLPC_cModRomFiles_finalize(&mod.rom);

	return;
}

void setup(void)
{
	//uipサービス初期化。いろいろ利用可能に。
	NyLPC_cNetConfig_initialize(&c2,NyLPC_TBool_TRUE);
	NyLPC_cNetConfig_setIpAddr(&c2,192,168,128,40);
	NyLPC_cNetConfig_setGateway(&c2,192,168,128,254);

	netif=NyLPC_cMiMicIpNetIf_getNetInterface();
	NyLPC_cNet_initialize(netif);
	NyLPC_cHttpd_initialize(&httpd.super,c2.services.http_port);
	NyLPC_cUPnP_initialize(&upnp,c2.services.http_port,PATH_upnp,&devdesc);

	httpd.super.function.onRequest=handler;
}
void loop(void)
{
	NyLPC_cNet_start(&net,&c2);
	NyLPC_cUPnP_start(&upnp);
	NyLPC_cHttpd_loop(&httpd.super);
	for(;;);
}




