/**
 * httpdサーバのサンプルです。
 * ROMにある定義済みファイルの入出力と、クロスドメインRESTが確認できます。
 */
#include "boot/sketch.h"
#include "NyLPC_net.h"

#include "NyLPC_http.h"
#include "NyLPC_utils.h"
#include "../netif/mimicip/NyLPC_cMiMicIpNetIf.h"

const struct NyLPC_TiNetInterface_Interface* netif;
struct MyHttpd{
	NyLPC_TcHttpd_t super;
}httpd;

#define NUM_OF_FSDATA 4
extern struct NyLPC_TRomFileData fsdata[];
char dummy[1000];

NyLPC_TcModWebSocket_t mod;
void handler(NyLPC_TcHttpdConnection_t* i_connection)
{
	NyLPC_TUInt8 buf[16];
	NyLPC_TInt16 l;
	NyLPC_cModWebSocket_initialize(&mod,"ws");
	if(NyLPC_cModWebSocket_canHandle(&mod,i_connection)){
		NyLPC_cModWebSocket_execute(&mod,i_connection);
		//read
		for(;;){
			l=NyLPC_cModWebSocket_read(&mod,buf,16);
			if(l==0){
				continue;
			}
			if(l<0){
				break;
			}
			if(!NyLPC_cModWebSocket_write(&mod,buf,l)){
				break;
			}
			if(!NyLPC_cModWebSocket_writeFormat(&mod,"\nfmt=%d,%s\n",123,"abc")){
				break;
			}
		}
	}
	NyLPC_cModWebSocket_close(&mod,1000);
	NyLPC_cModWebSocket_finalize(&mod);
	return;
}
void setup(void)
{
	//uipサービス初期化。いろいろ利用可能に。
	netif=NyLPC_cMiMicIpNetIf_getNetInterface();
	NyLPC_cNet_initialize(netif);
	NyLPC_cHttpd_initialize(&httpd.super,80);
	httpd.super.function.onRequest=handler;

}


void loop(void)
{
	NyLPC_TcNetConfig_t c2;
	NyLPC_cNetConfig_initialize(&c2,NyLPC_TBool_TRUE);
	NyLPC_cNetConfig_setIpAddr(&c2,192,168,128,39);
	NyLPC_cNetConfig_setGateway(&c2,192,168,128,254);
	NyLPC_cNet_start(&c2.super);
	NyLPC_cHttpd_loop(&httpd.super);
	for(;;);
}


