#include "../hed/hed_common/stl.h"
#include <windows.h>
#include <stdio.h>

#include "../hed/hed_picturelib/filter.h"
#include "../hed/hed_picturelib/plimage.h"
#include "../hed/hed_picturelib/pldata.h"
#include "../hed/hed_picturelib/memorydata.h"
#include "../hed/hed_picturelib/filedata.h"

// VER 0.0.1	b 8bit ̉摜ɑΉ
// VER 0.0.2	24 BIT 摜ɑΉ
// VER 0.0.3	I/F̕ύX

/********************************************************
BITMAP t@CƂăC[WIuWFNgۑ
Ή` 8bit/24bit k Windows ` BITMAP

hImage	: ۑ摜̃C[Wnh
strFile	: ۑt@C
߂l
true	:
false	:s
*********************************************************/
bool __stdcall write_image( CPLImage *pImage, const TCHAR *strFile, const TCHAR *param )
{
	if( !pImage ||
		!strFile )
		return false;

	int width = 0, height = 0, colordepth = 0;
	pImage->GetImageSize( width, height );
	pImage->GetImageColorDepth( colordepth );
	if( ( width == 0 || height == 0 ) || ( colordepth != 8 && colordepth != 24 ) )
		return false;

	FILE *out = _tfopen( strFile, _T("wb") );
	BITMAPFILEHEADER bmfh;
	BITMAPINFOHEADER bmih;
	if( !out )
		return false;

	// wb_̐ݒ
	bmfh.bfType = 0x4D42;
	bmfh.bfSize = 0;
	bmfh.bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);
	bmfh.bfReserved1 = 0;
	bmfh.bfReserved2 = 0;
	bmih.biBitCount = colordepth;
	bmih.biClrImportant = 0;
	bmih.biClrUsed = 0;
	bmih.biCompression = 0;
	bmih.biHeight = height;
	bmih.biPlanes = 1;
	bmih.biSize = sizeof( BITMAPINFOHEADER );
	bmih.biSizeImage = 0;
	bmih.biWidth = width;
	bmih.biXPelsPerMeter = 0;
	bmih.biYPelsPerMeter = 0;
	switch( bmih.biBitCount )
	{
	case 8:
		bmfh.bfOffBits += sizeof(RGBQUAD) * 256;
		break;
	}

	// wb_̏
	fwrite( &bmfh, sizeof( bmfh), 1, out );
	fwrite( &bmih, sizeof( bmih), 1, out );

	// pbgGg[̏
	switch( bmih.biBitCount )
	{
	case 8:
		{
			for( int cur = 0; cur < 256; cur ++ )
			{
				RGBQUAD rgb;
				COLORREF color = RGB( 0, 0, 0 );
				pImage->GetImagePalette( cur, color );
				rgb.rgbRed = GetRValue( color );
				rgb.rgbGreen = GetGValue( color );
				rgb.rgbBlue = GetBValue( color );
				rgb.rgbReserved = 0;
				fwrite( &rgb, sizeof( RGBQUAD), 1, out );
			}
		}
		break;
	}
	
	// 摜f[^̏
	unsigned char *pImageBuffer = NULL;
	switch( bmih.biBitCount )
	{
	case 8:
		{
			pImageBuffer = new unsigned char[( bmih.biWidth + 3 ) & ~3];
			memset( pImageBuffer, 0x00, ( bmih.biWidth + 3 ) & ~3 );
			for( int h = height - 1; h >= 0; h -- )
			{
				for( int w = 0; w < width; w ++ )
				{
					unsigned char pixel = 0;
					pImage->GetImagePixel( w, h, pixel );
					pImageBuffer[w] = pixel;
				}
				fwrite( pImageBuffer, ( bmih.biWidth + 3 ) & ~3, 1, out );
			}
			delete[] pImageBuffer;
		}
		break;
	case 24:
		{
			pImageBuffer = new unsigned char[ ( bmih.biWidth * 3 + 3) & ~3 ];
			memset( pImageBuffer, 0x00, sizeof( unsigned char ) * ( ( bmih.biWidth * 3 + 3) & ~3 ) );
			for( int h = height - 1; h >= 0; h -- )
			{
				for( int w = 0; w < bmih.biWidth; w ++ )
				{
					COLORREF Pixel = RGB( 0, 0, 0 );
					pImage->GetImagePixel( w, h, Pixel );
					pImageBuffer[ w * 3 ] = GetBValue( Pixel );
					pImageBuffer[ w * 3 + 1 ] = GetGValue( Pixel );
					pImageBuffer[ w * 3 + 2 ] = GetRValue( Pixel );
				}
				fwrite( pImageBuffer, ( bmih.biWidth * 3 + 3 ) & ~3, 1, out);
			}
			delete pImageBuffer;
		}
		break;
	}
	fclose( out );
	return true;
}

bool __stdcall create_bmp_header_image( CPLImage &ImageSource, CPLMemoryData &headerResult )
{
	int width = 0, height = 0, colordepth = 0;
	ImageSource.GetImageColorDepth( colordepth );
	ImageSource.GetImageSize( width, height );
	if( width <= 0 || height <= 0 || ( colordepth != 8 && colordepth != 24 ) )
		return false;

	BITMAPINFO *pInfo = NULL;
	unsigned char *pBits = NULL;
	int nSize = 0;

	if( colordepth == 8 )
		nSize = sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 256 ;
	else
		nSize = sizeof(BITMAPINFOHEADER);
	pInfo = (BITMAPINFO*)::PL_Malloc( nSize, true );
	headerResult.attach( pInfo, CPLMemoryData::E_DATA_MEMORY_PL );

	if( colordepth == 8 )
		pInfo->bmiHeader.biBitCount = 8;
	else
		pInfo->bmiHeader.biBitCount = 24;
	pInfo->bmiHeader.biHeight = height;
	pInfo->bmiHeader.biWidth = width;
	pInfo->bmiHeader.biPlanes = 1;
	pInfo->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	if ( colordepth == 8 )
	{
		RGBQUAD rgbPalette ;
		rgbPalette.rgbReserved = 0;
		COLORREF crPalette = RGB( 0, 0, 0 );
		for( int cnt = 0; cnt < 256; cnt ++ )
		{
			ImageSource.GetImagePalette( cnt, crPalette );
			rgbPalette.rgbBlue = GetBValue( crPalette );
			rgbPalette.rgbGreen = GetGValue( crPalette );
			rgbPalette.rgbRed = GetRValue( crPalette );
			pInfo->bmiColors[cnt] = rgbPalette;
		}
	}
	return true;
}

bool __stdcall make_memory_image( CPLImage &ImageSource, CPLMemoryData &headerTarget, CPLMemoryData &pixelTarget )
{
	int width = 0, height = 0, colordepth = 0;
	ImageSource.GetImageColorDepth( colordepth );
	ImageSource.GetImageSize( width, height );
	if( width <= 0 || height <= 0 || ( colordepth != 8 && colordepth != 24 ) )
		return false;
	
	create_bmp_header_image( ImageSource, headerTarget );

	unsigned char *pBits = NULL;
	if( colordepth == 8 )
		pBits = (unsigned char*) ::PL_Malloc( ( ( width + 3 ) & ~3 ) * height, true );
	else
		pBits = (unsigned char*) ::PL_Malloc( ( ( ( width + 3 ) * 3 ) & ~3 ) * height, true );
	pixelTarget.attach( pBits, CPLMemoryData::E_DATA_MEMORY_PL );

	if (colordepth == 8 )
	{
		unsigned char *pResult = NULL;
		for( int h = 0; h < height; h ++ )
		{
			ImageSource.GetImageLine( h, (const unsigned char** const)&pResult, TRUE );
			memcpy( pBits + ( ( height - h - 1 ) * ( ( width + 3 ) & ~3 ) ), pResult, width );
		}
		::PL_Free( pResult );
	}
	else
	{
		COLORREF *pResult = NULL;
		for( int h = 0; h < height; h ++ )
		{
			unsigned char *pCurrentBit = pBits + ( ( width * 3 + 3 ) & ~3 ) * ( height - h - 1 );
			ImageSource.GetImageLine( h, (const unsigned char** const)(&pResult), TRUE );
			for( int w = 0; w < width; w ++ )
			{
				COLORREF cr = pResult[w];
				*(pCurrentBit++) = GetBValue( cr );
				*(pCurrentBit++) = GetGValue( cr );
				*(pCurrentBit++) = GetRValue( cr );
			}
		}
		::PL_Free( pResult );
	}
	return true;
}

bool __stdcall make_memory_image_rect( CPLImage &ImageSource, int nLeft, int nTop, int nWidth, int nHeight, CPLMemoryData &headerTarget, CPLMemoryData &pixelTarget )
{
	int width = 0, height = 0, colordepth = 0;
	ImageSource.GetImageColorDepth( colordepth );
	ImageSource.GetImageSize( width, height );
	if( width <= 0 || height <= 0 || ( colordepth != 8 && colordepth != 24 ) )
		return false;
	if( nLeft < 0 || nWidth < 0 || nTop < 0 || nHeight < 0 )
		return false;
	if( nLeft + nWidth > width || nTop + nHeight > height )
		return false;

	create_bmp_header_image( ImageSource, headerTarget );
	BITMAPINFO *pInfo = (BITMAPINFO*)headerTarget.get_ptr();
	pInfo->bmiHeader.biWidth = nWidth;
	pInfo->bmiHeader.biHeight = nHeight;

	unsigned char *pBits = NULL;
	if( colordepth == 8 )
		pBits = (unsigned char*) ::PL_Malloc( ( ( nWidth + 3 ) & ~3 ) * nHeight, true );
	else
		pBits = (unsigned char*) ::PL_Malloc( ( ( ( nWidth + 3 ) * 3 ) & ~3 ) * nHeight, true );
	
	ImageSource.BeginAccessLines( nTop, nTop + nHeight );
	if (colordepth == 8 )
	{
		unsigned char *pResult = NULL;
		for( int h = 0; h < nHeight; h ++ )
		{
			ImageSource.GetImageLine( nTop + h, (const unsigned char** const)&pResult, TRUE );
			memcpy( pBits + ( ( nHeight - h - 1 ) * ( ( nWidth + 3 ) & ~3 ) ), pResult + nLeft, nWidth );
		}
		::PL_Free( pResult );
	}
	else
	{
		COLORREF *pResult = NULL;
		for( int h = 0; h < nHeight; h ++ )
		{
			unsigned char *pCurrentBit = pBits + ( ( nWidth * 3 + 3 ) & ~3 ) * ( nHeight - h - 1 );
			ImageSource.GetImageLine( nTop + h, (const unsigned char** const)(&pResult), TRUE );
			if( pResult )
			{
				for( int w = nLeft; w < nLeft + nWidth; w ++ )
				{
					COLORREF cr = pResult[w];
					*(pCurrentBit++) = GetBValue( cr );
					*(pCurrentBit++) = GetGValue( cr );
					*(pCurrentBit++) = GetRValue( cr );
				}
			}
		}
		::PL_Free( pResult );
	}
	ImageSource.EndAccessLines( );

	pixelTarget.attach( pBits, CPLMemoryData::E_DATA_MEMORY_PL );
	return true;
}
