#include "../hed/hed_common/stl.h"

#include <stdio.h>

#include "./libjpeg/cdjpeg.h"		/* Common decls for cjpeg/djpeg applications */
#include "./libjpeg/jversion.h"		/* for version message */

#include "../hed/hed_picturelib/filter.h"
#include "../hed/hed_picturelib/plimage.h"
#include "../hed/hed_picturelib/memorydata.h"

#define JMESSAGE(code,string)	string ,

static const char * const cdjpeg_message_table[] = {
#include "./libjpeg/cderror.h"
  NULL
};


typedef struct _plimage_source_struct 
{
	struct cjpeg_source_struct pub;
	JDIMENSION source_row;
}
plimage_source_struct;


static
void start_input(j_compress_ptr cinfo,
	cjpeg_source_ptr sinfo)
{
	plimage_source_struct *source = ( plimage_source_struct * ) sinfo;
	CPLImage *plImage = 
		( CPLImage * )sinfo->input_file;

	int width = 0, height = 0;
	plImage->GetImageSize( width, height );
	cinfo->input_components = 3;
	cinfo->data_precision = 8;
	cinfo->image_width = width;
	cinfo->image_height = height;

	sinfo->buffer = (*cinfo->mem->alloc_sarray)
		((j_common_ptr) cinfo, JPOOL_IMAGE,
		(JDIMENSION) width * 3, (JDIMENSION) 1);
	sinfo->buffer_height = 1;
}

JDIMENSION get_pixel_rows(j_compress_ptr cinfo,
	cjpeg_source_ptr sinfo)
{
	plimage_source_struct *source = ( plimage_source_struct * ) sinfo;
	CPLImage *plImage = 
		( CPLImage * )sinfo->input_file;

	register JSAMPROW inptr, outptr;
	register JDIMENSION col;

	unsigned char *result = NULL;
	plImage->GetImageLine( source->source_row ++, &result, FALSE );

	inptr = result;
	outptr = source->pub.buffer[0];
	for (col = cinfo->image_width; col > 0; col--) {
		outptr[0] = *inptr++;
		outptr[1] = *inptr++;
		outptr[2] = *inptr++;
		inptr++;
		outptr += 3;
	}
	::PL_Free( result );
	return 1;
}

void finish_input(j_compress_ptr cinfo,
	cjpeg_source_ptr sinfo)
{
}

bool __stdcall write_image( CPLImage *pImage, char *strFile, char *param )
{
	if( !pImage ||
		!strFile )
		return false;

	struct jpeg_compress_struct cinfo;
	struct jpeg_error_mgr jerr;
	JDIMENSION num_scanlines = 0;

	plimage_source_struct * src_mgr = NULL;
	FILE * output_file = 
		output_file = fopen( strFile, "wb" );
	if( output_file == NULL )
		return false;

	// initialize jpeg struct.
	cinfo.err = jpeg_std_error(&jerr);
	jpeg_create_compress(&cinfo);
	cinfo.in_color_space = JCS_RGB;
	jpeg_set_defaults(&cinfo);
	
	// initialize input
	src_mgr = 
		( plimage_source_struct * )(*cinfo.mem->alloc_small) ( 
			(j_common_ptr) &cinfo,
			JPOOL_IMAGE,
			sizeof( struct _plimage_source_struct ) );
	src_mgr->pub.input_file = (FILE*)pImage;
	src_mgr->pub.start_input = start_input;
	src_mgr->pub.get_pixel_rows = get_pixel_rows;
	src_mgr->pub.finish_input = finish_input;
	src_mgr->source_row = 0;

	// initialize output
	jpeg_stdio_dest( &cinfo, output_file );

	// initialize compress
	(*src_mgr->pub.start_input) (&cinfo, (cjpeg_source_ptr)src_mgr);
	jpeg_default_colorspace(&cinfo);
	jpeg_stdio_dest(&cinfo, output_file);
	jpeg_start_compress(&cinfo, TRUE);

	// do compress
	while (cinfo.next_scanline < cinfo.image_height) 
	{
		num_scanlines = (*src_mgr->pub.get_pixel_rows) (&cinfo, (cjpeg_source_ptr)src_mgr);
		(void) jpeg_write_scanlines(&cinfo, src_mgr->pub.buffer, num_scanlines);
	}
	
	// terminate compress 
	(*src_mgr->pub.finish_input) (&cinfo, (cjpeg_source_ptr)src_mgr);
	jpeg_finish_compress(&cinfo);

	// terminate output
	fclose(output_file);

	// terminate jpeg
	jpeg_destroy_compress(&cinfo);
	
	return true;
}

bool __stdcall make_memory_image( CPLImage &ImageSource, CPLMemoryData &headerTarget, CPLMemoryData &pixelTarget )
{
	return false;
}

bool __stdcall make_memory_image_rect( CPLImage &ImageSource, int nLeft, int nTop, int nWidth, int nHeight, CPLMemoryData &headerTarget, CPLMemoryData &pixelTarget )
{
	return false;
}
