#include <tchar.h>
#include "../hed/hed_common/stl.h"
#include "../hed/hed_picturelib/filter.h"
#include "../hed/hed_picturelib/plimage.h"

CPLImage::CPLImage(void)
{
	memset( m_ObjectName, 0x00, MAX_PATH );
}

CPLImage::~CPLImage(void)
{
}

// \zE
CPLImage *CPLImage::Create( )
{
	return NULL;
}

void CPLImage::Destroy( CPLImage *hImage )
{
	delete hImage;
}

void CPLImage::init( )
{
	m_Width = 0;
	m_Height = 0;
	m_ColorDepth = 0;
	memset( m_Palette, 0x00, sizeof(COLORREF) * 256);
	memset( m_ObjectName, 0x00, MAX_PATH );
}

// 
bool __fastcall CPLImage::CreateImage( TCHAR *strImageName )
{
	if( !strImageName )
		return false;
	if( HasObject() )
		return false;

	init( );
	_tcsncpy( m_ObjectName, strImageName, MAX_PATH );
	return true;
}

bool __fastcall CPLImage::CreateImage( TCHAR *strImageName, int width, int height, int colordepth )
{
	if( !strImageName )
		return false;
	if( HasObject() )
		return false;
	if( width <= 0 || height <= 0 || ( colordepth != 8 && colordepth != 24 ) )
		return false;

	CreateImage( strImageName );
	m_Width = width;
	m_Height = height;
	m_ColorDepth = colordepth;
	memset( m_Palette, 0x00, sizeof(COLORREF) * 256);

	return true;
}

bool __fastcall CPLImage::RenewalImage( int width, int height, int colordepth )
{
	TCHAR chObjectName[MAX_PATH];
	_tcsncpy( chObjectName, m_ObjectName, MAX_PATH );
	if( _tcslen( m_ObjectName ) == 0 )
		return false;
	if( width <= 0 || height <= 0 || ( colordepth != 8 && colordepth != 24 ) )
		return false;

	DestroyImage( );
	return CreateImage( chObjectName, width, height, colordepth );
}

// 
bool __fastcall CPLImage::Copy( CPLImage &out )
{
	int width = 0, height = 0, colordepth = 0;

	GetImageSize( width, height );
	GetImageColorDepth( colordepth );
	out.RenewalImage( width, height, colordepth );
	
	if( colordepth == 8 )
	{
		for( int idx = 0; idx < 256; idx ++ )
		{
			COLORREF cr = RGB( 0, 0, 0 );
			GetImagePalette( idx, cr );
			out.SetImagePalette( idx, cr );
		}
	}

	for( int h = 0; h < height; h ++ )
	{
		for( int w = 0; w < width; w ++ )
		{
			if( colordepth == 8 )
			{
				unsigned char idx = 0;
				GetImagePixel( w, h, idx );
				out.SetImagePixel( w, h, idx );
			}
			else
			{
				COLORREF cr = RGB( 0, 0, 0 );
				GetImagePixel( w, h, cr );
				out.SetImagePixel( w, h, cr );
			}
		}
	}

	return true;
}

// 擾
bool __fastcall CPLImage::GetImageSize( int &width, int &height )
{
	if( HasObject() )
	{
		width = m_Width;
		height = m_Height;
		return true;
	}
	else
	{
		width = 0;
		height = 0;
		return false;
	}
}

bool __fastcall CPLImage::GetImageColorDepth( int &colordepth )
{
	if( HasObject() )
	{
		colordepth = m_ColorDepth;
		return true;
	}
	else
	{
		colordepth = 0;
		return false;
	}
}

bool __fastcall CPLImage::GetImagePalette( int nIndex, COLORREF &crPalette )
{
	if( HasObject() && m_ColorDepth == 8 && nIndex >= 0 && nIndex < 256 )
	{
		crPalette = m_Palette[nIndex];
		return true;
	}
	else
	{
		crPalette = RGB( 0, 0, 0 );
		return false;
	}
}

bool __fastcall CPLImage::GetObjectName( TCHAR *strResult, int nLength )
{
	if( !strResult || nLength < 0 )
		return false;
	_tcsncpy( strResult, m_ObjectName, nLength );
	return true;
}

// ݒ
bool __fastcall CPLImage::SetImagePalette( int nIndex, COLORREF crPalette )
{
	if( !HasObject( ) )
		return false;

	m_Palette[nIndex] = crPalette;
	return true;
}

bool __fastcall CPLImage::GetBlock(int nLeft, int nTop, int nWidth, int nHeight, CPLImage *pResult)
{
	if( pResult == NULL || pResult == this )
		return false;
	int curWidth = 0, curHeight = 0, curColorDepth = 0;
	GetImageSize( curWidth, curHeight );
	GetImageColorDepth( curColorDepth );

	if( curWidth == 0 || curHeight == 0 || !( curColorDepth == 8 || curColorDepth == 24 ) )
		return false;
	if( nLeft < 0 || nTop < 0 || nWidth <= 0 || nHeight <= 0 )
		return false;
	if( nLeft + nWidth > curWidth || nTop + nHeight > curHeight )
		return false;

	bool bResult = pResult->RenewalImage( nWidth, nHeight, curColorDepth );
	if( !bResult )
		return false;

	if ( curColorDepth == 8 )
	{
		COLORREF crPalette = RGB( 0, 0, 0 );
		for( int cnt = 0; cnt < 256; cnt ++ )
		{
			GetImagePalette( cnt, crPalette );
			pResult->SetImagePalette( cnt, crPalette );
		}
	}
	
	BeginAccessLines( nTop, nTop + nHeight );
	for( int cnt = 0; cnt < nHeight; cnt ++ )
	{
		unsigned char *pResultBits = NULL;
		GetImageLine( cnt + nTop, &pResultBits, TRUE );
		if( curColorDepth == 8 )
			pResult->SetImageLine( cnt, pResultBits + nLeft );
		else if( curColorDepth == 24 )
			pResult->SetImageLine( cnt, pResultBits + nLeft * sizeof( COLORREF ) );
		::PL_Free( pResultBits );
	}
	EndAccessLines( );

	return true;
}
