#include "../hed/hed_common/stl.h"
#include "../hed/hed_susie/susiepicture.h"
#include "../hed/hed_picturelib/pldata.h"
#include "../hed/hed_picturelib/memorydata.h"
#include "../hed/hed_picturelib/filedata.h"
#include "../hed/hed_picturelib/filter.h"

CSusiePicture::CSusiePicture(void)
{
}

CSusiePicture::~CSusiePicture(void)
{
}

bool CSusiePicture::Initialize( const TCHAR * const strPluginName)
{
	return CPluginObject::Initialize( strPluginName );
}

bool CSusiePicture::TestPlugin( )
{
	bool bUnload = false;
	bool bResult = false;

	if( m_hInstance == NULL )
	{
		LoadPluginObject( );
		bUnload = true;
	}

	do
	{
		if( !m_fpGetPluginInfo  ||
			!m_fpIsSupported )
			break;

		char chBuffer[ 256 ] = "";
		int nResult = GetPluginInfo( m_fpGetPluginInfo, 0, chBuffer, 256 );
		if( nResult <= 0 || strcmp( chBuffer, "00IN" ) )
			break;

		if( !m_fpGetPictureInfo ||
			!m_fpGetPicture )
			break;
		bResult = true;
	}while( false );

	if( bUnload != false )
		UnloadPluginObject( );

	return bResult;
}

bool CSusiePicture::GetPictureInformation( CPLData *pData, int &width, int &height, int &colordepth )
{
	if( pData == NULL )
		return false;

	PictureInfo Info;
	memset( &Info, 0x00, sizeof( PictureInfo ) );
	int nResult = -1;
	
	width = 0;
	height = 0;
	colordepth = 0;

	bool bUnload = false;
	if( !m_hInstance )
	{
		if( !LoadPluginObject() || !TestPlugin() )
		{
			UnloadPluginObject( );
			return false;
		}
		bUnload = true;
	}

	if( pData->is_file() )
	{
		CPLFileData *pFile = pData->get_file( );
		if( pFile )
		{
			TCHAR buffer[MAX_PATH];
			pFile->get_name( buffer, MAX_PATH );
			nResult = GetPictureInfo( m_fpGetPictureInfo, buffer, 0, 0, &Info );
			if( nResult != 0 )
			{
				nResult = GetPictureInfo( m_fpGetPictureInfo, buffer, 128, 0, &Info );
			}
		}
	}
	else if( pData->is_memory() )
	{
		CPLMemoryData *pMemory = pData->get_memory( );
		if( pMemory )
		{
			nResult = GetPictureInfo( m_fpGetPictureInfo, pMemory->get_ptr(), pMemory->get_size(), 1, &Info );
		}
	}
	if( nResult == 0 )
	{
		width = Info.width;
		height = Info.height;
		colordepth = Info.colorDepth;
		if( Info.hInfo )
		{
			CPLMemoryData *pOptional = CPLMemoryData::create();
			pOptional->attach( Info.hInfo, CPLMemoryData::E_DATA_MEMORY_LA );
			pOptional->destroy();
			CPLMemoryData::destroy( pOptional );
		}
	}

	if( bUnload )
		UnloadPluginObject( );
	return nResult == 0;
}

bool CSusiePicture::DecodePicture( CPLData *pData, CPLImage *pImageResult, CALLBACKPROGRESS_SUSIE callback, int lParam )
{
	if( !pData || !pImageResult )
		return false;

	if( !callback ) 
		callback = CPluginObject::SusieDefaultCallBack;

	int nResult = 0;
	bool bUnload = false;
	if( !m_hInstance )
	{
		if( !LoadPluginObject() || !TestPlugin() )
		{
			UnloadPluginObject( );
			return false;
		}
		bUnload = true;
	}

	CPLMemoryData *pbmH = NULL, *pbmBit = NULL;
	HANDLE pHBInfo = NULL;
	HANDLE pHBM = NULL;
	if( pData->is_file() )
	{
		CPLFileData *pFile = pData->get_file( );
		if( pFile )
		{
			TCHAR buffer[MAX_PATH] = _T("");
			pFile->get_name( buffer, MAX_PATH );
			nResult = ::GetPicture( m_fpGetPicture, 
				convertWideCharToMultiByte( buffer ).c_str(), 0, 0, &pHBInfo, &pHBM, (FARPROC)callback, lParam );
			if( nResult != 0 )
			{
				nResult = ::GetPicture( m_fpGetPicture,
					convertWideCharToMultiByte( buffer ).c_str(), 128, 0, &pHBInfo, &pHBM, (FARPROC)callback, lParam );
			}
		}
	}
	else if( pData->is_memory() )
	{
		CPLMemoryData *pMemory = pData->get_memory( );
		if( pMemory )
		{
			nResult = GetPicture( m_fpGetPicture, (LPSTR)pMemory->get_ptr(), pMemory->get_size(), 1, &pHBInfo, &pHBM, (FARPROC)callback, lParam );
		}
	}
	if( !nResult && pHBInfo && pHBM )
	{
		pbmH = CPLMemoryData::create( pHBInfo, CPLMemoryData::E_DATA_MEMORY_LA );
		pbmBit = CPLMemoryData::create( pHBM, CPLMemoryData::E_DATA_MEMORY_LA );
		attach_memory_image( pbmH->get_ptr(), pbmBit->get_ptr(), *pImageResult );
		CPLMemoryData::destroy( pbmH );
		CPLMemoryData::destroy(pbmBit );
	}

	if( bUnload )
		UnloadPluginObject( );
	return nResult == 0;
}
