#include "../hed/hed_common/stl.h"
//#include <windows.h>
#include <stdlib.h>
#include <time.h>
#include <mbstring.h>
#include "../hed/hed_picturelib/pldata.h"
#include "../hed/hed_picturelib/filedata.h"
#include "../hed/hed_susie/susie.h"
#include "../hed/hed_susie/susiepluginarray.h"
#include "../hed/hed_susie/pluginobject.h"

CSusiePluginArray *CSusiePluginArray::m_pPluginArray = NULL;

struct FIND_PLUGIN_HANDLE
{
	CPLData *pData;
	vector < CPluginObject *>::iterator it;
	bool bExtSearch;
};

CSusiePluginArray::CSusiePluginArray(void)
{
	CPluginObject *pObject = CPluginObject::CreateObject( _T("bmp_import.iplg") );
	if( pObject )
		m_arrayPlugin.push_back( pObject );
}

CSusiePluginArray::~CSusiePluginArray(void)
{
	remove_all_plugin_files();
}

bool CSusiePluginArray::add_plugin_file( const TCHAR * const strPathName )
{
	CPluginObject *pObject = CPluginObject::CreateObject( strPathName );
	if( pObject )
		m_arrayPlugin.push_back( pObject );
	return pObject != NULL;
}

int CSusiePluginArray::add_plugin_files( const TCHAR * const strSearchPath )
{
	if( !strSearchPath )
		return 0;
	size_t nLength = _tcslen( strSearchPath );
	if( nLength == 0 )
		return 0;

	TCHAR strPath[MAX_PATH];
	_tcsncpy( strPath, strSearchPath, MAX_PATH );
	WIN32_FIND_DATA wfd;
	memset( &wfd, 0x00, sizeof(wfd) );

	if( strPath[nLength-1] != _T('\\') ||
		( nLength > 1 && _ismbblead( strPath[nLength-2] ) ) )
	{
		_tcsncat( strPath, _T("\\"), MAX_PATH );
		nLength ++;
	}
	_tcsncat( strPath, _T("*.*"), MAX_PATH );

	int nCount = 0;
	HANDLE hFind = ::FindFirstFile( strPath, &wfd );
	if( hFind != INVALID_HANDLE_VALUE )
	{
		BOOL bResult = TRUE;
		while( bResult )
		{
			if( !(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) )
			{
				TCHAR strFullPathName[MAX_PATH];
				_tcsncpy( strFullPathName, strPath, nLength );
				strFullPathName[nLength] = _T('\0');
				_tcscat( strFullPathName, wfd.cFileName );
				if ( add_plugin_file( strFullPathName ) )
					nCount ++;
			}
			bResult = ::FindNextFile( hFind, &wfd );
		}
	}
	return nCount;
}

std::wstring CSusiePluginArray::get_file_dlg_filter_string( )
{
	vector<CPluginObject*>::iterator it;
	vector<std::wstring>::iterator its;
	vector<std::wstring> vBuffer;
	std::wstring strResult = _T("");
	for( it = m_arrayPlugin.begin(); it != m_arrayPlugin.end(); it ++ )
	{
		vBuffer.push_back(  (*it)->GenFileTypeString() );
	}
	sort(vBuffer.begin(), vBuffer.end() );
	strResult += _T("ׂẴt@C(*.*)|*.*|");
	for( its = vBuffer.begin(); its !=vBuffer.end(); its ++ )
	{
		strResult += (*its);
	}
	strResult += _T("|||");
	std::wstring::iterator it2;
	for( it2 = strResult.begin(); it2 != strResult.end(); it2 ++ )
	{
		if( *it2 == _T('|') )
			*it2 = _T('\0');
	}
	return strResult;
}

void *CSusiePluginArray::find_plugin_first( CPLData *pData, CPluginObject **pObject, bool bSearchByExt )
{
	vector<CPluginObject*>::iterator it;
	FIND_PLUGIN_HANDLE *fph = new FIND_PLUGIN_HANDLE;
	fph->pData = pData;
	fph->it = m_arrayPlugin.begin();
	fph->bExtSearch = bSearchByExt;

	return find_plugin_next( fph, pData, pObject );
}

void *CSusiePluginArray::find_plugin_next( void *hFind, CPLData *pData, CPluginObject **pObject )
{
	if( !hFind )
		return NULL;
	vector<CPluginObject*>::iterator it;
	FIND_PLUGIN_HANDLE *fph = ( FIND_PLUGIN_HANDLE* )hFind;

	for( it = fph->it; it != m_arrayPlugin.end(); it ++ )
	{
		if( fph->bExtSearch )
		{
			CPLFileData *file =
				pData->get_file();
			if( file == NULL )
			{
				it = m_arrayPlugin.end();
				break;
			}
			else
			{
				TCHAR name[_MAX_PATH];
				TCHAR fname[_MAX_EXT];
				TCHAR fext[_MAX_EXT];
				TCHAR* targetPtnOrignal = 
					( TCHAR* )malloc( _MAX_PATH * sizeof( TCHAR ) ), *targetPtn = NULL;
				file->get_name( name, _MAX_PATH );
				_tcslwr( name );
				_tsplitpath( name, NULL, NULL, fname, fext );
				_tcscpy( name, fname );
				_tcscat( name, fext );

				bool bExtFound = false;
				int count = 0;
				do
				{
					std::wstring strType = _T(""), strExt = _T("");
					bExtFound = 
						(*it)->GetExtSetting( count, strType, strExt );
					if( bExtFound )
					{
						_tcscpy( targetPtnOrignal, strExt.c_str() );
						_tcslwr( targetPtnOrignal );
						targetPtn = _tcstok( targetPtnOrignal, _T(";") );
						while( targetPtn != NULL )
						{
							if( StrMatch( targetPtn, name ) )
								break;
							targetPtn = _tcstok( NULL, _T(";") );
						}
						if( targetPtn != NULL )
							break;
						count ++;
					}
				} while( bExtFound );
				free( targetPtnOrignal );
				if( !bExtFound )
					continue;
			}
		}
		if( (*it)->IsSupported( pData ) )
			break;
	}
	if( it != m_arrayPlugin.end() )
	{
		*pObject = *it;
		fph->it = ++it;
	}
	else
	{
		find_plugin_close( fph );
		fph = NULL;
		*pObject = NULL;
	}
	return (void*)fph;
}

void CSusiePluginArray::get_plugin_object( void *hPlugin, CPluginObject **pPlugin )
{
	if( !hPlugin || !pPlugin )
		return;
	FIND_PLUGIN_HANDLE *fph = ( FIND_PLUGIN_HANDLE* )hPlugin;
	*pPlugin = *(fph->it);
}

void CSusiePluginArray::find_plugin_close( void *hFind )
{
	delete ( FIND_PLUGIN_HANDLE* )hFind;
}

void CSusiePluginArray::remove_all_plugin_files(void)
{
	vector<CPluginObject*>::iterator it;
	for( it = m_arrayPlugin.begin(); it != m_arrayPlugin.end(); it ++ )
	{
		CPluginObject::DestroyObject( *it );
	}
	m_arrayPlugin.clear();
}

bool CSusiePluginArray::StrMatch( const TCHAR *ptn, const TCHAR *str )
{
	switch( *ptn )
	{
	case _T('\0'):
		return _T('\0') == *str;
	case _T('*'):
		return StrMatch( ptn+1, str ) || ((_T('\0') != *str) && StrMatch( ptn, str+1 ));
	case _T('?'):
		return (_T('\0') != *str) && StrMatch( ptn+1, str+1 );
	default:
		return ((unsigned char)*ptn==(unsigned char)*str) && StrMatch( ptn+1, str+1 );
	}
}

