﻿using UnityEngine;
using UnityEditor;
using System.Collections;
using System.Collections.Generic;
using System.IO;

public class MMDLoaderScript : MonoBehaviour {

	//--------------------------------------------------------------------------------
	// ファイル読み込み
	
	public Object pmd;
	public Object vmd;
	
	BinaryReader LoadFile(Object obj, string path) {
		FileStream f = new FileStream(path, FileMode.Open, FileAccess.Read);
		BinaryReader r = new BinaryReader(f);
		return r;
	}
		
	// PMDファイル読み込み
	void LoadPMDFile() {
		string path = AssetDatabase.GetAssetPath(this.pmd);
		BinaryReader bin = this.LoadFile(this.pmd, path);
		BurnUnityFormatForPMD(MMD.PMD.PMDLoader.Load(bin, gameObject, path));
		bin.Close();
	}
	
	// VMDファイル読み込み
	void LoadVMDFile() {
		string path = AssetDatabase.GetAssetPath(this.vmd);
		BinaryReader bin = this.LoadFile(this.vmd, path);
		BurnUnityFormatForVMD(MMD.VMD.VMDLoader.Load(bin, path));
		bin.Close();
	}
	
	// Use this for initialization
	void Start () {
		if (this.pmd != null) {
			LoadPMDFile();
		}
		if (this.vmd != null) {
			LoadVMDFile();
		}
	}
	
	//--------------------------------------------------------------------------------
	// PMDファイルの読み込み
	
	public Mesh mesh;
	public Material[] materials;
	public GameObject[] bones;
	
	void CreatePrefab(MMD.PMD.PMDFormat format)
	{
		Object prefab = EditorUtility.CreateEmptyPrefab(format.folder + "/" + format.name + ".prefab");
		EditorUtility.ReplacePrefab(format.caller, prefab);
	}
	
	void EndOfScript(MMD.PMD.PMDFormat format)
	{
		AssetDatabase.Refresh();
		DestroyImmediate(gameObject);
		DestroyImmediate(format.caller);
		
		this.mesh = null;
		this.materials = null;
		this.bones = null;
		this.pmd = null;
		this.vmd = null;
	}
		
	// PMDファイルをUnity形式に変換
	void BurnUnityFormatForPMD(MMD.PMD.PMDFormat format) {
		GameObject obj = new GameObject(format.name);
		format.caller = obj;
		
		MMD.PMD.PMDConverter conv = new MMD.PMD.PMDConverter();
		
		this.mesh = conv.CreateMesh(format);
		this.materials = conv.CreateMaterials(format);
		this.bones = conv.CreateBones(format);
		
		conv.BuildingBindpose(format, this.mesh, this.materials, this.bones);
		CreatePrefab(format);
		EndOfScript(format);
	}
	
	//--------------------------------------------------------------------------------
	// VMDファイルの読み込み
	
	void BurnUnityFormatForVMD(MMD.VMD.VMDFormat format) {
		
	}
}
