/*******************************************************************************
 * booter/protected_mode/idt.c
 *                                                                   2012/10/05
 * Copyright (C) 2012 Mochi
 ******************************************************************************/
#include <ia-32/descriptors.h>
#include <ia-32/instructions.h>

/* interrupt_handlers.s */
extern void common_interrupt_handler(void);
extern void ata_interrupt_handler(void);

GATE_DESCRIPTOR idt[0x2F];

GATE_DESCRIPTOR make_gate(uint16_t selector, void *offset, uint8_t count, uint8_t type);

/*
 * IDTを設定する
 */
void set_idt(void) {
	int i;
	GATE_DESCRIPTOR gate;
	
	/* 無視割込みゲート作成 */
	gate = make_gate(1 * 8, &common_interrupt_handler, 0, DESCRIPTOR_TYPE_INT32);
	
	/* IDT初期化 */
	for (i = 0; i < 0x2E; i++) {
		idt[i] = gate;
	}
	
	/* デバイス割り込み */
	idt[0x2E] = make_gate(1 * 8, &ata_interrupt_handler, 0, DESCRIPTOR_TYPE_INT32);		/* ATA-0 */

	/* IDT登録 */
	lidt(0x2F * 8 - 1, idt);
}

GATE_DESCRIPTOR make_gate(uint16_t selector, void *offset, uint8_t count, uint8_t type) {
	GATE_DESCRIPTOR gate;
	
	gate.offset_low		= (uint16_t)((uint32_t)offset & 0xFFFF);
	gate.selector		= selector;
	gate.count			= count;
	gate.type			= type;
	gate.offset_high	= (uint16_t)((uint32_t)offset >> 16);
	
	return gate;
}
