/*******************************************************************************
 * booter/protected_mode/load.c &
 *                                                                   2012/10/06
 * Copyright (C) 2012 Mochi
 ******************************************************************************/
#include <elf.h>
#include <string.h>

/* バッファ先アドレス */
#define ADDR_BUFFER ((char *)0x200000)

/* ata.c */
extern int read_disk(unsigned int lba, void *buffer, unsigned int sector_size);

/*
 * Kernelを読み込む
 * 戻り値：
 *     成功（Kernelのエントリアドレス）
 *     失敗（NULL)
 */
void *load(void) {
	int i;
	ELF32_EHDR *ehdr;				/* カーネルのELFヘッダ */
	ELF32_PHDR *phdr;				/* カーネルのプログラムヘッダ */
	char *buffer = ADDR_BUFFER;		/* バッファ */
	
	/* MBR読み込み */
	if (read_disk(0, buffer, 1) == -1) {
		return NULL;
	}
	
	/* カーネル読み込み */
	if (read_disk(*((int *)(&buffer[0x1C6])) + 10, buffer, 10) == -1) {
		return NULL;
	}
	
	/* elfファイルチェック */
	ehdr = (ELF32_EHDR *) buffer;
	if (!(ehdr->e_ident[EI_MAG0] == ELFMAG0 &&
		  ehdr->e_ident[EI_MAG1] == ELFMAG1 &&
		  ehdr->e_ident[EI_MAG2] == ELFMAG2 &&
		  ehdr->e_ident[EI_MAG3] == ELFMAG3)) {
		return NULL;
	}
	
	/* 配置 */
	for (i = 0; i < ehdr->e_phnum; i++) {
		/* プログラムヘッダチェック */
		phdr = (ELF32_PHDR *) (&buffer[ehdr->e_phoff + ehdr->e_phentsize * i]);
		if (phdr->p_type != PT_LOAD) {
			continue;
		}
		
		/* コピー */
		memcpy((void *)phdr->p_vaddr, &buffer[phdr->p_offset], phdr->p_filesz);
		
		/* 0でパディング */
		memset(&((char *)phdr->p_vaddr)[phdr->p_filesz], 0, phdr->p_memsz);
	}
	
	return (void *)ehdr->e_entry;
}
