/*******************************************************************************
 * booter/protected_mode/main.c
 *                                                                   2012/10/06
 * Copyright (C) 2012 Mochi
 ******************************************************************************/
#include <stddef.h>
#include <ia-32/instructions.h>

/* idt.c */
extern void set_idt(void);
/* pic.c */
extern void set_pic(void);
/* load.c */
extern void *load(void);

void stop(void);

/*
 * 保護モード処理部の主処理を行う
 */
void main(void) {
	void *kernel;
	stop();
	/* IDT設定 */
	set_idt();
	
	/* PIC設定と割込み有効化 */
	set_pic();
	sti();
	
	/* カーネル読み込み */
	if ((kernel = load()) == NULL) {
		/* 停止 */
		stop();
	}
	
	/* カーネル起動 */
	((void (*)())kernel)();
}

/*
 * 停止する
 */
void stop(void) {
	int i;
	char str[] = "Mochi Booter stopped.";
	
	/* 画面出力 */
	while (str[i] != '\0') {
		*((char *) (0xB8000 + i * 2)) = str[i];
		i++;
	}
	
	while (1) {
		hlt();
	}
}
