/*******************************************************************************
 * include/ia-32/instructions.h
 *                                                                   2012/09/21
 * Copyright (C) 2012 Mochi.
 ******************************************************************************/
#ifndef _INSTRUCTIONS_H_
#define _INSTRUCTIONS_H_

#include <stdint.h>
#include <ia-32/descriptors.h>

static inline uint8_t in_byte(uint16_t port) {
	uint8_t data;
	
	__asm__ __volatile__ (
		"inb	%0, %1"
		:"=a" (data)
		:"dN" (port));		/* edx */
	
	return data;
}

static inline uint16_t in_word(uint16_t port) {
	uint16_t data;
	
	__asm__ __volatile__ (
		"inw	%0, %1"
		:"=a" (data)
		:"dN" (port));		/* edx */
	
	return data;
}

static inline void cli(void) {
	__asm__ __volatile__ ("cli");
}

static inline void hlt(void) {
	__asm__ __volatile__("hlt");
}

static inline void lidt(uint16_t limit, GATE_DESCRIPTOR *base) {
	DESCRIPTOR_REGISTER idtr;
	
	idtr.limit = limit;
	idtr.base = (DESCRIPTOR *) base;
	
	__asm__ __volatile__ (
		"lidt	%0"
		:
		:"m"(*&idtr));
}

static inline void out_byte(uint16_t port, uint8_t data) {
	__asm__ __volatile__ (
		"outb	%0, %1"
		:
		:"dN" (port), "a" (data));		/* edx, eax */
}

static inline void sti(void) {
	__asm__ __volatile__ ("sti");
}

#endif
