#!/usr/bin/perl
#
# Copyright (c) 2012 ISHIKAWA Mutsumi <ishikawa@hanzubon.jp>
# This program is covered by the GNU General Public License 2
#
package Mubot4FB;

use strict;
use utf8;

use POSIX 'strftime';

use Mubot4FB::DB;
use Mubot4FB::FB;
use Mubot4FB::Queue::Client;

use Data::Dumper;

my $mu_re = qr/^([^\s]+)\s+((?:https?|ftps?):\/\/[^\s]+)\s+(.+)$/i;

sub new {
	my $proto = shift;
	my $class = ref $proto || $proto;
	my $self = {cfg => shift};
	bless $self, $class;

	$self->init();
	return $self;
}

sub init {
	my ($me) = @_;
	$me->{fb} = Mubot4FB::FB->new($me->{cfg});
	$me->{db} = Mubot4FB::DB->new($me->{cfg});
	$me->{queue} = Mubot4FB::Queue::Client->new($me->{cfg}, $me->{db}->{dbh});
	$me->misc_init;
	return 1;
}

sub misc_init {
	my ($me) = @_;

	$me->{last_search} = {};
}

sub _format_submit {
	my ($me, $e) = @_;

	return $e->{submitter}.'が『'.$e->{prefix}.' '.$e->{uri}.' '.$e->{comment}.'』と'.strftime('%Y-%m-%d %H:%M:%S', localtime($e->{post_time}));
}

sub _add {
	my ($me, $args)  =@_;
	my ($resp, $resp_msg);

	if ($args->{body} =~ /$mu_re/) {
		my $prefix = $1;
		my $uri = $2;
		my $comment = $3;
		my $text = $args->{who} . '曰く、'.$prefix.' '.$comment;

		if (my $res = $me->{db}->check_dup({uri =>$uri})) {
			if ($res->{post_time} < time() - 7 * 24 * 60 * 60) {
				$resp_msg = 'だいぶ前 '.$me->_format_submit($res).'にいってたにゃー '.$me->{fb}->post_uri($res->{fb_post_id});
			} else {
				$resp_msg = '既に '.$me->_format_submit($res).'に言ってますよ? '.$me->{fb}->post_uri($res->{fb_post_id});
			}
		} else {
			my $post_ok = 1;
			eval{$resp = $me->{fb}->publish($text, $uri)};
			if ($@) {
				warn;
				warn Dumper($resp) if ($me->{cfg}->{debug});
				$me->{fb}->init();
				eval{$resp = $me->{fb}->publish($text, $uri)};
				$post_ok = 0 if ($@);
				warn;
				warn Dumper($resp) if ($me->{cfg}->{debug});
			}

			if ($post_ok) {
				my (undef, $post_id) = split(/_/, $resp->{id});
				my $db_args = {submitter => $args->{who},
					       fb_post_id => $post_id,
					       uri => $uri,
					       prefix => $prefix,
					       comment => $comment};
				$me->{db}->add($db_args);
				if (defined $me->{cfg}->{queues}) {
					foreach my $funcname (@{$me->{cfg}->{queues}}) {
						$me->{queue}->enqueue($funcname, {fb_post_id => $post_id, command => 'add'});
					}
				}
				$resp_msg = $args->{who} . ': うい  '.$me->{fb}->post_uri($post_id).' で登録';
			} else {
				$resp_msg = 'can not post to facebook';
			}
		}
		return $resp_msg;
	}
	return 0;
}

sub _remove_prev {
	my ($me, $args) = @_;

	my $last_post = $me->{db}->search_lastpost_by_submitter({who => $args->{who}});

	if (!defined $last_post) {
		return $args->{who}.': いまのっていつの? というか ないし';
	} elsif ($last_post->{post_time} < time() - 3600) {
		return $args->{who}.': いまのっていつの? 最後のはこれだけど古いんだにゃ ' . $me->{fb}->post_uri($last_post->{fb_post_id});
	} else {
		return $me->_remove($args, $last_post->{'fb_post_id'});
	}
}

sub _remove {
	my ($me, $args, $post_id)  =@_;
	my ($resp_msg, $resp);

	$me->{db}->begin;
	if ($resp = $me->{db}->remove({fb_post_id => $post_id, submitter => $args->{who}})) {
		# fb 側のエントリを削除しないといけない
		if ($me->{fb}->remove($post_id)) {
			$me->{db}->commit;
			if (defined $me->{cfg}->{queues}) {
				foreach my $funcname (@{$me->{cfg}->{queues}}) {
					$me->{queue}->enqueue($funcname, {command => 'remove', fb_post_id => $post_id});
				}
			}
			$resp_msg = $args->{who} . ': 削除しました ' . $me->{fb}->post_uri($post_id);
		} else {
			$me->{db}->rollback;
			$resp_msg = $args->{who} . ': 削除に失敗しましたよ? ' . $me->{fb}->post_uri($post_id);
		}
	} else {
		$me->{db}->rollback;
		$resp_msg = $args->{who} . ': そんな投稿ないよ? ' . $me->{fb}->post_uri($post_id);
	}
	return $resp_msg;
}

sub _search_start {
	my ($me, $args)  = @_;

	if ($args->{body} =~ /^ふみくん\s+(.+)\?\s*$/) {
		$me->{last_search}->{$args->{who}} = undef;
		$me->{last_search}->{$args->{who}} = $me->{db}->search_by_word({word => $1});
		return $me->_search_next($args);
	}
}

sub _search_next {
	my ($me, $args)  = @_;

	my $resp_msg = 'ないっす';
	if (defined $me->{last_search}->{$args->{who}}) {
		my $ent = shift($me->{last_search}->{$args->{who}});
		if ($ent) {
			my $count = @{$me->{last_search}->{$args->{who}}};
			if ($count) {
			}
			$resp_msg = $args->{who} . ': ' . $me->_format_submit($ent).'に言ってた '.($count ? '[ほか'.$count.'件] ' : '[ほかにはもうないよ] ').$me->{fb}->post_uri($ent->{fb_post_id});
		}
	}
	return $resp_msg;
}

sub _not_yet {
	return 'まだ実装してないです';
}

sub getResponse {
	my ($me, $args) = @_;
	my $resp_msg;

	if ($args->{body} =~ /$mu_re/) {
		$resp_msg = $me->_add($args) unless ($1 eq 'deb');
	} elsif ($args->{body} =~ /^ふみくん\s+(.+)\s*$/) {
		my $cmd = $1;
		if ($cmd eq 'いまのなし') {
			$resp_msg = $me->_remove_prev($args);
		} elsif ($cmd =~ /削除\s+(?:$me->{cfg}->{fb_page_url}\/posts\/)?([0-9]+)$/) {
			$resp_msg = $me->_remove($args, $1);
		} elsif ($cmd =~ /\?$/) {
			$resp_msg = $me->_search_start($args);
		} elsif ($cmd =~ /つぎ/) {
			$resp_msg = $me->_search_next($args);
		} elsif ($cmd =~ /どこ/) {
			$resp_msg = $args->{who}.': ここ ' . $me->{cfg}->{fb_page_url};
		} else {
			$resp_msg = $args->{who}.': ん? (' . strftime('%Y-%m-%d %H:%M:%S', localtime) . ')';
		}
	}

	return $resp_msg;
}

1;
