#!/usr/bin/perl
#
# Copyright (c) 2012 ISHIKAWA Mutsumi <ishikawa@hanzubon.jp>
# This program is covered by the GNU General Public License 2
#
package Mubot4FB::TweetWorker;

use strict;
use utf8;

use base 'Mubot4FB::Common';

use Data::Dumper;

use Mubot4FB::Tweet;
use Mubot4FB::DB::TweetMap;

sub init {
	my ($me) = @_;
	$me->{mapdb} = Mubot4FB::DB::TweetMap->new($me->{cfg});
	$me->{db} = Mubot4FB::DB->new($me->{cfg});
	$me->{tw} = Mubot4FB::Tweet->new($me->{cfg});
	return 1;
}

sub compose_text {
	my ($me, $args) = @_;

	return $args->{submitter} . '曰く、'.$args->{prefix}.' '.$args->{comment};
}

sub work {
	my ($me, $job) = @_;

	if ($job->arg->{_command} eq 'remove') {
		my $data = $me->{mapdb}->search_by_key_id({key_id => $job->{arg}->{fb_post_id}});
		if ($data) {
			my $status = $me->{tw}->remove($data->{tweet_id});
			warn Dumper($status) if ($me->{cfg}->{debug});
			$me->{mapdb}->delete_map_by_key_id({key_id => $job->{arg}->{fb_post_id}}) if ($status);
		}
	} else {
		my $text = $me->compose_text($job->arg);
		my $uri = $me->post_uri($job->{arg}->{post_id});

		my $status = $me->{tw}->publish($text, $uri);
		warn Dumper($status) if ($me->{cfg}->{debug});
		$me->{mapdb}->add_map({key_id => $job->{arg}->{post_id},
				       tweet_id => $status->{id},
				       user_id => $status->{in_reply_to_status_id},
				       screen_name => $status->{in_reply_to_screen_name}}) if ($status);
	}
	$job->completed();
}

1;
