#!/usr/bin/perl
#
# Copyright (c) 2012 ISHIKAWA Mutsumi <ishikawa@hanzubon.jp>
# This program is covered by the GNU General Public License 2
#
use strict;
use utf8;

use FindBin;
use lib ("$FindBin::Bin/lib", '/usr/share/mubot4fb/lib');

use Mubot4FB::IRC;
use Mubot4FB::Config;

use Data::Dumper;

my $config_name = $ARGV[0] || 'not_found';

my $c = Mubot4FB::Config->new($config_name);
my $cfg = $c->{cfg};

die 'missing some config parameters should be defined (irc_server, fb_app_id, fb_app_secret, fb_access_code, fb_page_id fb_postback_url)'
  if (!defined $cfg->{'irc_server'}
      || !defined $cfg->{'fb_app_id'}
      || !defined $cfg->{'fb_app_secret'}
      || !defined $cfg->{'fb_access_code'}
      || !defined $cfg->{'fb_page_id'}
      || !defined $cfg->{'fb_postback_url'}
      || !defined $cfg->{'db_user'}
      || !defined $cfg->{'db_pass'}
    );

my $bot = Mubot4FB::IRC->new(server => $cfg->{'irc_server'},
			     port => $cfg->{'irc_port'},
			     channels => $cfg->{'irc_channels'},
			     nick => $cfg->{'irc_nick'},
			     username => $cfg->{'irc_name'},
			     name => $cfg->{'irc_name'},
			     charset => $cfg->{'irc_charset'},
			     cfg => $cfg)->run();

1;
